/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSinkBlock;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenSinkBlock
extends AbstractSinkBlock {
    private static final List<FurnitureBlock> WOOD_SINKS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_SINKS = new ArrayList<FurnitureBlock>();
    private static final VoxelShape FACING_NORTH = Shapes.m_83113_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)KitchenSinkBlock.m_49796_((double)1.0625, (double)11.3, (double)0.296, (double)15.0625, (double)16.3, (double)12.296)), (VoxelShape)Shapes.m_83124_((VoxelShape)KitchenSinkBlock.m_49796_((double)2.0, (double)11.0, (double)2.3, (double)14.0, (double)16.3, (double)11.3), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), KitchenSinkBlock.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)1.0, (double)13.0)}), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape FACING_EAST = Shapes.m_83113_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)KitchenSinkBlock.m_49796_((double)3.704, (double)11.3, (double)1.0625, (double)15.704, (double)16.3, (double)15.0625)), (VoxelShape)Shapes.m_83124_((VoxelShape)KitchenSinkBlock.m_49796_((double)4.7, (double)11.0, (double)2.0, (double)13.7, (double)16.3, (double)14.0), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0), KitchenSinkBlock.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)16.0)}), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape FACING_SOUTH = Shapes.m_83113_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)KitchenSinkBlock.m_49796_((double)0.9375, (double)11.3, (double)3.704, (double)14.9375, (double)16.3, (double)15.704)), (VoxelShape)Shapes.m_83124_((VoxelShape)KitchenSinkBlock.m_49796_((double)2.0, (double)11.0, (double)4.7, (double)14.0, (double)16.3, (double)13.7), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), KitchenSinkBlock.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)4.0)}), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape FACING_WEST = Shapes.m_83113_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)KitchenSinkBlock.m_49796_((double)0.296, (double)11.3, (double)0.9375, (double)12.296, (double)16.3, (double)14.9375)), (VoxelShape)Shapes.m_83124_((VoxelShape)KitchenSinkBlock.m_49796_((double)2.3, (double)11.0, (double)2.0, (double)11.3, (double)16.3, (double)14.0), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenSinkBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0)}), (BooleanOp)BooleanOp.f_82685_);

    public KitchenSinkBlock(BlockBehaviour.Properties settings, Predicate<Biome.Precipitation> precipitationPredicate, Map<Item, CauldronInteraction> map) {
        super(settings, precipitationPredicate, map);
        if (AbstractSittableBlock.isWoodBased(this.m_49966_()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenSinkBlock.class)) {
            WOOD_SINKS.add(new FurnitureBlock((Block)this, "kitchen_sink"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenSinkBlock.class)) {
            STONE_SINKS.add(new FurnitureBlock((Block)this, "kitchen_sink"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodSinks() {
        return WOOD_SINKS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneSinks() {
        return STONE_SINKS.stream();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        switch (dir) {
            case NORTH: {
                return FACING_NORTH;
            }
            case SOUTH: {
                return FACING_SOUTH;
            }
            case EAST: {
                return FACING_EAST;
            }
        }
        return FACING_WEST;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return super.m_6227_(state, world, pos, player, hand, hit);
    }
}

