/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BathtubBlockEntity
extends BedBlockEntity {
    private int fillTimer = 0;
    private boolean isFilling = false;

    public BathtubBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, DyeColor.WHITE);
    }

    public BlockEntityType<?> m_58903_() {
        return BlockEntities.BATHTUB_BLOCK_ENTITY;
    }

    public CompoundTag m_5995_() {
        return this.writeIdentifyingTubData(new CompoundTag());
    }

    private CompoundTag writeIdentifyingTubData(CompoundTag nbt) {
        ResourceLocation identifier = BlockEntityType.m_58954_(this.m_58903_());
        if (identifier == null) {
            throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass()) + " is missing a mapping! This is a bug!");
        }
        nbt.m_128359_("id", identifier.toString());
        nbt.m_128405_("x", this.f_58858_.m_123341_());
        nbt.m_128405_("y", this.f_58858_.m_123342_());
        nbt.m_128405_("z", this.f_58858_.m_123343_());
        nbt.m_128405_("tubTimer", this.fillTimer);
        nbt.m_128379_("isTubFilling", this.isFilling);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        this.fillTimer = nbt.m_128451_("tubTimer");
        this.isFilling = nbt.m_128471_("isTubFilling");
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("tubTimer", this.fillTimer);
        nbt.m_128379_("isTubFilling", this.isFilling);
    }

    public void setFillTimer(int fillTimer) {
        this.fillTimer = fillTimer;
    }

    public void setFilling(boolean isFilling) {
        if (isFilling) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
        this.isFilling = isFilling;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BathtubBlockEntity blockEntity) {
        if (blockEntity.isFilling) {
            if (blockEntity.fillTimer >= 30) {
                blockEntity.setFillTimer(0);
                blockEntity.setFilling(false);
            } else {
                if (world.f_46443_) {
                    BasicBathtubBlock.spawnParticles((Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_), blockEntity.f_58857_, blockEntity.m_58899_());
                }
                ++blockEntity.fillTimer;
            }
        }
    }
}

