/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.BlockItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StoneVariant
extends VariantBase<StoneVariant> {
    private final Block polishedBlock;
    private final Block rawBlock;

    StoneVariant(ResourceLocation identifier, Block polishedBlock, Block rawBlock) {
        super(identifier);
        this.polishedBlock = polishedBlock;
        this.rawBlock = rawBlock;
    }

    public String m_7912_() {
        String postfix = this.isVanilla() ? "" : "_" + this.getNamespace();
        return this.identifier.m_135815_() + postfix;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.rawBlock);
        }
        return ModelHelper.getTextureId(this.polishedBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.m_135815_();
    }

    @Override
    public Block getBaseBlock() {
        return this.polishedBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        return this.rawBlock;
    }

    public Block getRawBlock() {
        return this.rawBlock;
    }

    public String toString() {
        return this.identifier.toString();
    }

    @Override
    public boolean isNetherWood() {
        return this.identifier.m_135815_().contains("warped") || this.identifier.m_135815_().contains("crimson");
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.m_135827_().equals("") || this.identifier.m_135827_().equals("minecraft");
    }

    @Override
    public List<FeatureFlag> getFeatureList() {
        FeatureFlag flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().m_245183_().f_243923_, 0);
        flag.f_244012_ = this.getBaseBlock().m_245183_().f_243922_;
        return List.of(flag);
    }

    @Override
    public StoneVariant getVariantType() {
        return this;
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.f_256975_));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.f_256975_));
        this.addChild("wall", this.findRelatedEntry("fence", BuiltInRegistries.f_256975_));
    }

    @Override
    @Nullable
    public ItemLike getItemForRecipe(String key, Class<? extends Block> blockClass) {
        ItemLike itemConvertible = super.getItemForRecipe(key, blockClass);
        if ((this.identifier.m_135815_().equals("calcite") || this.identifier.m_135815_().equals("netherite")) && (key.equals("base") || key.equals("secondary")) && blockClass.getSimpleName().contains("Kitchen")) {
            if (itemConvertible == this.getBaseBlock()) {
                return this.getSecondaryBlock();
            }
            return this.getBaseBlock();
        }
        return itemConvertible;
    }

    @Override
    public void initializeChildrenItems() {
    }

    public boolean hasStripped() {
        Object child = this.getChild("stripped_log");
        return child != null && child != this.getBaseBlock();
    }

    @Override
    public Block mainChild() {
        return this.polishedBlock;
    }

    public static class Finder
    implements VariantBase.SetFinder<StoneVariant> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> polishedFinder;
        private final Supplier<Block> rawFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> polished, Supplier<Block> raw) {
            this.id = id;
            this.polishedFinder = polished;
            this.rawFinder = raw;
        }

        public static Finder simple(String modId, String stoneTypeName, String polishedName, String rawName) {
            return Finder.simple(new ResourceLocation(modId, stoneTypeName), new ResourceLocation(modId, polishedName), new ResourceLocation(modId, rawName));
        }

        public static Finder simple(ResourceLocation stoneTypeName, ResourceLocation polishedName, ResourceLocation rawName) {
            return new Finder(stoneTypeName, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(polishedName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(rawName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        public Optional<StoneVariant> get() {
            if (BlockItemRegistry.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.polishedFinder.get();
                    Block log = this.rawFinder.get();
                    Block d = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("minecraft", "air"));
                    if (plank != d && log != d && plank != null && log != null) {
                        StoneVariant w = new StoneVariant(this.id, plank, log);
                        for (Map.Entry<String, ResourceLocation> entry : this.childNames.entrySet()) {
                            Object child = BuiltInRegistries.f_256975_.m_6612_(entry.getValue()).isPresent() ? BuiltInRegistries.f_256975_.m_7745_(entry.getValue()) : BuiltInRegistries.f_257033_.m_7745_(entry.getValue());
                            w.addChild(entry.getKey(), child);
                        }
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Failed to find custom stone type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

