/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.BasicShowerHandleBlock;
import com.unlikepaladin.pfm.blocks.BasicShowerHeadBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ShowerHandleItem
extends BlockItem {
    private Supplier<BasicShowerHandleBlock> block;

    public ShowerHandleItem(Supplier<BasicShowerHandleBlock> block, Item.Properties settings) {
        super((Block)block.get(), settings);
        this.block = block;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (player.m_6144_()) {
            stack.m_41751_(null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        super.m_6225_(context);
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof BasicShowerHeadBlock) {
            this.setShowerHeadPosNBT(context.m_43722_(), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        boolean canPlace;
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        LongTag showerHeadLong = ShowerHandleItem.getShowerHead(context.m_43722_());
        Direction playerFacing = context.m_8125_();
        Direction placeDirection = context.m_43719_();
        boolean bl = canPlace = state.m_60734_().m_7898_(state, (LevelReader)world, pos) && placeDirection.m_122434_().m_122479_();
        if (!canPlace) {
            return false;
        }
        if (showerHeadLong != null) {
            BlockPos placedPos;
            BlockPos headPos = BlockPos.m_122022_((long)showerHeadLong.m_7046_());
            double distance = Math.sqrt(headPos.m_203202_((double)(placedPos = pos.m_121945_(playerFacing)).m_123341_() + 0.5, (double)placedPos.m_123342_() + 0.5, (double)placedPos.m_123343_() + 0.5));
            if (distance > 16.0 && world.m_5776_()) {
                context.m_43723_().m_5661_((Component)Component.m_237110_((String)"message.pfm.shower_handle_far", (Object[])new Object[]{headPos.toString()}), false);
            }
            if (distance > 16.0) {
                context.m_43722_().m_41751_(null);
            } else {
                this.setShowerHeadPosNBT(context.m_43722_(), pos.m_121996_((Vec3i)headPos));
            }
            return state.m_60734_().m_7898_(state, (LevelReader)world, pos) && placeDirection.m_122434_().m_122479_();
        }
        return true;
    }

    private void setShowerHeadPosNBT(ItemStack stack, BlockPos pos) {
        LongTag showerHeadPos;
        CompoundTag blockEntityTag;
        CompoundTag nbtCompound = ShowerHandleItem.createNbt(stack);
        if (!nbtCompound.m_128425_("BlockEntityTag", 10)) {
            nbtCompound.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        if (!(blockEntityTag = nbtCompound.m_128469_("BlockEntityTag")).m_128425_("showerHead", 4)) {
            blockEntityTag.m_128365_("showerHead", (Tag)LongTag.m_128882_((long)0L));
        }
        if ((showerHeadPos = (LongTag)blockEntityTag.m_128423_("showerHead")).m_7046_() != pos.m_121878_()) {
            blockEntityTag.m_128365_("showerHead", (Tag)LongTag.m_128882_((long)pos.m_121878_()));
        }
    }

    @Nullable
    public static LongTag getShowerHead(ItemStack stack) {
        CompoundTag blockEntityTag;
        CompoundTag stackNbt;
        if (stack.m_41782_() && (stackNbt = stack.m_41783_()).m_128425_("BlockEntityTag", 10) && (blockEntityTag = stackNbt.m_128469_("BlockEntityTag")).m_128425_("showerHead", 4)) {
            return (LongTag)blockEntityTag.m_128423_("showerHead");
        }
        return null;
    }

    private static CompoundTag createNbt(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (stack.m_41782_() && ShowerHandleItem.getShowerHead(stack) != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.pfm.shower_handle_connected", (Object[])new Object[]{1}));
        }
        super.m_7373_(stack, world, tooltip, context);
    }
}

