/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.ClassicDeskCabinetBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicDeskBlock
extends HorizontalDirectionalBlock {
    private final Block baseBlock;
    private static final List<FurnitureBlock> WOOD_CLASSIC_DESKS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CLASSIC_DESKS = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    public final FurnitureBlock deskBlock;
    static final VoxelShape TABLE_CLASSIC_BASE = ClassicDeskBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_EAST_LEG = ClassicDeskBlock.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_EAST_NORTH = ClassicDeskBlock.m_49796_((double)13.0, (double)2.0, (double)0.0, (double)15.0, (double)4.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_EAST = ClassicDeskBlock.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)16.0, (double)4.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_WEST_LEG = ClassicDeskBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_WEST_LEG = ClassicDeskBlock.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_EAST_LEG = ClassicDeskBlock.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_EAST = ClassicDeskBlock.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)4.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_EAST = ClassicDeskBlock.m_49796_((double)13.0, (double)2.0, (double)3.0, (double)15.0, (double)4.0, (double)13.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_WEST = ClassicDeskBlock.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)3.0, (double)4.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_NORTH = ClassicDeskBlock.m_49796_((double)3.0, (double)2.0, (double)1.0, (double)13.0, (double)4.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_WEST_NORTH = ClassicDeskBlock.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)3.0, (double)4.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_WEST_SOUTH = ClassicDeskBlock.m_49796_((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)4.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_WEST = ClassicDeskBlock.m_49796_((double)1.0, (double)2.0, (double)3.0, (double)3.0, (double)4.0, (double)13.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public ClassicDeskBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)this.m_49965_().m_61090_());
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        this.deskBlock = new FurnitureBlock((Block)this, "desk_classic");
        if (AbstractSittableBlock.isWoodBased(this.m_49966_()) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicDeskBlock.class)) {
            WOOD_CLASSIC_DESKS.add(this.deskBlock);
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicDeskBlock.class)) {
            STONE_CLASSIC_DESKS.add(this.deskBlock);
        }
    }

    public static Stream<FurnitureBlock> streamWoodClassicDesks() {
        return WOOD_CLASSIC_DESKS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicDesks() {
        return STONE_CLASSIC_DESKS.stream();
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(this.m_49966_())) {
            return 20;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public boolean canConnect(BlockState blockState) {
        if (blockState.m_60734_() instanceof ClassicDeskCabinetBlock && !PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect()) {
            return this.deskBlock.getBaseMaterial() == ((ClassicDeskCabinetBlock)blockState.m_60734_()).deskCabinetBlock.getBaseMaterial();
        }
        if (blockState.m_60734_() instanceof ClassicDeskCabinetBlock) {
            return true;
        }
        if (blockState.m_60734_() instanceof ClassicDeskBlock && !PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect()) {
            return this.deskBlock.getBaseMaterial() == ((ClassicDeskBlock)blockState.m_60734_()).deskBlock.getBaseMaterial();
        }
        return blockState.m_60734_() instanceof ClassicDeskBlock;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Boolean north = this.canConnect(world.m_8055_(pos.m_122012_()));
        boolean east = this.canConnect(world.m_8055_(pos.m_122029_()));
        boolean west = this.canConnect(world.m_8055_(pos.m_122024_()));
        boolean south = this.canConnect(world.m_8055_(pos.m_122019_()));
        String key = north.toString() + east + west + south;
        if (!VOXEL_SHAPES.containsKey(key)) {
            ClassicDeskBlock.generateVoxelShape(key, north, east, west, south);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south) {
        VoxelShape newVoxelShape = TABLE_CLASSIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.m_83124_((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_CLASSIC_NORTH_EAST_LEG, TABLE_CLASSIC_SOUTH_WEST_LEG, TABLE_CLASSIC_SOUTH_EAST_LEG, TABLE_CLASSIC_NORTH_WEST_LEG});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_EAST_LEG);
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_WEST_LEG);
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_EAST_LEG);
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_WEST_LEG);
        }
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canConnect(BlockGetter world, BlockState state, BlockPos neighborPos, BlockPos pos) {
        BlockState neighborState = world.m_8055_(neighborPos);
        if (neighborState.m_61138_((Property)f_54117_)) {
            return this.canConnect(neighborState);
        }
        return false;
    }
}

