/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DinnerTableBlock
extends HorizontalDirectionalBlock {
    private final Block baseBlock;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_DINNER_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DINNER_TABLES = new ArrayList<FurnitureBlock>();
    static final VoxelShape dinner_table = Shapes.m_83124_((VoxelShape)DinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{DinnerTableBlock.m_49796_((double)0.1, (double)0.0, (double)2.0, (double)15.8, (double)14.0, (double)4.05), DinnerTableBlock.m_49796_((double)0.1, (double)0.0, (double)11.9, (double)15.8, (double)14.0, (double)13.95)});
    static final VoxelShape dinner_table_middle = Shapes.m_83124_((VoxelShape)DinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape dinner_table_one_east = Shapes.m_83110_((VoxelShape)DinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)DinnerTableBlock.m_49796_((double)0.1, (double)0.0, (double)2.0, (double)15.8, (double)14.0, (double)4.05));
    static final VoxelShape dinner_table_one_south = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.WEST, dinner_table_one_east);
    static final VoxelShape dinner_table_one = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, dinner_table_one_east);
    static final VoxelShape dinner_table_one_west = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, dinner_table_one_east);
    static final VoxelShape dinner_table_east = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, dinner_table);

    public DinnerTableBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if (AbstractSittableBlock.isWoodBased(this.m_49966_()) && ((Object)((Object)this)).getClass().isAssignableFrom(DinnerTableBlock.class)) {
            WOOD_DINNER_TABLES.add(new FurnitureBlock((Block)this, "table_dinner"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(DinnerTableBlock.class)) {
            STONE_DINNER_TABLES.add(new FurnitureBlock((Block)this, "table_dinner"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodDinnerTables() {
        return WOOD_DINNER_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneDinnerTables() {
        return STONE_DINNER_TABLES.stream();
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof DinnerTableBlock : blockState.m_60734_() == this;
    }

    public boolean isTable(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        if (this.canConnect(state)) {
            Direction sourceDirection = (Direction)state.m_61143_((Property)FACING);
            return sourceDirection.equals((Object)tableDirection);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.NORTH) || dir.equals((Object)Direction.SOUTH);
        boolean dirWestOrEast = dir.equals((Object)Direction.WEST) || dir.equals((Object)Direction.EAST);
        boolean left = this.isTable(view, pos, dir.m_122428_(), dir);
        boolean right = this.isTable(view, pos, dir.m_122427_(), dir);
        if (left && right) {
            return dinner_table_middle;
        }
        if (left) {
            if (dirNorthOrSouth) {
                return dinner_table_one;
            }
            if (dirWestOrEast) {
                return dinner_table_one_east;
            }
            return dinner_table;
        }
        if (right) {
            if (dirNorthOrSouth) {
                return dinner_table_one_south;
            }
            if (dirWestOrEast) {
                return dinner_table_one_west;
            }
            return dinner_table;
        }
        if (dirWestOrEast) {
            return dinner_table;
        }
        return dinner_table_east;
    }
}

