/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.blockentities.DyeableFurnitureBlockEntity;
import com.unlikepaladin.pfm.blocks.blockentities.forge.LampBlockEntityImpl;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LampBlockEntity
extends BlockEntity
implements DyeableFurnitureBlockEntity {
    protected WoodVariant variant;
    protected DyeColor color = DyeColor.WHITE;

    public LampBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.LAMP_BLOCK_ENTITY, pos, state);
        this.variant = WoodVariantRegistry.OAK;
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt.m_128425_("color", 8)) {
            this.color = DyeColor.m_41057_((String)nbt.m_128461_("color"), (DyeColor)DyeColor.WHITE);
        }
        if (nbt.m_128425_("variant", 8)) {
            String variantName = nbt.m_128461_("variant");
            if (WoodVariantRegistry.getVariant(ResourceLocation.m_135820_((String)variantName)) != null) {
                this.variant = WoodVariantRegistry.getVariant(ResourceLocation.m_135820_((String)variantName));
            } else {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find variant for lamp: {}", (Object)variantName);
                this.variant = WoodVariantRegistry.OAK;
            }
        }
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("color", this.color.m_7912_());
        nbt.m_128359_("variant", this.variant.getIdentifier().toString());
    }

    public CompoundTag writeColorAndVariant(CompoundTag nbt) {
        CompoundTag newNBT = this.writeColor(nbt);
        newNBT.m_128359_("variant", this.variant.getIdentifier().toString());
        return newNBT;
    }

    @Override
    public CompoundTag writeColor(CompoundTag nbt) {
        nbt.m_128359_("color", this.color.m_7912_());
        return nbt;
    }

    public BlockEntity getEntity() {
        return this;
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    @Override
    public void setPFMColor(DyeColor color) {
        this.color = color;
    }

    public void setVariant(WoodVariant variant) {
        this.variant = variant;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends LampBlockEntity> getFactory() {
        return LampBlockEntityImpl.getFactory();
    }
}

