/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.blockentities.forge.StoveBlockEntityImpl;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StoveBlockEntity
extends AbstractFurnaceBlockEntity {
    String blockname = this.m_58900_().m_60734_().m_7705_();
    protected final NonNullList<ItemStack> itemsBeingCooked = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.STOVE_BLOCK_ENTITY, pos, state, RecipeType.f_44110_);
    }

    public StoveBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state, RecipeType.f_44110_);
    }

    protected void onContainerOpen(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.f_12012_);
            this.setOpen(state, true);
        }
    }

    protected void onContainerClose(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.f_12011_);
            this.setOpen(state, false);
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.onContainerClose(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.onContainerOpen(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected Component m_6820_() {
        this.blockname = this.blockname.replace("block.pfm", "");
        if (this.m_58900_().m_60734_() instanceof KitchenCounterOvenBlock) {
            return Component.m_237115_((String)"container.pfm.kitchen_counter_oven");
        }
        return Component.m_237115_((String)("container.pfm" + this.blockname));
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new StoveScreenHandler(syncId, playerInventory, (Container)this, this.f_58311_);
    }

    public NonNullList<ItemStack> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    public Optional<CampfireCookingRecipe> getRecipeFor(ItemStack item) {
        if (this.itemsBeingCooked.stream().noneMatch(ItemStack::m_41619_)) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{item}), this.f_58857_);
    }

    public void m_142466_(CompoundTag nbt) {
        int[] is;
        super.m_142466_(nbt);
        this.itemsBeingCooked.clear();
        StoveBlockEntity.readNbt(nbt, this.itemsBeingCooked);
        if (nbt.m_128425_("CookingTimes", 11)) {
            is = nbt.m_128465_("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.m_128425_("CookingTotalTimes", 11)) {
            is = nbt.m_128465_("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveInitialChunkData(nbt);
        nbt.m_128385_("CookingTimes", this.cookingTimes);
        nbt.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
    }

    protected CompoundTag saveInitialChunkData(CompoundTag nbt) {
        super.m_183515_(nbt);
        StoveBlockEntity.writeNbt(nbt, this.itemsBeingCooked, true);
        return nbt;
    }

    public static CompoundTag writeNbt(CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        ListTag nbtList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemStack = (ItemStack)stacks.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty() || setIfEmpty) {
            nbt.m_128365_("CookTopItems", (Tag)nbtList);
        }
        return nbt;
    }

    public static void readNbt(CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ListTag nbtList = nbt.m_128437_("CookTopItems", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= stacks.size()) continue;
            stacks.set(j, (Object)ItemStack.m_41712_((CompoundTag)nbtCompound));
        }
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = ((ItemStack)this.itemsBeingCooked.get(slot)).m_41777_();
        this.itemsBeingCooked.set(slot, (Object)ItemStack.f_41583_);
        this.updateListeners();
        return stack;
    }

    public void m_6211_() {
        this.itemsBeingCooked.clear();
    }

    private void updateListeners() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static void litServerTick(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)blockEntity;
            boolean bl = false;
            for (int i = 0; i < stoveBlockEntity.itemsBeingCooked.size(); ++i) {
                ItemStack itemStack = (ItemStack)stoveBlockEntity.itemsBeingCooked.get(i);
                if (itemStack.m_41619_()) continue;
                bl = true;
                int n = i;
                if (stoveBlockEntity.cookingTimes[n] < 600) {
                    stoveBlockEntity.cookingTimes[n] = stoveBlockEntity.cookingTimes[n] + 2;
                }
                if (stoveBlockEntity.cookingTimes[i] < stoveBlockEntity.cookingTotalTimes[i]) continue;
                SimpleContainer inventory = new SimpleContainer(new ItemStack[]{itemStack});
                ItemStack itemStack2 = world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)inventory, world).map(campfireCookingRecipe -> campfireCookingRecipe.m_5874_((Container)inventory, world.m_9598_())).orElse(itemStack);
                if (PaladinFurnitureMod.getPFMConfig().doesFoodPopOffStove()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack2);
                    stoveBlockEntity.itemsBeingCooked.set(i, (Object)ItemStack.f_41583_);
                } else {
                    stoveBlockEntity.itemsBeingCooked.set(i, (Object)itemStack2);
                }
                world.m_7260_(pos, state, state, 3);
            }
            if (bl) {
                StoveBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            }
            StoveBlockEntity.m_155013_((Level)world, (BlockPos)pos, (BlockState)state, (AbstractFurnaceBlockEntity)stoveBlockEntity);
        }
    }

    public static void unlitServerTick(Level world, BlockPos pos, BlockState state, StoveBlockEntity stoveBlockEntity) {
        boolean bl = false;
        for (int i = 0; i < stoveBlockEntity.itemsBeingCooked.size(); ++i) {
            if (stoveBlockEntity.cookingTimes[i] <= 0) continue;
            bl = true;
            stoveBlockEntity.cookingTimes[i] = Mth.m_14045_((int)(stoveBlockEntity.cookingTimes[i] - 2), (int)0, (int)stoveBlockEntity.cookingTotalTimes[i]);
        }
        if (bl) {
            StoveBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        StoveBlockEntity.m_155013_((Level)world, (BlockPos)pos, (BlockState)state, (AbstractFurnaceBlockEntity)stoveBlockEntity);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBlockEntity = (StoveBlockEntity)blockEntity;
            RandomSource random = world.f_46441_;
            int i = ((Direction)state.m_61143_((Property)StoveBlock.f_48683_)).m_122427_().m_122416_();
            for (int j = 0; j < stoveBlockEntity.itemsBeingCooked.size(); ++j) {
                ItemStack stack = (ItemStack)stoveBlockEntity.itemsBeingCooked.get(j);
                if (stack.m_41619_() || !(random.m_188501_() < 0.2f) || world.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), world).isEmpty()) continue;
                Direction direction = Direction.m_122407_((int)Math.floorMod(j + i, 4));
                float f = 0.2125f;
                double x = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * f + (float)direction.m_122427_().m_122429_() * f);
                double y = (double)pos.m_123342_() + 1.1;
                double z = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * f + (float)direction.m_122427_().m_122431_() * f);
                for (int k = 0; k < 4; ++k) {
                    if (random.m_188501_() < 0.9f) continue;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public boolean addItem(ItemStack item, int integer) {
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemsBeingCooked.get(i);
            if (!itemStack.m_41619_()) continue;
            this.cookingTotalTimes[i] = integer;
            this.cookingTimes[i] = 0;
            this.itemsBeingCooked.set(i, (Object)item.m_41620_(1));
            this.updateListeners();
            return true;
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends BlockEntity> getFactory() {
        return StoveBlockEntityImpl.getFactory();
    }
}

