/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.ExtraCounterVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.mixin.PFMSpriteContentsAccessor;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.runtime.TextureReloadQueue;
import de.androidpit.colorthief.ColorThief;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ModelHelper {
    public static List<TextureAtlasSprite> OAK_SPRITES_PLANKS_TO_REPLACE = null;
    public static List<TextureAtlasSprite> OAK_SPRITES_BED_TO_REPLACE = null;
    public static List<TextureAtlasSprite> OAK_SPRITES_LOG_TOP_TO_REPLACE = null;
    public static Set<ResourceLocation> GENERATED_TEXTURE_IDS = new HashSet<ResourceLocation>();
    static Map<Pair<ResourceLocation, Integer>, int[][]> paletteCache = new HashMap<Pair<ResourceLocation, Integer>, int[][]>();
    public static final Map<Pair<String, String>, Pair<ResourceLocation, Integer>> blockToTextureMap = new HashMap<Pair<String, String>, Pair<ResourceLocation, Integer>>();
    private static final HashMap<ResourceLocation, Boolean> idCacheMap = new HashMap();

    public static List<TextureAtlasSprite> getOakPlankLogSprites() {
        if (OAK_SPRITES_PLANKS_TO_REPLACE == null) {
            Material planksId = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/oak_planks"));
            Material logId = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/oak_log"));
            OAK_SPRITES_PLANKS_TO_REPLACE = Arrays.asList(planksId.m_119204_(), logId.m_119204_());
        }
        return OAK_SPRITES_PLANKS_TO_REPLACE;
    }

    public static List<TextureAtlasSprite> getOakBedSprites() {
        if (OAK_SPRITES_BED_TO_REPLACE == null) {
            Material planksId = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/oak_planks"));
            Material bedId = Sheets.f_110744_[DyeColor.RED.m_41060_()];
            OAK_SPRITES_BED_TO_REPLACE = Arrays.asList(planksId.m_119204_(), bedId.m_119204_());
        }
        return OAK_SPRITES_BED_TO_REPLACE;
    }

    public static List<TextureAtlasSprite> getOakLogLogTopSprites() {
        if (OAK_SPRITES_LOG_TOP_TO_REPLACE == null) {
            Material logId = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/oak_log"));
            Material logTopId = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/oak_log_top"));
            OAK_SPRITES_LOG_TOP_TO_REPLACE = Arrays.asList(logId.m_119204_(), logTopId.m_119204_());
        }
        return OAK_SPRITES_LOG_TOP_TO_REPLACE;
    }

    public static boolean containsIdentifier(ResourceLocation[] modelIds, ResourceLocation comparison) {
        AtomicBoolean contains = new AtomicBoolean(false);
        Arrays.stream(modelIds).forEach(identifier -> {
            if (comparison.m_135815_().equals(identifier.m_135815_()) && comparison.m_135827_().equals(identifier.m_135827_())) {
                contains.set(true);
            }
        });
        return contains.get();
    }

    public static void generateTexture(TextureAtlasSprite baseTexture, TextureAtlasSprite color, int colorCount, ResourceLocation id) {
        if (GENERATED_TEXTURE_IDS.contains(id)) {
            return;
        }
        GENERATED_TEXTURE_IDS.add(id);
        int[] basePalette = ModelHelper.convertPaletteToColorArray(ModelHelper.generatePalette(baseTexture, colorCount));
        int[] colorPalette = ModelHelper.convertPaletteToColorArray(ModelHelper.generatePalette(color, colorCount));
        Integer[] base = (Integer[])Arrays.stream(basePalette).boxed().toArray(Integer[]::new);
        Integer[] target = (Integer[])Arrays.stream(colorPalette).boxed().toArray(Integer[]::new);
        Arrays.sort(base, Comparator.comparingDouble(ModelHelper::luminance));
        Arrays.sort(target, Comparator.comparingDouble(ModelHelper::luminance));
        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < basePalette.length; ++i) {
            colorMap.put(base[i], target[i]);
        }
        TextureReloadQueue.recolorAndWriteImage(id, ModelHelper.getSpriteBufferedImage(baseTexture), colorMap);
    }

    static double luminance(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static ResourceLocation getTextureSpritePath(ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), String.format("textures/%s%s", id.m_135815_(), ".png"));
    }

    public static int[] convertPaletteToColorArray(int[][] palette) {
        int[] colors = new int[palette.length];
        for (int i = 0; i < palette.length; ++i) {
            colors[i] = ModelHelper.convertColor(palette[i]);
        }
        return colors;
    }

    public static int convertColor(int[] color) {
        int r = color[0];
        int g = color[1];
        int b = color[2];
        return r << 16 | g << 8 | b;
    }

    public static int[][] generatePalette(TextureAtlasSprite texture, int colorCount) {
        if (texture == null) {
            return null;
        }
        if (paletteCache.containsKey(Pair.of((Object)texture.m_245424_().m_246162_(), (Object)colorCount))) {
            return paletteCache.get(Pair.of((Object)texture.m_245424_().m_246162_(), (Object)colorCount));
        }
        BufferedImage image = ModelHelper.getSpriteBufferedImage(texture);
        int[][] palette = ColorThief.getPalette((BufferedImage)image, (int)colorCount, (int)5, (boolean)false);
        paletteCache.put((Pair<ResourceLocation, Integer>)new Pair((Object)texture.m_245424_().m_246162_(), (Object)colorCount), palette);
        String filename = texture.m_245424_().m_246162_().m_135827_().replace("/", "") + "_" + texture.m_245424_().m_246162_().m_135815_().replace("/", "") + "_original.png";
        return palette;
    }

    public static void writePaletteToImage(int[][] palette, String filename) throws IOException {
        int width = palette.length;
        int height = 1;
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] convertedPalette = ModelHelper.convertPaletteToColorArray(palette);
        Arrays.sort(convertedPalette);
        for (int x = 0; x < width; ++x) {
            image.setRGB(x, 0, convertedPalette[x]);
        }
        ModelHelper.writeBufferedImageToFile(image, filename);
    }

    public static void writeBufferedImageToFile(BufferedImage image, String filename) {
        try {
            File file = new File(filename);
            file.createNewFile();
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Error while writing image to file", (Throwable)e);
        }
    }

    public static BufferedImage getSpriteBufferedImage(TextureAtlasSprite sprite) {
        int width = sprite.m_245424_().m_246492_();
        int height = sprite.m_245424_().m_245330_();
        sprite.m_118416_();
        NativeImage atlasImage = ((PFMSpriteContentsAccessor)sprite.m_245424_()).pfm$getImages()[0];
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int abgr = atlasImage.m_84985_(i, j);
                int argb = ModelHelper.abgrToArgb(abgr);
                bufferedImage.setRGB(i, j, argb);
            }
        }
        return bufferedImage;
    }

    public static int abgrToArgb(int abgr) {
        int a = abgr >> 24 & 0xFF;
        int b = abgr >> 16 & 0xFF;
        int g = abgr >> 8 & 0xFF;
        int r = abgr & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int argbToRgbaInt(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static BufferedImage nativeImageToBufferedImage(NativeImage nativeImage) {
        int width = nativeImage.m_84982_();
        int height = nativeImage.m_85084_();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int abgr = nativeImage.m_84985_(x, y);
                int argb = ModelHelper.abgrToArgb(abgr);
                bufferedImage.setRGB(x, y, argb);
            }
        }
        return bufferedImage;
    }

    public static BlockType getBlockType(ResourceLocation identifier) {
        if (identifier.m_135815_().contains("stripped_")) {
            return BlockType.STRIPPED_LOG;
        }
        for (WoodVariant variant : WoodVariantRegistry.getVariants()) {
            if (!identifier.m_135815_().contains(variant.getPath())) continue;
            return BlockType.PLANKS;
        }
        return BlockType.BLOCK;
    }

    public static VariantBase<?> getVariant(ResourceLocation identifier) {
        VariantBase var = ModelHelper.getExtraCounterType(identifier);
        if (var == null) {
            var = ModelHelper.getStoneType(identifier);
        }
        if (var == null) {
            var = ModelHelper.getWoodType(identifier);
        }
        return var;
    }

    @Nullable
    public static ExtraCounterVariant getExtraCounterType(ResourceLocation identifier) {
        for (ExtraCounterVariant variant : ExtraCounterVariant.values()) {
            if (!identifier.m_135815_().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    @Nullable
    public static StoneVariant getStoneType(ResourceLocation identifier) {
        for (StoneVariant variant : StoneVariantRegistry.getVariants()) {
            if (!identifier.m_135815_().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    public static WoodVariant getWoodType(ResourceLocation identifier) {
        WoodVariant selectedVariant = null;
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            if (!identifier.m_135815_().contains(woodVariant.identifier.m_135815_()) || identifier.m_135815_().contains("dark") && !woodVariant.identifier.m_135815_().contains("dark") || !identifier.m_135815_().contains(woodVariant.getNamespace()) && !woodVariant.isVanilla()) continue;
            selectedVariant = woodVariant;
        }
        return selectedVariant != null ? selectedVariant : WoodVariantRegistry.OAK;
    }

    public static DyeColor getColor(ResourceLocation identifier) {
        Object object = BuiltInRegistries.f_256975_.m_7745_(identifier);
        if (object instanceof DyeableFurnitureBlock) {
            DyeableFurnitureBlock block = (DyeableFurnitureBlock)object;
            return block.getPFMColor();
        }
        for (DyeColor color : DyeColor.values()) {
            if (!identifier.m_135815_().contains(color.m_41065_()) || !identifier.m_135815_().contains("light") && color.m_41065_().contains("light") || identifier.m_135815_().contains("light") && !color.m_41065_().contains("light")) continue;
            return color;
        }
        return DyeColor.RED;
    }

    public static ResourceLocation getVanillaConcreteColor(ResourceLocation identifier) {
        DyeColor color = ModelHelper.getColor(identifier);
        if (!identifier.m_135815_().contains(color.m_41065_())) {
            return new ResourceLocation("minecraft", "block/white_concrete");
        }
        return new ResourceLocation("minecraft", "block/" + color.m_41065_() + "_concrete");
    }

    public static Block getWoolColor(String string) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("minecraft", string + "_wool"));
        if (block != Blocks.f_50016_) {
            return block;
        }
        return Blocks.f_50041_;
    }

    public static ResourceLocation getTextureId(Block block) {
        return ModelHelper.getTextureId(block, "");
    }

    public static ResourceLocation getTextureId(Block block, String postfix) {
        BakedModel model;
        ResourceLocation id;
        Pair pair;
        if (postfix.isEmpty()) {
            postfix = null;
        }
        if (blockToTextureMap.containsKey(pair = new Pair((Object)block.toString(), (Object)postfix)) && (blockToTextureMap.get(pair).getFirst() != MissingTextureAtlasSprite.m_118071_() || (Integer)blockToTextureMap.get(pair).getSecond() > 3)) {
            return (ResourceLocation)blockToTextureMap.get(pair).getFirst();
        }
        int attemptNum = 1;
        if (blockToTextureMap.containsKey(pair)) {
            attemptNum += ((Integer)blockToTextureMap.get(pair).getSecond()).intValue();
        }
        if (postfix == null) {
            postfix = "";
        }
        if (postfix.isEmpty() && !PFMDataGenerator.areAssetsRunning()) {
            List quadList;
            BakedModel model2 = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(block.m_49966_());
            if (model2 != null && !(quadList = model2.m_213637_(block.m_49966_(), Direction.NORTH, RandomSource.m_216335_((long)42L))).isEmpty() && (id = ((BakedQuad)quadList.get(0)).m_173410_().m_245424_().m_246162_()) != null && id != MissingTextureAtlasSprite.m_118071_()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        } else if (postfix.equals("_top") && !PFMDataGenerator.areAssetsRunning() && (model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(block.m_49966_())) != null) {
            List quadList = model.m_213637_(block.m_49966_(), Direction.UP, RandomSource.m_216335_((long)42L));
            if (!quadList.isEmpty() && (id = ((BakedQuad)quadList.get(0)).m_173410_().m_245424_().m_246162_()) != null && id != MissingTextureAtlasSprite.m_118071_()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
            quadList = model.m_213637_(block.m_49966_(), Direction.DOWN, RandomSource.m_216335_((long)42L));
            if (!quadList.isEmpty() && (id = ((BakedQuad)quadList.get(0)).m_173410_().m_245424_().m_246162_()) != null && id != MissingTextureAtlasSprite.m_118071_()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        }
        if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)postfix), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)postfix);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, postfix), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, postfix);
        } else if (ModelHelper.idExists(TextureMapping.m_125740_((Block)block), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125740_((Block)block);
        } else if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)"_side"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)"_side");
        } else if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)"_side_1"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)"_side_1");
        } else if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)"_bottom"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)"_bottom");
        } else if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)"_top"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)"_top");
        } else if (ModelHelper.idExists(TextureMapping.m_125753_((Block)block, (String)"_middle"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = TextureMapping.m_125753_((Block)block, (String)"_middle");
        } else if (ModelHelper.idExists(ModelHelper.getPlankId(block), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getPlankId(block);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side_1"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side_1");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_top"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_top");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_middle"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_middle");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_bottom"), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_bottom");
        } else if (BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135827_().equals("quark")) {
            id = TextureMapping.m_125753_((Block)block, (String)postfix);
        } else {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find texture for, {}, this is attempt {} at finding it", (Object)block, (Object)attemptNum);
            id = MissingTextureAtlasSprite.m_118071_();
        }
        blockToTextureMap.put((Pair<String, String>)pair, (Pair<ResourceLocation, Integer>)new Pair((Object)id, (Object)attemptNum));
        return id;
    }

    public static ResourceLocation getPlankId(Block block) {
        ResourceLocation identifier = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = identifier.m_135827_();
        Object path = identifier.m_135815_().replace("luphie_", "");
        if (((String)path).contains("planks")) {
            ResourceLocation id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("_planks", "").replace("plank_", "")) + "/planks");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = "planks_" + (String)path;
            if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
                path = ((String)path).replace("ultra_", "").replace("_ultra", "");
                path = "ultra_space/" + (String)path;
            }
            if (namespace.equals("blue_skies")) {
                path = "wood/" + (String)path;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path);
            path = ((String)path).replace("mining", "mine").replace("sorting", "sort").replace("transformation", "trans").replace("dark", "darkwood").replace("alpha_", "alpha_oak_").replace("flowering_pink", "flowerypink").replace("flowering_purple", "floweringpurple");
            ResourceLocation id2 = new ResourceLocation(namespace, "block/wood/" + (String)path);
            ResourceLocation id3 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "planks");
            ResourceLocation id4 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "_planks");
            ResourceLocation id5 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "plankstext");
            ResourceLocation id6 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "plankretext");
            ResourceLocation id7 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "_planks0");
            ResourceLocation id8 = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks_", "") + "_planks1");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            if (ModelHelper.idExists(id2, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id2;
            }
            if (ModelHelper.idExists(id3, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id3;
            }
            if (ModelHelper.idExists(id4, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id4;
            }
            if (ModelHelper.idExists(id5, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id5;
            }
            if (ModelHelper.idExists(id6, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id6;
            }
            if (ModelHelper.idExists(id7, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id7;
            }
            if (ModelHelper.idExists(id8, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id8;
            }
            return new ResourceLocation(namespace, "block/wood/" + (String)path + "_0");
        }
        return new ResourceLocation(namespace, "block/" + (String)path);
    }

    public static ResourceLocation getLogId(Block block, String postFix) {
        ResourceLocation id;
        ResourceLocation identifier = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String namespace = identifier.m_135827_();
        Object path = identifier.m_135815_().replace("luphie_", "");
        if (namespace.contains("luphieclutteredmod") && ((String)path).contains("flowering_log")) {
            path = ((String)path).replace("flowering_log", "flowering_yellow_log");
        }
        if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
            path = ((String)path).replace("ultra_", "").replace("_ultra", "");
            path = "ultra_space/" + (String)path;
        }
        if (namespace.equals("blue_skies")) {
            path = "wood/" + (String)path;
        }
        if (namespace.equals("byg") && ((String)path).contains("pedu")) {
            path = ((String)path).replace("pedu", "log");
        }
        if (((String)path).contains("log") || ((String)path).contains("stem")) {
            if (!((String)path).contains("_log")) {
                path = ((String)path).replace("log", "_log");
            }
            if (ModelHelper.idExists(id = new ResourceLocation(namespace, "block/" + (String)path), PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("stem", "log").replace("log", "bark");
            path = (String)path + postFix;
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("stripped", "striped")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("striped", "stripped");
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("bark", "log")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("stripped", "striped")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).contains("striped") ? "stripped_" + ((String)path).replace("_striped", "") : path));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("stripped", "striped")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            String loc = identifier.m_135815_().contains("stripped") || identifier.m_135815_().contains("striped") ? "stripped_log" : "log";
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("striped_", "").replace(postFix, "").replace("_log", "")) + "/" + loc + postFix);
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "/" + loc.replace("log", "stem") + postFix);
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "/" + loc + "/" + postFix.replace("_", ""));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "/" + loc.replace("log", "stem") + "/" + postFix.replace("_", ""));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "/" + loc);
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "/" + loc.replace("log", "stem"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/stripped_" + (String)path + "_log");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/stripped_" + (String)path + "_stem");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "_log_stripped");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)path + "_stem_stripped");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        } else if (((String)path).contains("reed")) {
            id = new ResourceLocation(namespace, "block/" + (String)(path = ((String)path).replace("nether_", "").replace("reed", "reeds")));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = (String)path + postFix));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + ((String)path).replace("planks", "roof"));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        }
        if (((String)path).contains("alpha_") && namespace.contains("regions")) {
            id = new ResourceLocation(namespace, "block/" + (String)(path = !((String)path).contains("alpha_oak") ? ((String)path).replace("alpha", "alpha_oak") : path));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/" + (String)(path = (String)path + postFix));
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/alpha_oak_log" + postFix);
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
            id = new ResourceLocation(namespace, "block/alpha_oak_log");
            if (ModelHelper.idExists(id, PackType.CLIENT_RESOURCES, IdLocation.TEXTURES)) {
                return id;
            }
        }
        return new ResourceLocation(namespace, "block/" + (String)path);
    }

    public static boolean idExists(ResourceLocation id, PackType resourceType, IdLocation idLocation) {
        if (idCacheMap.containsKey(id)) {
            return idCacheMap.get(id);
        }
        ResourceLocation id2 = new ResourceLocation(id.m_135827_(), idLocation.m_7912_() + "/" + id.m_135815_() + idLocation.getFileType());
        AtomicBoolean exists = new AtomicBoolean(false);
        for (PackResources rp : PFMRuntimeResources.RESOURCE_PACK_LIST) {
            if (exists.get()) break;
            rp.m_8031_(resourceType, id2.m_135827_(), id2.m_135815_(), (identifier, supplier) -> {
                try {
                    ((InputStream)supplier.m_247737_()).read();
                    ((InputStream)supplier.m_247737_()).close();
                    exists.set(true);
                }
                catch (IOException e) {
                    exists.set(false);
                }
            });
        }
        idCacheMap.put(id, exists.get());
        return exists.get();
    }

    public static enum IdLocation implements StringRepresentable
    {
        TEXTURES("textures", ".png"),
        MODELS("models"),
        BLOCKSTATES("blockstates"),
        RECIPES("recipes"),
        TAGS("tags"),
        LOOT_TABLES("loot_tables"),
        STRUCTURES("structures"),
        ADVANCEMENTS("advancements");

        private final String name;
        private final String fileType;

        private IdLocation(String name, String fileType) {
            this.name = name;
            this.fileType = fileType;
        }

        private IdLocation(String name) {
            this.name = name;
            this.fileType = ".json";
        }

        public String m_7912_() {
            return this.name;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

