/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.herringbone.forge;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import com.unlikepaladin.pfm.client.PFMSpriteRegistry;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.ducks.PFMSpriteContentExtensions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeHerringboneModel
extends PFMForgeBakedModel {
    static Material herringboneTextureId = new Material(InventoryMenu.f_39692_, PFMSpriteRegistry.HERRINGBONE_PLANKS);

    public ForgeHerringboneModel(ModelState settings, List<BakedModel> templateBakedModels) {
        super(settings, templateBakedModels);
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (!data.has(STATE) || data.get(STATE) == null) {
            return super.getParticleIcon(data);
        }
        BlockState state = (BlockState)data.get(STATE);
        VariantBase<?> variant = this.getVariant(state);
        if (variant instanceof WoodVariant) {
            return this.generateTextureIfNeeded(variant);
        }
        return super.getParticleIcon(data);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state != null) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            return data;
        }
        return super.getModelData(world, pos, state, tileData);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        VariantBase<?> variant;
        if (state != null && (variant = this.getVariant(state)) instanceof WoodVariant) {
            TextureAtlasSprite replacement = this.generateTextureIfNeeded(variant);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (BakedModel model : this.getTemplateBakedModels()) {
                quads.addAll(model.getQuads(state, side, rand, extraData, renderLayer));
            }
            return this.getQuadsWithTexture(quads, new PFMForgeBakedModel.SpriteData(replacement));
        }
        return super.getQuads(state, side, rand, extraData, renderLayer);
    }

    private TextureAtlasSprite generateTextureIfNeeded(VariantBase<?> variant) {
        ResourceLocation finalId = new ResourceLocation("pfm", "block/" + variant.getIdentifier().m_135815_() + "_herringbone_planks");
        Material mainTexture = new Material(InventoryMenu.f_39692_, finalId);
        if (!((PFMSpriteContentExtensions)mainTexture.m_119204_().m_245424_()).pfm$isInitialized()) {
            Material baseTextureSpriteId = new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.PRIMARY));
            ModelHelper.generateTexture(herringboneTextureId.m_119204_(), baseTextureSpriteId.m_119204_(), 7, finalId);
        }
        return mainTexture.m_119204_();
    }

    @Override
    public List<BakedQuad> getQuadsCached(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        Pair directionPair = new Pair((Object)stack, (Object)face);
        if (this.cache.containsKey(directionPair) && !((List)this.cache.get(directionPair)).isEmpty() && !((PFMSpriteContentExtensions)((BakedQuad)((List)this.cache.get(directionPair)).get(0)).m_173410_().m_245424_()).pfm$isInitialized()) {
            this.cache.remove(directionPair);
        }
        return super.getQuadsCached(stack, state, face, random);
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        VariantBase<?> variant = this.getVariant(((BlockItem)stack.m_41720_()).m_40614_().m_49966_());
        if (variant instanceof WoodVariant) {
            TextureAtlasSprite replacement = this.generateTextureIfNeeded(variant);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (BakedModel model : this.getTemplateBakedModels()) {
                quads.addAll(model.m_213637_(state, face, random));
            }
            return this.getQuadsWithTexture(quads, new PFMForgeBakedModel.SpriteData(replacement));
        }
        return super.getQuads(stack, state, face, random);
    }
}

