/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.imm_ptl.forge.shape;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class BlockPortalShape {
    public BlockPos anchor;
    public Set<BlockPos> area;
    public IntBox innerAreaBox;
    public IntBox totalAreaBox;
    public Direction.Axis axis;
    public Set<BlockPos> frameAreaWithoutCorner;
    public Set<BlockPos> frameAreaWithCorner;
    public BlockPos firstFramePos;

    public BlockPortalShape(Set<BlockPos> area, Direction.Axis axis) {
        this.area = area;
        this.axis = axis;
        this.calcAnchor();
        this.calcFrameArea();
        this.calcAreaBox();
    }

    public BlockPortalShape(CompoundTag tag) {
        this(BlockPortalShape.readArea(tag.m_128437_("poses", 3)), Direction.Axis.values()[tag.m_128451_("axis")]);
    }

    private static Set<BlockPos> readArea(ListTag list) {
        int size = list.size();
        Validate.isTrue((size % 3 == 0 ? 1 : 0) != 0);
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int i = 0; i < size / 3; ++i) {
            result.add(new BlockPos(list.m_128763_(i * 3 + 0), list.m_128763_(i * 3 + 1), list.m_128763_(i * 3 + 2)));
        }
        return result;
    }

    public static BlockPortalShape fromTag(CompoundTag tag) {
        return new BlockPortalShape(tag);
    }

    public CompoundTag toTag() {
        CompoundTag data = new CompoundTag();
        ListTag list = new ListTag();
        this.area.forEach(blockPos -> {
            list.add(list.size(), (Tag)IntTag.m_128679_((int)blockPos.m_123341_()));
            list.add(list.size(), (Tag)IntTag.m_128679_((int)blockPos.m_123342_()));
            list.add(list.size(), (Tag)IntTag.m_128679_((int)blockPos.m_123343_()));
        });
        data.m_128365_("poses", (Tag)list);
        data.m_128405_("axis", this.axis.ordinal());
        return data;
    }

    public void calcAnchor() {
        this.anchor = this.area.stream().min(Comparator.comparingInt(Vec3i::m_123341_).thenComparingInt(Vec3i::m_123342_).thenComparingInt(Vec3i::m_123343_)).get();
        Validate.notNull((Object)this.anchor);
    }

    public void calcAreaBox() {
        this.innerAreaBox = (IntBox)Helper.reduce((Object)new IntBox(this.anchor, this.anchor), this.area.stream(), IntBox::getExpanded);
        this.totalAreaBox = (IntBox)Helper.reduce((Object)new IntBox(this.anchor, this.anchor), this.frameAreaWithoutCorner.stream(), IntBox::getExpanded);
    }

    public void calcFrameArea() {
        Direction[] directions = Helper.getAnotherFourDirections((Direction.Axis)this.axis);
        this.frameAreaWithoutCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.m_121955_(directions[0].m_122436_()), blockPos.m_121955_(directions[1].m_122436_()), blockPos.m_121955_(directions[2].m_122436_()), blockPos.m_121955_(directions[3].m_122436_()))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        BlockPos[] cornerOffsets = new BlockPos[]{new BlockPos(directions[0].m_122436_()).m_121955_(directions[1].m_122436_()), new BlockPos(directions[1].m_122436_()).m_121955_(directions[2].m_122436_()), new BlockPos(directions[2].m_122436_()).m_121955_(directions[3].m_122436_()), new BlockPos(directions[3].m_122436_()).m_121955_(directions[0].m_122436_())};
        this.frameAreaWithCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.m_121955_((Vec3i)cornerOffsets[0]), blockPos.m_121955_((Vec3i)cornerOffsets[1]), blockPos.m_121955_((Vec3i)cornerOffsets[2]), blockPos.m_121955_((Vec3i)cornerOffsets[3]))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        this.frameAreaWithCorner.addAll(this.frameAreaWithoutCorner);
        this.firstFramePos = this.frameAreaWithoutCorner.iterator().next();
    }

    @Nullable
    public static BlockPortalShape findArea(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        if (!isAir.test(startingPos)) {
            return null;
        }
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian);
    }

    @Nullable
    public static BlockPortalShape findShapeWithoutRegardingStartingPos(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        startingPos = startingPos.m_7949_();
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        area.add(startingPos);
        Direction[] directions = Helper.getAnotherFourDirections((Direction.Axis)axis);
        boolean isNormalFrame = BlockPortalShape.findAreaBreadthFirst(startingPos, isAir, isObsidian, directions, area, startingPos);
        if (!isNormalFrame) {
            return null;
        }
        return new BlockPortalShape(area, axis);
    }

    private static boolean findAreaBreadthFirst(BlockPos startingPos, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, Direction[] directions, Set<BlockPos> foundArea, BlockPos initialPos) {
        ArrayDeque<BlockPos> newlyAdded = new ArrayDeque<BlockPos>();
        newlyAdded.addLast(startingPos);
        while (!newlyAdded.isEmpty()) {
            if (foundArea.size() > 400) {
                return false;
            }
            BlockPos last = (BlockPos)newlyAdded.pollFirst();
            for (Direction direction : directions) {
                BlockPos curr = last.m_121945_(direction).m_7949_();
                if (foundArea.contains(curr)) continue;
                if (isAir.test(curr)) {
                    newlyAdded.addLast(curr);
                    foundArea.add(curr);
                    continue;
                }
                if (isObsidian.test(curr)) continue;
                return false;
            }
            BlockPos delta = initialPos.m_121996_((Vec3i)startingPos);
            if (Math.abs(delta.m_123341_()) <= 20 && Math.abs(delta.m_123342_()) <= 20 && Math.abs(delta.m_123343_()) <= 20) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    private static boolean findAreaRecursively(BlockPos currPos, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, Direction[] directions, Set<BlockPos> foundArea, BlockPos initialPos) {
        if (foundArea.size() > 400) {
            return false;
        }
        BlockPos delta = initialPos.m_121996_((Vec3i)currPos);
        if (Math.abs(delta.m_123341_()) > 20 || Math.abs(delta.m_123342_()) > 20 || Math.abs(delta.m_123343_()) > 20) {
            return false;
        }
        for (Direction direction : directions) {
            BlockPos newPos = currPos.m_121955_(direction.m_122436_());
            if (foundArea.contains(newPos)) continue;
            if (isAir.test(newPos)) {
                foundArea.add(newPos.m_7949_());
                boolean shouldContinue = BlockPortalShape.findAreaRecursively(newPos, isAir, isObsidian, directions, foundArea, initialPos);
                if (shouldContinue) continue;
                return false;
            }
            if (isObsidian.test(newPos)) continue;
            return false;
        }
        return true;
    }

    public BlockPortalShape matchShape(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.MutableBlockPos temp) {
        if (!isAir.test(newAnchor)) {
            return null;
        }
        boolean testFrame = this.testFrameWithoutCorner(isObsidian, newAnchor, temp);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.m_122178_(blockPos.m_123341_() - this.anchor.m_123341_() + newAnchor.m_123341_(), blockPos.m_123342_() - this.anchor.m_123342_() + newAnchor.m_123342_(), blockPos.m_123343_() - this.anchor.m_123343_() + newAnchor.m_123343_())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        return this.getShapeWithMovedAnchor(newAnchor);
    }

    private boolean testFrameWithoutCorner(Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.MutableBlockPos temp) {
        Function<BlockPos, BlockPos.MutableBlockPos> mapper = blockPos -> temp.m_122178_(blockPos.m_123341_() - this.anchor.m_123341_() + newAnchor.m_123341_(), blockPos.m_123342_() - this.anchor.m_123342_() + newAnchor.m_123342_(), blockPos.m_123343_() - this.anchor.m_123343_() + newAnchor.m_123343_());
        if (!isObsidian.test((BlockPos)mapper.apply(this.firstFramePos))) {
            return false;
        }
        return this.frameAreaWithoutCorner.stream().map(mapper).allMatch(isObsidian);
    }

    public BlockPortalShape getShapeWithMovedAnchor(BlockPos newAnchor) {
        BlockPos offset = newAnchor.m_121996_((Vec3i)this.anchor);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.m_121955_((Vec3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public boolean isFrameIntact(Predicate<BlockPos> isObsidian) {
        return this.frameAreaWithoutCorner.stream().allMatch(isObsidian::test);
    }

    public boolean isPortalIntact(Predicate<BlockPos> isPortalBlock, Predicate<BlockPos> isObsidian) {
        return this.isFrameIntact(isObsidian) && this.area.stream().allMatch(isPortalBlock);
    }

    public void initPortalPosAxisShape(Portal portal, Direction.AxisDirection axisDirection) {
        Vec3 center = this.innerAreaBox.getCenterVec();
        portal.m_20343_(center.f_82479_, center.f_82480_, center.f_82481_);
        this.initPortalAxisShape(portal, center, Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)axisDirection));
    }

    public void initPortalAxisShape(Portal portal, Vec3 center, Direction facing) {
        Validate.isTrue((facing.m_122434_() == this.axis ? 1 : 0) != 0);
        Tuple perpendicularDirections = Helper.getPerpendicularDirections((Direction)facing);
        Direction wDirection = (Direction)perpendicularDirections.m_14418_();
        Direction hDirection = (Direction)perpendicularDirections.m_14419_();
        portal.axisW = Vec3.m_82528_((Vec3i)wDirection.m_122436_());
        portal.axisH = Vec3.m_82528_((Vec3i)hDirection.m_122436_());
        portal.width = Helper.getCoordinate((Vec3i)this.innerAreaBox.getSize(), (Direction.Axis)wDirection.m_122434_());
        portal.height = Helper.getCoordinate((Vec3i)this.innerAreaBox.getSize(), (Direction.Axis)hDirection.m_122434_());
        Vec3 offset = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).m_122436_()).m_82490_(0.5);
        if (this.isRectangle()) {
            portal.specialShape = null;
        } else {
            GeometryPortalShape shape = new GeometryPortalShape();
            IntBox rectanglePart = Helper.expandRectangle((BlockPos)this.anchor, blockPos -> this.area.contains(blockPos), (Direction.Axis)this.axis);
            Stream.concat(this.area.stream().filter(blockPos -> !rectanglePart.contains(blockPos)).map(blockPos -> new IntBox(blockPos, blockPos)), Stream.of(rectanglePart)).forEach(part -> {
                Vec3 p1 = Vec3.m_82528_((Vec3i)part.l).m_82549_(offset);
                Vec3 p2 = Vec3.m_82528_((Vec3i)part.h).m_82520_(1.0, 1.0, 1.0).m_82549_(offset);
                double p1LocalX = p1.m_82546_(center).m_82526_(portal.axisW);
                double p1LocalY = p1.m_82546_(center).m_82526_(portal.axisH);
                double p2LocalX = p2.m_82546_(center).m_82526_(portal.axisW);
                double p2LocalY = p2.m_82546_(center).m_82526_(portal.axisH);
                shape.addTriangleForRectangle(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
            });
            portal.specialShape = shape;
            Vec3 p1 = Vec3.m_82528_((Vec3i)rectanglePart.l).m_82549_(offset);
            Vec3 p2 = Vec3.m_82528_((Vec3i)rectanglePart.h).m_82520_(1.0, 1.0, 1.0).m_82549_(offset);
            double p1LocalX = p1.m_82546_(center).m_82526_(portal.axisW);
            double p1LocalY = p1.m_82546_(center).m_82526_(portal.axisH);
            double p2LocalX = p2.m_82546_(center).m_82526_(portal.axisW);
            double p2LocalY = p2.m_82546_(center).m_82526_(portal.axisH);
            portal.initCullableRange(p1LocalX, p2LocalX, p1LocalY, p2LocalY);
        }
    }

    public BlockPortalShape matchShapeWithMovedFirstFramePos(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newFirstObsidianPos, BlockPos.MutableBlockPos temp) {
        boolean testFrame = this.frameAreaWithoutCorner.stream().map(blockPos1 -> temp.m_122178_(blockPos1.m_123341_() - this.firstFramePos.m_123341_() + newFirstObsidianPos.m_123341_(), blockPos1.m_123342_() - this.firstFramePos.m_123342_() + newFirstObsidianPos.m_123342_(), blockPos1.m_123343_() - this.firstFramePos.m_123343_() + newFirstObsidianPos.m_123343_())).allMatch(isObsidian);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.m_122178_(blockPos.m_123341_() - this.firstFramePos.m_123341_() + newFirstObsidianPos.m_123341_(), blockPos.m_123342_() - this.firstFramePos.m_123342_() + newFirstObsidianPos.m_123342_(), blockPos.m_123343_() - this.firstFramePos.m_123343_() + newFirstObsidianPos.m_123343_())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        BlockPos offset = newFirstObsidianPos.m_121996_((Vec3i)this.firstFramePos);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.m_121955_((Vec3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public static boolean isSquareShape(BlockPortalShape shape, int length) {
        Tuple xs;
        BlockPos areaSize = shape.innerAreaBox.getSize();
        return Helper.getCoordinate((Vec3i)areaSize, (Direction.Axis)((Direction.Axis)(xs = Helper.getAnotherTwoAxis((Direction.Axis)shape.axis)).m_14418_())) == length && Helper.getCoordinate((Vec3i)areaSize, (Direction.Axis)((Direction.Axis)xs.m_14419_())) == length && shape.area.size() == length * length;
    }

    public static BlockPortalShape getSquareShapeTemplate(Direction.Axis axis, int length) {
        Tuple perpendicularDirections = Helper.getPerpendicularDirections((Direction)Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                area.add(BlockPos.f_121853_.m_5484_((Direction)perpendicularDirections.m_14418_(), i).m_5484_((Direction)perpendicularDirections.m_14419_(), j));
            }
        }
        return new BlockPortalShape(area, axis);
    }

    public BlockPortalShape getShapeWithMovedTotalAreaBox(IntBox newTotalAreaBox) {
        Validate.isTrue((boolean)this.totalAreaBox.getSize().equals((Object)newTotalAreaBox.getSize()));
        return this.getShapeWithMovedAnchor(newTotalAreaBox.l.m_121996_((Vec3i)this.totalAreaBox.l).m_121955_((Vec3i)this.anchor));
    }

    public boolean isRectangle() {
        BlockPos size = this.innerAreaBox.getSize();
        return size.m_123341_() * size.m_123342_() * size.m_123343_() == this.area.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPortalShape that = (BlockPortalShape)o;
        return this.area.equals(that.area) && this.axis == that.axis;
    }

    public int hashCode() {
        return Objects.hash(this.area, this.axis);
    }
}

