/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.BlockItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WoodVariant
extends VariantBase<WoodVariant> {
    private final Block plankBlock;
    private final Block logBlock;
    @Nullable
    private final Boat.Type vanillaWoodType;

    WoodVariant(ResourceLocation identifier, Block plankBlock, Block logBlock) {
        super(identifier);
        this.plankBlock = plankBlock;
        this.logBlock = logBlock;
        this.vanillaWoodType = Boat.Type.m_38432_((String)identifier.m_135815_()) != Boat.Type.OAK && Boat.Type.m_38432_((String)identifier.m_135815_()).m_38434_() == plankBlock ? Boat.Type.m_38432_((String)identifier.m_135815_()) : null;
    }

    WoodVariant(ResourceLocation identifier, Block plankBlock, Block logBlock, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Boat.Type vanillaWoodType) {
        super(identifier);
        this.plankBlock = plankBlock;
        this.logBlock = logBlock;
        this.vanillaWoodType = vanillaWoodType;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Boat.Type getVanillaWoodType() {
        return this.vanillaWoodType;
    }

    public String m_7912_() {
        String postfix = this.isVanilla() ? "" : "_" + this.getNamespace();
        return this.identifier.m_135815_() + postfix;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.STRIPPED_LOG) {
            return ModelHelper.getTextureId((Block)this.getChild("stripped_log"));
        }
        if (type == BlockType.LOG || type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.logBlock);
        }
        if (type == BlockType.LOG_TOP) {
            return ModelHelper.getTextureId(this.logBlock, "_top");
        }
        if (type == BlockType.STRIPPED_LOG_TOP) {
            return ModelHelper.getTextureId((Block)this.getChild("stripped_log"), "_top");
        }
        return ModelHelper.getTextureId(this.plankBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.m_135815_();
    }

    @Nullable
    protected Block findLogRelatedBlock(String append, String postpend) {
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        ResourceLocation id = this.getIdentifier();
        String logN = BuiltInRegistries.f_256975_.m_7981_((Object)this.logBlock).m_135815_();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), logN + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), logN + "_" + append + ((String)post).replace("_", "")), new ResourceLocation(id.m_135827_(), append + "_" + logN + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + logN + ((String)post).replace("_", "")), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + ((String)post).replace("_", "")), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + ((String)post).replace("_", ""))};
        Object postNether = "";
        switch (postpend) {
            case "log": {
                postNether = "stem";
                break;
            }
            case "wood": {
                postNether = "hyphae";
            }
        }
        postNether = postpend.isEmpty() ? "" : "_" + (String)postNether;
        Block found = null;
        if (!((String)postNether).isEmpty()) {
            ResourceLocation[] nether_targets;
            ResourceLocation[] resourceLocationArray = nether_targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), logN + "_" + append + (String)postNether), new ResourceLocation(id.m_135827_(), logN + "_" + append + ((String)postNether).replace("_", "")), new ResourceLocation(id.m_135827_(), append + "_" + logN + (String)postNether), new ResourceLocation(id.m_135827_(), append + "_" + logN + ((String)postNether).replace("_", "")), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)postNether), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + ((String)postNether).replace("_", "")), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)postNether), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + ((String)postNether).replace("_", ""))};
            int n = resourceLocationArray.length;
            for (int i = 0; i < n; ++i) {
                ResourceLocation r = resourceLocationArray[i];
                if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
                found = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
                break;
            }
        }
        for (ResourceLocation r : targets) {
            if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
            found = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
            break;
        }
        return found;
    }

    @Override
    public Block getBaseBlock() {
        return this.plankBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        return this.logBlock;
    }

    public Block getLogBlock() {
        return this.logBlock;
    }

    public String toString() {
        return this.identifier.toString();
    }

    @Override
    public boolean isNetherWood() {
        return this.identifier.m_135815_().contains("warped") || this.identifier.m_135815_().contains("crimson");
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.m_135827_().equals("") || this.identifier.m_135827_().equals("minecraft");
    }

    @Override
    public WoodVariant getVariantType() {
        return this;
    }

    @Override
    public List<FeatureFlag> getFeatureList() {
        FeatureFlag flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().m_245183_().f_243923_, 0);
        flag.f_244012_ = this.getBaseBlock().m_245183_().f_243922_;
        return List.of(flag);
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.plankBlock);
        this.addChild("log", this.logBlock);
        this.addChild("leaves", this.findRelatedEntry("leaves", BuiltInRegistries.f_256975_));
        this.addChild("stripped_log", this.findLogRelatedBlock("stripped", "log"));
        this.addChild("stripped_wood", this.findLogRelatedBlock("stripped", "wood"));
        this.addChild("wood", this.findRelatedEntry("wood", BuiltInRegistries.f_256975_));
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.f_256975_));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.f_256975_));
        this.addChild("fence", this.findRelatedEntry("fence", BuiltInRegistries.f_256975_));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", BuiltInRegistries.f_256975_));
        this.addChild("door", this.findRelatedEntry("door", BuiltInRegistries.f_256975_));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", BuiltInRegistries.f_256975_));
        this.addChild("button", this.findRelatedEntry("button", BuiltInRegistries.f_256975_));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", BuiltInRegistries.f_256975_));
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", BuiltInRegistries.f_257033_));
        this.addChild("sign", this.findRelatedEntry("sign", BuiltInRegistries.f_257033_));
    }

    public boolean hasStripped() {
        Object child = this.getChild("stripped_log");
        return child != null && child != this.getBaseBlock();
    }

    @Nullable
    public ItemLike getItemForRecipe(String key, Class<? extends Block> blockClass, boolean stripped) {
        if (stripped) {
            if (key.equals("base")) {
                return (ItemLike)this.getChild("stripped_log");
            }
            if (key.equals("secondary")) {
                return this.getBaseBlock();
            }
        }
        return super.getItemForRecipe(key, blockClass);
    }

    @Override
    public Block mainChild() {
        return this.plankBlock;
    }

    public static class Finder
    implements VariantBase.SetFinder<WoodVariant> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(planksName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        public Optional<WoodVariant> get() {
            if (BlockItemRegistry.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("minecraft", "air"));
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodVariant w = new WoodVariant(this.id, plank, log);
                        for (Map.Entry<String, ResourceLocation> entry : this.childNames.entrySet()) {
                            Object child = BuiltInRegistries.f_256975_.m_6612_(entry.getValue()).isPresent() ? BuiltInRegistries.f_256975_.m_7745_(entry.getValue()) : BuiltInRegistries.f_257033_.m_7745_(entry.getValue());
                            w.addChild(entry.getKey(), child);
                        }
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

