/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity;

import com.unlikepaladin.pfm.entity.DyeableFurnitureEntity;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OfficeChairEntity
extends Mob
implements DyeableFurnitureEntity<OfficeChairEntity> {
    private float yawVelocity = 0.0f;
    private int rotationInputTicks = 0;
    private float lastRotationDirection = 0.0f;
    private float wheelSpinAngle = 0.0f;
    private static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.m_135353_(OfficeChairEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public OfficeChairEntity(EntityType<? extends OfficeChairEntity> type, Level world) {
        super(type, world);
    }

    public OfficeChairEntity(Level world, double x, double y, double z) {
        super(Entities.OFFICE_CHAIR, world);
        this.m_20343_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && this.f_19802_ == 0) {
            this.m_5634_(0.1f);
        }
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_20160_() && this.m_6688_() instanceof LivingEntity) {
            LivingEntity livingEntity = this.m_6688_();
            this.f_19859_ = this.m_146908_();
            this.m_146926_(livingEntity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float forwardsSpeed = livingEntity.f_20902_;
            float rotationInput = livingEntity.f_20900_;
            if (this.m_6109_()) {
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float baseRotationSensitivity = 0.5f;
                float maxRotationSensitivity = 2.0f;
                int maxAccelerationTicks = 30;
                float decay = 0.85f;
                if (Math.abs(rotationInput) > 1.0E-5f) {
                    float currentDirection = Math.signum(rotationInput);
                    this.rotationInputTicks = currentDirection == this.lastRotationDirection ? Math.min(this.rotationInputTicks + 1, 30) : 1;
                    this.lastRotationDirection = currentDirection;
                    float accelerationFactor = (float)this.rotationInputTicks / 30.0f;
                    float currentSensitivity = 0.5f + 1.5f * accelerationFactor;
                    this.yawVelocity += -rotationInput * currentSensitivity;
                } else {
                    this.rotationInputTicks = 0;
                    this.lastRotationDirection = 0.0f;
                }
                this.yawVelocity *= 0.85f;
                this.m_146922_(this.m_146908_() + this.yawVelocity);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                super.m_7023_(new Vec3(0.0, movementInput.f_82480_, (double)forwardsSpeed));
            } else if (livingEntity instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            }
            double speed = this.m_20184_().m_165924_();
            this.wheelSpinAngle += (float)(speed * 200.0);
            this.m_146872_();
        } else {
            super.m_7023_(movementInput);
        }
    }

    public float getWheelSpinAngle() {
        return this.wheelSpinAngle;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("Color", (byte)this.getPFMColor().m_41060_());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setPFMColor(DyeColor.m_41053_((int)nbt.m_128445_("Color")));
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction updater) {
        if (this.m_20363_(passenger)) {
            float g = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            Vec3 offset = new Vec3(0.0, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            updater.m_20372_(passenger, this.m_20185_() + offset.f_82479_, this.m_20186_() + (double)g, this.m_20189_() + offset.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.yawVelocity);
            passenger.m_5616_(passenger.m_6080_() + this.yawVelocity);
            this.copyEntityData(passenger);
        }
    }

    protected void copyEntityData(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity passenger) {
        this.copyEntityData(passenger);
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        if (player.m_5833_() || player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (!this.m_20160_() && !player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            player.m_7998_((Entity)this, true);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, hitPos, hand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_20160_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return super.m_6688_();
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            int[][] dismountingOffsets = DismountHelper.m_38467_((Direction)direction);
            BlockPos chairPos = this.m_20183_();
            BlockPos.MutableBlockPos dismountPos = new BlockPos.MutableBlockPos();
            for (Pose entityPose : passenger.m_7431_()) {
                AABB box = passenger.m_21270_(entityPose);
                for (int[] dismountingOffset : dismountingOffsets) {
                    dismountPos.m_122169_((double)(chairPos.m_123341_() + dismountingOffset[0]), (double)chairPos.m_123342_() + 0.3, (double)(chairPos.m_123343_() + dismountingOffset[1]));
                    double dismountHeight = this.m_9236_().m_45573_((BlockPos)dismountPos);
                    if (!DismountHelper.m_38439_((double)dismountHeight)) continue;
                    Vec3 vec3d = Vec3.m_82514_((Vec3i)dismountPos, (double)dismountHeight);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)box.m_82383_(vec3d))) continue;
                    passenger.m_20124_(entityPose);
                    return vec3d;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    public double m_6048_() {
        return 0.55;
    }

    @Override
    public void setPFMColor(DyeColor color) {
        byte b = (Byte)this.f_19804_.m_135370_(COLOR);
        this.f_19804_.m_135381_(COLOR, (Object)((byte)(b & 0xF0 | color.m_41060_() & 0xF)));
    }

    @Override
    public DyeColor getPFMColor() {
        return DyeColor.m_41053_((int)((Byte)this.f_19804_.m_135370_(COLOR) & 0xF));
    }

    @Override
    public CompoundTag writeColor(CompoundTag nbt) {
        nbt.m_128344_("Color", (byte)this.getPFMColor().m_41060_());
        return nbt;
    }

    @Override
    public OfficeChairEntity getEntity() {
        return this;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    protected void m_6668_(DamageSource source) {
        super.m_6668_(source);
        if (!source.m_19390_()) {
            ItemStack stack = PaladinFurnitureModBlocksItems.OFFICE_CHAIR_ITEM.m_7968_();
            stack.m_41784_().m_128359_("Color", this.getPFMColor().m_7912_());
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    public void m_147240_(double strength, double x, double z) {
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12442_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12446_;
    }
}

