/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.unlikepaladin.pfm.client.PFMBakedModelManagerAccessor;
import com.unlikepaladin.pfm.entity.OfficeChairEntity;
import com.unlikepaladin.pfm.entity.model.OfficeChairModelEmpty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;

public class OfficeChairEntityRenderer
extends MobRenderer<OfficeChairEntity, OfficeChairModelEmpty> {
    public static final ResourceLocation[] MODEL_IDS = new ResourceLocation[]{new ResourceLocation("pfm:block/office_chair/office_chair"), new ResourceLocation("pfm:block/office_chair/office_chair_top"), new ResourceLocation("pfm:block/office_chair/office_chair_bottom"), new ResourceLocation("pfm:block/office_chair/office_chair_wheels")};
    private static final float[][] WHEEL_OFFSETS = new float[][]{{0.0f, 0.35f}, {-0.35f, 0.0f}, {0.35f, 0.0f}, {0.0f, -0.35f}};

    public OfficeChairEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new OfficeChairModelEmpty(), 0.0f);
    }

    public static void renderItem(ItemStack itemStack, PoseStack stack, ItemDisplayContext mode, MultiBufferSource provider, boolean leftHanded, int light, int overlay) {
        stack.m_85836_();
        BakedModel chairModel = ((PFMBakedModelManagerAccessor)Minecraft.m_91087_().m_91304_()).pfm$getModelFromNormalID(MODEL_IDS[0]);
        chairModel.m_7442_().m_269404_(mode).m_111763_(mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || mode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND, stack);
        stack.m_85837_(-0.5, -0.5, -0.5);
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(42L);
        ArrayList quads = new ArrayList(Arrays.stream(Direction.values()).map(arg_0 -> OfficeChairEntityRenderer.lambda$renderItem$0(chairModel, (RandomSource)random, arg_0)).flatMap(Collection::stream).toList());
        quads.addAll(chairModel.m_213637_(null, null, (RandomSource)random));
        if (!chairModel.m_7547_()) {
            Lighting.m_84930_();
        }
        for (BakedQuad quad : quads) {
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            if (itemStack.m_41783_().m_128441_("Color") && quad.m_111304_()) {
                int colorInt = DyeColor.m_41057_((String)itemStack.m_41783_().m_128461_("Color"), (DyeColor)DyeColor.WHITE).m_41070_();
                red = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                green = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                blue = (float)(colorInt & 0xFF) / 255.0f;
            }
            provider.m_6299_(ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)true)).m_85987_(stack.m_85850_(), quad, red, green, blue, light, overlay);
        }
        if (!chairModel.m_7547_()) {
            Lighting.m_84931_();
        }
        stack.m_85849_();
    }

    public void render(OfficeChairEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        if (mobEntity.m_213877_() || !mobEntity.m_6084_()) {
            return;
        }
        int damageStage = (int)Math.min(9.0f, Math.max(mobEntity.m_21233_() - mobEntity.m_21223_(), 0.0f));
        VertexConsumer damageConsumer = Minecraft.m_91087_().m_91269_().m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(damageStage));
        VertexConsumer solid = vertexConsumerProvider.m_6299_(RenderType.m_110457_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.45, 0.0, -0.5);
        BakedModel modelBase = ((PFMBakedModelManagerAccessor)Minecraft.m_91087_().m_91304_()).pfm$getModelFromNormalID(MODEL_IDS[2]);
        ArrayList baseQuads = new ArrayList(Arrays.stream(Direction.values()).map(direction -> modelBase.m_213637_(null, direction, mobEntity.m_9236_().f_46441_)).flatMap(Collection::stream).toList());
        baseQuads.addAll(modelBase.m_213637_(null, null, mobEntity.m_9236_().f_46441_));
        for (BakedQuad quad : baseQuads) {
            float brightness = mobEntity.m_9236_().m_7717_(quad.m_111306_(), quad.m_111307_());
            solid.m_85987_(matrixStack.m_85850_(), quad, brightness, brightness, brightness, light, OverlayTexture.f_118083_);
            SheetedDecalTextureGenerator damage = new SheetedDecalTextureGenerator(damageConsumer, matrixStack.m_85850_().m_252922_(), matrixStack.m_85850_().m_252943_(), 1.0f);
            if (mobEntity.f_19802_ <= 0) continue;
            damage.m_85987_(matrixStack.m_85850_(), quad, brightness, brightness, brightness, light, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        BakedModel wheelModel = ((PFMBakedModelManagerAccessor)Minecraft.m_91087_().m_91304_()).pfm$getModelFromNormalID(MODEL_IDS[3]);
        ArrayList wheelQuads = new ArrayList(Arrays.stream(Direction.values()).map(direction -> wheelModel.m_213637_(null, direction, mobEntity.m_9236_().f_46441_)).flatMap(Collection::stream).toList());
        wheelQuads.addAll(wheelModel.m_213637_(null, null, mobEntity.m_9236_().f_46441_));
        Vec3 velocity = mobEntity.m_20184_();
        float wheelYaw = 0.0f;
        double speed = velocity.m_165924_();
        if (speed > 1.0E-7) {
            wheelYaw = (float)(Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) * 57.29577951308232) - 90.0f;
        }
        float wheelSpin = mobEntity.getWheelSpinAngle();
        for (float[] wheelOffset : WHEEL_OFFSETS) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(wheelOffset[0], 0.0f, wheelOffset[1]);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-wheelYaw));
            matrixStack.m_85837_(-0.45, 0.0, -0.5);
            matrixStack.m_85837_(0.5, 0.08, 0.5);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(wheelSpin));
            matrixStack.m_85837_(-0.5, -0.08, -0.5);
            for (BakedQuad quad : wheelQuads) {
                float brightness = mobEntity.m_9236_().m_7717_(quad.m_111306_(), quad.m_111307_());
                solid.m_85987_(matrixStack.m_85850_(), quad, brightness, brightness, brightness, light, OverlayTexture.f_118083_);
                SheetedDecalTextureGenerator damage = new SheetedDecalTextureGenerator(damageConsumer, matrixStack.m_85850_().m_252922_(), matrixStack.m_85850_().m_252943_(), 1.0f);
                if (mobEntity.f_19802_ <= 0) continue;
                damage.m_85987_(matrixStack.m_85850_(), quad, brightness, brightness, brightness, light, OverlayTexture.f_118083_);
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
        matrixStack.m_85837_(-0.45, 0.0, -0.5);
        BakedModel model = ((PFMBakedModelManagerAccessor)Minecraft.m_91087_().m_91304_()).pfm$getModelFromNormalID(MODEL_IDS[1]);
        ArrayList chairQuads = new ArrayList(Arrays.stream(Direction.values()).map(direction -> model.m_213637_(null, direction, mobEntity.m_9236_().f_46441_)).flatMap(Collection::stream).toList());
        chairQuads.addAll(model.m_213637_(null, null, mobEntity.m_9236_().f_46441_));
        for (BakedQuad quad : chairQuads) {
            float brightness = mobEntity.m_9236_().m_7717_(quad.m_111306_(), quad.m_111307_());
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            if (mobEntity.getPFMColor() != null && quad.m_111304_()) {
                int colorInt = mobEntity.getPFMColor().m_41070_();
                red = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                green = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                blue = (float)(colorInt & 0xFF) / 255.0f;
            }
            solid.m_85987_(matrixStack.m_85850_(), quad, red * brightness, green * brightness, blue * brightness, light, OverlayTexture.f_118083_);
            SheetedDecalTextureGenerator damage = new SheetedDecalTextureGenerator(damageConsumer, matrixStack.m_85850_().m_252922_(), matrixStack.m_85850_().m_252943_(), 1.0f);
            if (mobEntity.f_19802_ <= 0) continue;
            damage.m_85987_(matrixStack.m_85850_(), quad, brightness, brightness, brightness, light, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
    }

    public ResourceLocation getTexture(OfficeChairEntity entity) {
        return null;
    }

    private static /* synthetic */ List lambda$renderItem$0(BakedModel chairModel, RandomSource random, Direction direction) {
        return chairModel.m_213637_(null, direction, random);
    }
}

