/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic.forge;

import com.google.common.collect.ImmutableSet;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.mixin.PFMPointOfInterestTypesAccessor;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.dynamic.LateBlockRegistry;
import com.unlikepaladin.pfm.registry.forge.BlockItemRegistryImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="pfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LateBlockRegistryImpl {
    public static Map<String, Block> blocks = new LinkedHashMap<String, Block>();
    public static Map<String, Supplier<Item>> items = new LinkedHashMap<String, Supplier<Item>>();

    public static void registerLateItem(String itemName, Supplier<Item> itemSup, Tuple<String, CreativeModeTab> group) {
        items.put(itemName, itemSup);
        BlockItemRegistryImpl.itemNameToGroup.put(itemName, group);
    }

    public static <T extends Block> T registerLateBlock(String blockId, Supplier<T> blockSup, boolean registerItem, Tuple<String, CreativeModeTab> group) {
        Block block = (Block)blockSup.get();
        if (registerItem) {
            PaladinFurnitureModBlocksItems.BLOCKS.add(block);
            LateBlockRegistryImpl.registerBlockItemPlatformSpecific(blockId, block, group);
        }
        blocks.put(blockId, block);
        return (T)block;
    }

    public static void registerBlockItemPlatformSpecific(String itemName, Block block, Tuple<String, CreativeModeTab> group) {
        if (AbstractSittableBlock.isWoodBased(block.m_49966_())) {
            LateBlockRegistryImpl.registerLateItem(itemName, () -> new BlockItem(block, new Item.Properties()){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return 300;
                }
            }, group);
        }
        LateBlockRegistryImpl.registerLateItem(itemName, () -> new BlockItem(block, new Item.Properties()), group);
    }

    public static void registerBlocks(IForgeRegistry<Block> blockRegisterEvent) {
        try {
            LateBlockRegistry.registerBlocks();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        blocks.forEach((arg_0, arg_1) -> blockRegisterEvent.register(arg_0, arg_1));
    }

    public static void registerItems(IForgeRegistry<Item> itemIForgeRegistry) {
        items.forEach((itemName, itemSup) -> {
            Item item = (Item)itemSup.get();
            itemIForgeRegistry.register(itemName, (Object)item);
            if (!PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.containsKey(BlockItemRegistryImpl.itemNameToGroup.get(itemName))) {
                PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.put(BlockItemRegistryImpl.itemNameToGroup.get(itemName), new ArrayList());
            }
            PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.get(BlockItemRegistryImpl.itemNameToGroup.get(itemName)).add(item);
        });
    }

    public static <T extends Block> T registerLateBlockClassic(String blockId, T block, boolean registerItem, Tuple<String, CreativeModeTab> group) {
        if (registerItem) {
            PaladinFurnitureModBlocksItems.BLOCKS.add(block);
            LateBlockRegistryImpl.registerBlockItemPlatformSpecific(blockId, block, group);
        }
        blocks.put(blockId, block);
        return block;
    }

    @SubscribeEvent
    public static void registerPOI(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, pointOfInterestTypeRegisterHelper -> {
            Set originalBedStates = ((PoiType)ForgeRegistries.POI_TYPES.getValue(PoiTypes.f_218060_.m_135782_())).f_27325_();
            Set addedBedStates = (Set)Arrays.stream(PaladinFurnitureModBlocksItems.getBeds()).flatMap(block -> block.m_49965_().m_61056_().stream().filter(state -> state.m_61143_((Property)SimpleBedBlock.f_49440_) == BedPart.HEAD)).collect(ImmutableSet.toImmutableSet());
            HashSet newBedStates = new HashSet();
            newBedStates.addAll(originalBedStates);
            newBedStates.addAll(addedBedStates);
            PoiType pointOfInterestType = new PoiType(newBedStates, 1, 1);
            ForgeRegistries.POI_TYPES.register("minecraft:home", (Object)pointOfInterestType);
            PFMPointOfInterestTypesAccessor.setHome((ResourceKey<PoiType>)((ResourceKey)((Holder)ForgeRegistries.POI_TYPES.getHolder((Object)pointOfInterestType).get()).m_203543_().get()));
        });
    }
}

