/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.ducks.PFMSpriteExtensions;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.runtime.forge.TextureReloadQueueImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;

public final class TextureReloadQueue {
    public static final List<ResourceLocation> list = Collections.synchronizedList(new ArrayList());

    public static void recolorAndWriteImage(ResourceLocation identifier, BufferedImage base, Map<Integer, Integer> palette) {
        try {
            BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
            for (int y = 0; y < base.getHeight(); ++y) {
                for (int x = 0; x < base.getWidth(); ++x) {
                    int mappedArgb;
                    int srcArgb = base.getRGB(x, y);
                    int srcArgbNoAlpha = srcArgb | 0xFF000000;
                    int srcAlpha = srcArgb >> 24 & 0xFF;
                    if (palette.containsKey(srcArgbNoAlpha)) {
                        mappedArgb = palette.get(srcArgbNoAlpha);
                    } else {
                        mappedArgb = TextureReloadQueue.findClosestColorLab(srcArgbNoAlpha, palette);
                        palette.put(srcArgbNoAlpha, mappedArgb);
                    }
                    int finalArgb = srcAlpha << 24 | mappedArgb & 0xFFFFFF;
                    recolored.setRGB(x, y, finalArgb);
                }
            }
            String file = PFMRuntimeResources.getAssetPackDirectory().resolve("assets/pfm/textures/").toString();
            try {
                Files.createDirectories(Path.of(file, new String[0]), new FileAttribute[0]);
                Files.createDirectory(Path.of(file + "/block", new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException x) {
            }
            catch (IOException e) {
                PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to create directories for recolored image {}: {}", (Object)identifier, (Object)e.getMessage());
            }
            ModelHelper.writeBufferedImageToFile(recolored, file + "/" + identifier.m_135815_() + ".png");
        }
        catch (Throwable e) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to generate recolored image {}: {}", (Object)identifier, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        TextureReloadQueue.requestReload(identifier);
    }

    public static void requestReload(ResourceLocation id) {
        if (id != null) {
            list.add(id);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerTextureReload() {
        TextureReloadQueueImpl.registerTextureReload();
    }

    static void reloadSingleSprite(ResourceManager resourceManager, TextureAtlas spriteAtlas, ResourceLocation id) throws IOException {
        ResourceLocation path = ModelHelper.getTextureSpritePath(id);
        Optional optionalResource = resourceManager.m_213713_(path);
        if (optionalResource.isEmpty()) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to reload texture at {}, resource not found", (Object)id);
            return;
        }
        Resource resource = (Resource)optionalResource.get();
        TextureAtlasSprite original = spriteAtlas.m_118316_(id);
        SpriteContents newContents = SpriteLoader.m_245083_((ResourceLocation)id, (Resource)resource);
        ((PFMSpriteExtensions)original).pfm$setContents(newContents);
        try {
            newContents.m_246368_(((Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_()).intValue());
        }
        catch (NullPointerException e) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to generate mipmaps for texture {}: {}", (Object)id, (Object)e.getMessage());
        }
        original.m_118416_();
    }

    public static void reloadSpritesOnClientThread(List<ResourceLocation> id) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        AbstractTexture abstractTexture = textureManager.m_118506_(InventoryMenu.f_39692_);
        try {
            if (abstractTexture instanceof TextureAtlas) {
                TextureAtlas spriteAtlas = (TextureAtlas)abstractTexture;
                spriteAtlas.m_117966_();
                for (ResourceLocation spriteId : id) {
                    TextureReloadQueue.reloadSingleSprite(resourceManager, spriteAtlas, spriteId);
                }
            }
        }
        catch (IOException e) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to reload texture at {}", id, (Object)e);
        }
        Minecraft.m_91087_().execute(() -> {
            Minecraft.m_91087_().f_91060_.m_109818_();
            ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
            WoodVariantRegistry.getVariants().stream().sorted().forEach(woodVariant -> variants.add(woodVariant.identifier));
            StoneVariantRegistry.getVariants().stream().sorted().forEach(stoneVariant -> variants.add(stoneVariant.identifier));
            try {
                Path output = PFMRuntimeResources.getAssetPackDirectory();
                PFMGenerator.PFMCache.createAndWriteCacheToDisk(output, variants, PaladinFurnitureMod.GENERAL_LOGGER);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static double pivotRgb(double n) {
        return (n /= 255.0) <= 0.04045 ? n / 12.92 : Math.pow((n + 0.055) / 1.055, 2.4);
    }

    private static double pivotXyz(double n) {
        return n > 0.008856 ? Math.cbrt(n) : 7.787 * n + 0.13793103448275862;
    }

    private static double[] argbToLab(int argb) {
        int r8 = argb >> 16 & 0xFF;
        int g8 = argb >> 8 & 0xFF;
        int b8 = argb & 0xFF;
        double r = TextureReloadQueue.pivotRgb(r8);
        double g = TextureReloadQueue.pivotRgb(g8);
        double b = TextureReloadQueue.pivotRgb(b8);
        double x = r * 0.4124564 + g * 0.3575761 + b * 0.1804375;
        double y = r * 0.2126729 + g * 0.7151522 + b * 0.072175;
        double z = r * 0.0193339 + g * 0.119192 + b * 0.9503041;
        double fx = TextureReloadQueue.pivotXyz(x /= 0.95047);
        double fy = TextureReloadQueue.pivotXyz(y /= 1.0);
        double fz = TextureReloadQueue.pivotXyz(z /= 1.08883);
        double L = Math.max(0.0, 116.0 * fy - 16.0);
        double a = 500.0 * (fx - fy);
        double b2 = 200.0 * (fy - fz);
        return new double[]{L, a, b2};
    }

    private static double deltaE(double[] lab1, double[] lab2) {
        double dL = lab1[0] - lab2[0];
        double da = lab1[1] - lab2[1];
        double db = lab1[2] - lab2[2];
        return dL * dL + da * da + db * db;
    }

    private static int findClosestColorLab(int srcArgb, Map<Integer, Integer> palette) {
        if (palette.isEmpty()) {
            return srcArgb;
        }
        double[] srcLab = TextureReloadQueue.argbToLab(srcArgb);
        int closestColor = srcArgb;
        double minDistance = Double.MAX_VALUE;
        for (Map.Entry<Integer, Integer> entry : palette.entrySet()) {
            int palArgb = entry.getKey();
            double[] palLab = TextureReloadQueue.argbToLab(palArgb);
            double dist = TextureReloadQueue.deltaE(srcLab, palLab);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closestColor = entry.getValue();
        }
        return closestColor;
    }

    public record SpriteCoordinates(int x, int y, int width, int height, int atlasWidth, int atlasHeight) {
    }
}

