/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.particle_core;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.annotations.ConvertFrom;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedIdentifierMap;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedEnum;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.particle_core.PcConfig;
import me.fzzyhmstrs.particle_core.PcUtils;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@ConvertFrom(fileName="particle_core_config_v1.json")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\u000b\u0010\fR(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R(\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lme/fzzyhmstrs/particle_core/PcConfigImpl;", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "<init>", "()V", "Lnet/minecraft/client/ParticleStatus;", "mode", "getReducedParticleSpawnType", "(Lnet/minecraft/client/ParticleStatus;)Lnet/minecraft/client/ParticleStatus;", "Lnet/minecraft/core/particles/ParticleType;", "type", "", "shouldSpawnParticle", "(Lnet/minecraft/core/particles/ParticleType;)Z", "Lme/fzzyhmstrs/fzzy_config/validation/collection/ValidatedIdentifierMap;", "", "byTypeReductions", "Lme/fzzyhmstrs/fzzy_config/validation/collection/ValidatedIdentifierMap;", "getByTypeReductions", "()Lme/fzzyhmstrs/fzzy_config/validation/collection/ValidatedIdentifierMap;", "setByTypeReductions", "(Lme/fzzyhmstrs/fzzy_config/validation/collection/ValidatedIdentifierMap;)V", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedBoolean;", "disableParticles", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedBoolean;", "getDisableParticles", "()Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedBoolean;", "setDisableParticles", "(Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedBoolean;)V", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedFloat;", "reduceAllChance", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedFloat;", "getReduceAllChance", "()Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedFloat;", "setReduceAllChance", "(Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedFloat;)V", "reduceDecreasedChance", "getReduceDecreasedChance", "setReduceDecreasedChance", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedEnum;", "Lme/fzzyhmstrs/particle_core/PcConfig$PotionDisableType;", "turnOffPotionParticles", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedEnum;", "getTurnOffPotionParticles", "()Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedEnum;", "setTurnOffPotionParticles", "(Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedEnum;)V", "particle_core"})
public final class PcConfigImpl
extends Config {
    @NotNull
    private ValidatedEnum<PcConfig.PotionDisableType> turnOffPotionParticles = new ValidatedEnum((Enum)PcConfig.PotionDisableType.NONE, null, 2, null);
    @NotNull
    private ValidatedFloat reduceAllChance = new ValidatedFloat(0.0f, 1.0f, 0.0f, null, 8, null);
    @NotNull
    private ValidatedFloat reduceDecreasedChance = new ValidatedFloat(0.0f, 1.0f, 0.0f, null, 8, null);
    @NotNull
    private ValidatedBoolean disableParticles = new ValidatedBoolean(false);
    @NotNull
    private ValidatedIdentifierMap<Double> byTypeReductions;

    public PcConfigImpl() {
        super(new ResourceLocation("particle_core", "particle_core_config"), "", "", null, 8, null);
        Map map = MapsKt.emptyMap();
        ResourceLocation resourceLocation = new ResourceLocation("smoke");
        Registry registry = BuiltInRegistries.f_257034_;
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"PARTICLE_TYPE");
        this.byTypeReductions = new ValidatedIdentifierMap(map, ValidatedIdentifier.Companion.ofRegistry(resourceLocation, registry), (Entry)new ValidatedDouble(1.0, 1.0, 0.0, null, 8, null));
    }

    @NotNull
    public final ValidatedEnum<PcConfig.PotionDisableType> getTurnOffPotionParticles() {
        return this.turnOffPotionParticles;
    }

    public final void setTurnOffPotionParticles(@NotNull ValidatedEnum<PcConfig.PotionDisableType> validatedEnum) {
        Intrinsics.checkNotNullParameter(validatedEnum, (String)"<set-?>");
        this.turnOffPotionParticles = validatedEnum;
    }

    @NotNull
    public final ValidatedFloat getReduceAllChance() {
        return this.reduceAllChance;
    }

    public final void setReduceAllChance(@NotNull ValidatedFloat validatedFloat) {
        Intrinsics.checkNotNullParameter((Object)validatedFloat, (String)"<set-?>");
        this.reduceAllChance = validatedFloat;
    }

    @NotNull
    public final ValidatedFloat getReduceDecreasedChance() {
        return this.reduceDecreasedChance;
    }

    public final void setReduceDecreasedChance(@NotNull ValidatedFloat validatedFloat) {
        Intrinsics.checkNotNullParameter((Object)validatedFloat, (String)"<set-?>");
        this.reduceDecreasedChance = validatedFloat;
    }

    @NotNull
    public final ValidatedBoolean getDisableParticles() {
        return this.disableParticles;
    }

    public final void setDisableParticles(@NotNull ValidatedBoolean validatedBoolean) {
        Intrinsics.checkNotNullParameter((Object)validatedBoolean, (String)"<set-?>");
        this.disableParticles = validatedBoolean;
    }

    @NotNull
    public final ValidatedIdentifierMap<Double> getByTypeReductions() {
        return this.byTypeReductions;
    }

    public final void setByTypeReductions(@NotNull ValidatedIdentifierMap<Double> validatedIdentifierMap) {
        Intrinsics.checkNotNullParameter(validatedIdentifierMap, (String)"<set-?>");
        this.byTypeReductions = validatedIdentifierMap;
    }

    public final boolean shouldSpawnParticle(@NotNull ParticleType<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ResourceLocation resourceLocation = BuiltInRegistries.f_257034_.m_7981_(type);
        if (resourceLocation == null) {
            return true;
        }
        Double d = PcConfig.INSTANCE.getByTypeParticleReduction$particle_core().get(resourceLocation);
        if (d == null) {
            return true;
        }
        double chance = d;
        return PcUtils.INSTANCE.getRandom$particle_core().m_188500_() < chance;
    }

    @NotNull
    public final ParticleStatus getReducedParticleSpawnType(@NotNull ParticleStatus mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        ParticleStatus outMode = mode;
        if (outMode == ParticleStatus.ALL && PcUtils.INSTANCE.getRandom$particle_core().m_188501_() < ((Number)this.reduceAllChance.get()).floatValue()) {
            outMode = ParticleStatus.DECREASED;
        }
        if (outMode == ParticleStatus.DECREASED && PcUtils.INSTANCE.getRandom$particle_core().m_188501_() < ((Number)this.reduceDecreasedChance.get()).floatValue()) {
            outMode = ParticleStatus.MINIMAL;
        }
        return outMode;
    }
}

