/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import be.florens.expandability.api.forge.PlayerSwimEvent;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.NetworkHandler;
import it.hurts.octostudios.rarcompat.network.packets.FlamingoSwimPacket;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class HeliumFlamingoItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"flying").stat(StatData.builder((String)"time").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"speed").initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-754286).borderBottom(-4967837).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.AQUATIC).entry(LootCollections.END).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        block8: {
            block7: {
                if (!(entity instanceof Player)) break block7;
                player = (Player)entity;
                if (this.canUseAbility(stack, "flying")) break block8;
            }
            return;
        }
        if (player.m_20193_().m_5776_() && HeliumFlamingoClientEvent.onDoubleJump && ++HeliumFlamingoClientEvent.ticKCount % 10 == 0) {
            HeliumFlamingoClientEvent.onDoubleJump = false;
            HeliumFlamingoClientEvent.ticKCount = 0;
        }
        if (player.m_20096_() || player.m_20069_()) {
            this.setTime(stack, 0);
        }
        if (player.f_19797_ % 20 == 0 && this.getToggled(stack)) {
            this.addTime(stack, 1);
            this.spreadExperience((LivingEntity)player, stack, 1);
        }
        if (this.getTime(stack) >= (int)MathUtils.round((double)this.getAbilityValue(stack, "flying", "time"), (int)0) && !player.m_20069_()) {
            player.m_20334_(player.m_20184_().f_82479_, -0.25, player.m_20184_().f_82481_);
            player.f_19789_ = 0.0f;
            this.setToggled(stack, false);
        }
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.setToggled(stack, false);
        this.setTime(stack, 0);
    }

    public boolean getToggled(ItemStack stack) {
        return NBTUtils.getBoolean((ItemStack)stack, (String)"toggled", (boolean)false);
    }

    public void setToggled(ItemStack stack, boolean val) {
        NBTUtils.setBoolean((ItemStack)stack, (String)"toggled", (boolean)val);
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public int getTime(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"time", (int)0);
    }

    public void setTime(ItemStack stack, int val) {
        NBTUtils.setInt((ItemStack)stack, (String)"time", (int)Math.max(val, 0));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class HeliumFlamingoClientEvent {
        private static boolean onDoubleJump = false;
        private static int ticKCount;

        @SubscribeEvent
        public static void onClientTick(InputEvent.Key event) {
            HeliumFlamingoItem relic;
            Item item;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.get()));
            if (minecraft.f_91080_ != null || event.getAction() != 1 || !((item = stack.m_41720_()) instanceof HeliumFlamingoItem) || !(relic = (HeliumFlamingoItem)item).canPlayerUseActiveAbility((Player)player, stack, "flying") || event.getKey() != minecraft.f_91066_.f_92089_.getKey().m_84873_()) {
                return;
            }
            if (!onDoubleJump) {
                onDoubleJump = true;
            } else if (!player.m_150110_().f_35936_) {
                int statValue = (int)MathUtils.round((double)relic.getAbilityValue(stack, "flying", "time"), (int)0);
                int time = relic.getTime(stack);
                if (time >= statValue) {
                    return;
                }
                NetworkHandler.sendToServer(new FlamingoSwimPacket(!relic.getToggled(stack)));
                if (!relic.getToggled(stack) && !player.m_20069_()) {
                    player.m_20256_(player.m_20184_().m_82549_(player.m_20154_().m_82490_((double)0.6f)));
                }
            } else if (relic.getToggled(stack)) {
                NetworkHandler.sendToServer(new FlamingoSwimPacket(false));
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class HeliumFlamingoEvent {
        @SubscribeEvent
        public static void onSwimAir(PlayerSwimEvent event) {
            HeliumFlamingoItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof HeliumFlamingoItem) || !(relic = (HeliumFlamingoItem)item).canUseAbility(stack, "flying")) {
                return;
            }
            if (relic.getToggled(stack)) {
                event.setResult(Event.Result.ALLOW);
                player.m_6858_(true);
                EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (float)((float)relic.getAbilityValue(stack, "flying", "speed")), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            } else {
                event.setResult(Event.Result.DEFAULT);
                EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
        }
    }
}

