/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.FindTargetGoal;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.pillager.PillagerMeleeAttackGoal;
import com.talhanation.recruits.entities.ai.pillager.PillagerUseShield;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PillagerEvents {
    protected final Random random = new Random();

    @SubscribeEvent
    public void attackRecruit(EntityJoinLevelEvent event) {
        int i;
        Monster monster;
        Pillager pillager;
        Entity entity = event.getEntity();
        if (entity instanceof Pillager) {
            pillager = (Pillager)entity;
            if (((Boolean)RecruitsServerConfig.PillagerIncreasedCombatRange.get()).booleanValue()) {
                pillager.f_21345_.m_25352_(2, (Goal)new FindTargetGoal((AbstractIllager)pillager, 24.0f));
                pillager.f_21345_.m_25352_(2, (Goal)new RangedCrossbowAttackGoal((Monster)pillager, 1.0, 24.0f));
            }
        }
        if (entity instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)entity;
            illager.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)illager, AbstractRecruitEntity.class, true));
            if (((Boolean)RecruitsServerConfig.PillagerAttackMonsters.get()).booleanValue()) {
                illager.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)illager, Zombie.class, true));
                illager.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)illager, AbstractSkeleton.class, true));
                illager.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)illager, Spider.class, true));
            }
            if (((Boolean)RecruitsServerConfig.ShouldPillagersRaidNaturally.get()).booleanValue()) {
                illager.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)illager, Animal.class, true));
            }
        }
        if (entity instanceof Monster && !((monster = (Monster)entity) instanceof Creeper) && !(monster instanceof EnderMan)) {
            monster.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)monster, AbstractRecruitEntity.class, true));
        }
        if (entity instanceof Zombie && ((Boolean)RecruitsServerConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (Zombie)entity;
            monster.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)monster, AbstractIllager.class, true));
        }
        if (entity instanceof AbstractSkeleton && ((Boolean)RecruitsServerConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (AbstractSkeleton)entity;
            monster.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)monster, AbstractIllager.class, true));
        }
        if (entity instanceof Spider && ((Boolean)RecruitsServerConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (Spider)entity;
            monster.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)monster, AbstractIllager.class, true));
        }
        if (entity instanceof Vindicator) {
            Vindicator vindicator = (Vindicator)entity;
            if (((Boolean)RecruitsServerConfig.VindicatorSpawnItems.get()).booleanValue()) {
                vindicator.f_21345_.m_25352_(0, (Goal)new PillagerUseShield((AbstractIllager)vindicator));
                vindicator.m_21530_();
                i = this.random.nextInt(3);
                if (i == 2) {
                    vindicator.m_21008_(InteractionHand.MAIN_HAND, Items.f_42386_.m_7968_());
                } else {
                    vindicator.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                    vindicator.m_21008_(InteractionHand.OFF_HAND, Items.f_42740_.m_7968_());
                }
            }
        }
        if (entity instanceof Pillager) {
            pillager = (Pillager)entity;
            if (((Boolean)RecruitsServerConfig.PillagerSpawnItems.get()).booleanValue()) {
                pillager.f_21345_.m_25352_(0, (Goal)new PillagerMeleeAttackGoal(pillager, 1.15, true));
                pillager.f_21345_.m_25352_(0, (Goal)new PillagerUseShield((AbstractIllager)pillager));
                pillager.m_21530_();
                i = this.random.nextInt(6);
                switch (i) {
                    case 1: 
                    case 2: 
                    case 3: {
                        pillager.m_21008_(InteractionHand.MAIN_HAND, Items.f_42717_.m_7968_());
                        break;
                    }
                    case 4: {
                        pillager.m_21008_(InteractionHand.MAIN_HAND, Items.f_42386_.m_7968_());
                        pillager.m_21008_(InteractionHand.OFF_HAND, Items.f_42740_.m_7968_());
                        break;
                    }
                    case 0: 
                    case 5: {
                        pillager.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                        pillager.m_21008_(InteractionHand.OFF_HAND, Items.f_42740_.m_7968_());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void raidStartOnBurningOminous(EntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            Player player;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            Level level = itemEntity.m_20193_();
            if (itemStack.m_41720_() instanceof BannerItem && itemEntity.m_6060_() && ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)Raid.m_37779_()) && (player = level.m_45930_((Entity)itemEntity, 16.0)) != null) {
                MobEffectInstance effectinstance1 = player.m_21124_(MobEffects.f_19594_);
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    player.m_6234_(MobEffects.f_19594_);
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19594_, 120000, i, false, false, true);
                if (!player.m_20193_().m_46469_().m_46207_(GameRules.f_46154_)) {
                    player.m_7292_(effectinstance);
                    level.m_254849_((Entity)itemEntity, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 0.5f, Level.ExplosionInteraction.BLOCK);
                }
            }
        }
    }
}

