/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.DisbandContainer;
import com.talhanation.recruits.inventory.TeamEditMenu;
import com.talhanation.recruits.network.MessageOpenDisbandScreen;
import com.talhanation.recruits.network.MessageOpenTeamEditScreen;
import com.talhanation.recruits.network.MessageToClientSetDiplomaticToast;
import com.talhanation.recruits.network.MessageToClientSetToast;
import com.talhanation.recruits.network.MessageToClientUpdateTeamEditScreen;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsTeam;
import com.talhanation.recruits.world.RecruitsTeamManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamEvents {
    public MinecraftServer server;
    public static RecruitsTeamManager recruitsTeamManager;
    public static RecruitsDiplomacyManager recruitsDiplomacyManager;
    public static final Component PLAYER_REMOVED;

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
        ServerLevel level = this.server.m_129783_();
        Collection list = level.m_6188_().m_83491_();
        for (PlayerTeam playerTeam : list) {
            playerTeam.m_83355_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamFriendlyFireSetting.get() != false);
            playerTeam.m_83362_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamSeeFriendlyInvisibleSetting.get() != false);
        }
        recruitsTeamManager = new RecruitsTeamManager();
        recruitsTeamManager.load(this.server.m_129783_());
        recruitsDiplomacyManager = new RecruitsDiplomacyManager();
        recruitsDiplomacyManager.load(this.server.m_129783_());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        recruitsTeamManager.save(this.server.m_129783_());
        recruitsDiplomacyManager.save(this.server.m_129783_());
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        recruitsTeamManager.save(this.server.m_129783_());
        recruitsDiplomacyManager.save(this.server.m_129783_());
    }

    public static boolean isPlayerInATeam(Player player) {
        return player.m_5647_() != null;
    }

    public static void openDisbandingScreen(Player player, final UUID recruit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"disband_screen");
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new DisbandContainer(i, playerEntity, recruit);
                }
            }, packetBuffer -> packetBuffer.m_130077_(recruit));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenDisbandScreen(player, recruit));
        }
    }

    public static void openTeamEditScreen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RecruitsTeam recruitsTeam = null;
            if (serverPlayer.m_5647_() != null) {
                recruitsTeam = recruitsTeamManager.getTeamByStringID(player.m_5647_().m_5758_());
            }
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageToClientUpdateTeamEditScreen(TeamEvents.getCurrency(), (Integer)RecruitsServerConfig.FactionCreationCost.get(), (Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get(), recruitsTeam));
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"team_edit_screen");
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new TeamEditMenu(i, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(player.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenTeamEditScreen(player));
        }
    }

    public static boolean createTeam(boolean menu, ServerPlayer serverPlayer, @NotNull ServerLevel level, String teamName, String playerName, ItemStack banner, ChatFormatting color, byte colorByte) {
        MinecraftServer server = level.m_7654_();
        PlayerTeam team = server.m_129896_().m_83489_(teamName);
        int cost = (Integer)RecruitsServerConfig.FactionCreationCost.get();
        if (banner == null) {
            banner = Items.f_42672_.m_7968_();
        }
        CompoundTag nbt = banner.serializeNBT();
        if (team != null) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.team_exists").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (teamName.chars().count() > 32L) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.teamname_to_long").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (teamName.isBlank() || teamName.isEmpty()) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.noname").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (recruitsTeamManager.isNameInUse(teamName)) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.team_exists").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (!TeamEvents.playerHasEnoughEmeralds(serverPlayer, cost) && menu) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.noenough_money").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (RecruitsTeamManager.isBannerBlank(banner) && menu) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.wrongbanner"));
            return false;
        }
        if (recruitsTeamManager.isBannerInUse(nbt) && menu) {
            serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.banner_exists").m_130940_(ChatFormatting.RED));
            return false;
        }
        ServerScoreboard scoreboard = server.m_129896_();
        PlayerTeam newTeam = scoreboard.m_83492_(teamName);
        newTeam.m_83353_((Component)Component.m_237113_((String)teamName));
        newTeam.m_83351_(color);
        newTeam.m_83355_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamFriendlyFireSetting.get() != false);
        newTeam.m_83362_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamSeeFriendlyInvisibleSetting.get() != false);
        server.m_129896_().m_6546_(playerName, newTeam);
        if (menu) {
            TeamEvents.doPayment((Player)serverPlayer, cost);
        }
        recruitsTeamManager.addTeam(teamName, serverPlayer.m_20148_(), serverPlayer.m_6302_(), banner.serializeNBT(), colorByte, newTeam.m_7414_());
        TeamEvents.addPlayerToData(level, teamName, 1, playerName);
        List<AbstractRecruitEntity> recruits = TeamEvents.getRecruitsOfPlayer(serverPlayer.m_20148_(), level);
        int recruitCount = recruits.size();
        TeamEvents.addNPCToData(level, teamName, recruitCount);
        TeamEvents.addRecruitToTeam(recruits, (Team)newTeam, level);
        Main.LOGGER.info("The new Team " + teamName + " has been created by " + playerName + ".");
        recruitsTeamManager.save(server.m_129783_());
        return true;
    }

    public static void updateTeamInspectMenu(ServerPlayer player, ServerLevel level, String team) {
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(team);
        if (recruitsTeam != null) {
            ItemStack bannerStack = ItemStack.m_41712_((CompoundTag)recruitsTeam.getBanner());
            List<String> joinRequests = recruitsTeam.getJoinRequests();
            int players = recruitsTeam.getPlayers();
            int npcs = recruitsTeam.getNPCs();
            UUID leaderUUID = recruitsTeam.getTeamLeaderUUID();
            String string = recruitsTeam.getTeamLeaderName();
        } else {
            Main.LOGGER.error("Could not load recruitsTeamData for Team " + team + " because Team == null");
        }
    }

    public static boolean leaveTeam(boolean command, ServerPlayer player, String teamName, ServerLevel level, boolean fromLeader) {
        MinecraftServer server = level.m_7654_();
        String playerName = player.m_7755_().getString();
        Team team = player.m_5647_();
        if (team != null) {
            if (teamName == null) {
                teamName = team.m_5758_();
            }
            PlayerTeam playerTeam = server.m_129896_().m_83489_(teamName);
            RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(teamName);
            boolean isLeader = recruitsTeam != null ? recruitsTeam.getTeamLeaderUUID().equals(player.m_20148_()) : command;
            int recruits = TeamEvents.getRecruitsOfPlayer(player.m_20148_(), level).size();
            TeamEvents.addNPCToData(level, teamName, -recruits);
            if (playerTeam != null) {
                if (isLeader) {
                    TeamEvents.removeTeam(level, teamName);
                } else {
                    ServerPlayer leaderOfTeam = server.m_6846_().m_11255_(recruitsTeam.getTeamLeaderName());
                    if (!fromLeader && leaderOfTeam != null) {
                        leaderOfTeam.m_213846_(TeamEvents.PLAYER_LEFT_TEAM_LEADER(playerName));
                    }
                    server.m_129896_().m_6519_(playerName, playerTeam);
                    TeamEvents.addPlayerToData(level, teamName, -1, playerName);
                }
                TeamEvents.removeRecruitFromTeam(teamName, player, level);
                return true;
            }
            Main.LOGGER.error("Can not remove " + playerName + " from Team, because " + teamName + " does not exist!");
            TeamEvents.serverSideUpdateTeam(level);
        } else {
            PlayerTeam playerTeam = server.m_129896_().m_83489_(teamName);
            if (playerTeam != null) {
                recruitsTeamManager.removeTeam(teamName);
                return true;
            }
        }
        recruitsTeamManager.save(server.m_129783_());
        return false;
    }

    public static void modifyTeam(ServerLevel level, String stringID, RecruitsTeam editedTeam, @Nullable ServerPlayer serverPlayer, int cost) {
        MinecraftServer server = level.m_7654_();
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(stringID);
        PlayerTeam playerTeam = server.m_129896_().m_83489_(stringID);
        if (serverPlayer != null) {
            if (cost > 0 && !TeamEvents.playerHasEnoughEmeralds(serverPlayer, cost)) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team_creation.noenough_money").m_130940_(ChatFormatting.RED));
                return;
            }
            TeamEvents.doPayment((Player)serverPlayer, cost);
        }
        if (recruitsTeam != null && playerTeam != null) {
            if (!recruitsTeam.getTeamLeaderUUID().equals(editedTeam.getTeamLeaderUUID())) {
                TeamEvents.notifyFactionMembers(level, recruitsTeam, 10, editedTeam.getTeamLeaderName());
                recruitsTeam.setTeamLeaderID(editedTeam.getTeamLeaderUUID());
                recruitsTeam.setTeamLeaderName(editedTeam.getTeamLeaderName());
            }
            if (!recruitsTeam.getTeamDisplayName().equals(editedTeam.getTeamDisplayName())) {
                TeamEvents.notifyFactionMembers(level, recruitsTeam, 11, editedTeam.getTeamDisplayName());
                recruitsTeam.setTeamDisplayName(editedTeam.getTeamDisplayName());
            }
            if (!recruitsTeam.getBanner().equals((Object)editedTeam.getBanner())) {
                TeamEvents.notifyFactionMembers(level, recruitsTeam, 12, "");
                recruitsTeam.setBanner(editedTeam.getBanner());
            }
            recruitsTeam.setUnitColor(editedTeam.getUnitColor());
            recruitsTeam.setTeamColor(editedTeam.getTeamColor());
            recruitsTeam.setMaxNPCsPerPlayer(editedTeam.getMaxNPCsPerPlayer());
            playerTeam.m_83353_((Component)Component.m_237113_((String)editedTeam.getTeamDisplayName()));
            playerTeam.m_83351_(ChatFormatting.m_126647_((int)editedTeam.getTeamColor()));
        }
    }

    public static void notifyFactionMembers(ServerLevel level, RecruitsTeam recruitsTeam, int id, String notification) {
        List<ServerPlayer> playersInTeam = recruitsTeamManager.getPlayersInTeam(recruitsTeam.getStringID(), level);
        for (ServerPlayer teamPlayer : playersInTeam) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> teamPlayer), (Object)new MessageToClientSetDiplomaticToast(id, recruitsTeam, notification));
        }
    }

    public static void removeTeam(ServerLevel level, String teamName) {
        MinecraftServer server = level.m_7654_();
        PlayerTeam playerTeam = server.m_129896_().m_83489_(teamName);
        if (playerTeam != null) {
            server.m_129896_().m_83475_(playerTeam);
            TeamEvents.removeRecruitsTeamData(teamName);
            recruitsTeamManager.removeTeam(teamName);
        }
        recruitsTeamManager.save(server.m_129783_());
    }

    private static void removeRecruitsTeamData(String teamName) {
        recruitsTeamManager.removeTeam(teamName);
    }

    public static boolean addPlayerToTeam(@Nullable ServerPlayer player, ServerLevel level, String teamName, String namePlayerToAdd) {
        MinecraftServer server = level.m_7654_();
        ServerPlayer playerToAdd = server.m_6846_().m_11255_(namePlayerToAdd);
        PlayerTeam playerTeam = server.m_129896_().m_83489_(teamName);
        if (TeamEvents.isPlayerAlreadyAFactionLeader(playerToAdd)) {
            if (player != null) {
                player.m_213846_(TeamEvents.CAN_NOT_ADD_OTHER_LEADER());
            }
            return false;
        }
        if (playerTeam != null) {
            server.m_129896_().m_6546_(namePlayerToAdd, playerTeam);
            playerToAdd.m_213846_(TeamEvents.ADDED_PLAYER(teamName));
            if (player != null) {
                player.m_213846_(TeamEvents.ADDED_PLAYER_LEADER(namePlayerToAdd));
            }
            TeamEvents.addPlayerToData(level, teamName, 1, namePlayerToAdd);
            int recruits = TeamEvents.getRecruitsOfPlayer(playerToAdd.m_20148_(), level).size();
            TeamEvents.addNPCToData(level, teamName, recruits);
            TeamEvents.serverSideUpdateTeam(level);
            RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(teamName);
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> playerToAdd), (Object)new MessageToClientSetDiplomaticToast(8, recruitsTeam));
            TeamEvents.notifyFactionMembers(level, recruitsTeam, 9, playerToAdd.m_7755_().getString());
            recruitsTeamManager.save(server.m_129783_());
            return true;
        }
        Main.LOGGER.error("Can not add " + playerToAdd + " to Team, because " + teamName + " does not exist!");
        return false;
    }

    public static boolean isPlayerAlreadyAFactionLeader(ServerPlayer playerToCheck) {
        for (RecruitsTeam recruitsTeam : recruitsTeamManager.getTeams()) {
            if (!recruitsTeam.getTeamLeaderUUID().equals(playerToCheck.m_20148_())) continue;
            return true;
        }
        return false;
    }

    public static Component REMOVE_PLAYER_LEADER(String player) {
        return Component.m_237110_((String)"chat.recruits.team_creation.removedPlayerLeader", (Object[])new Object[]{player});
    }

    public static Component ADDED_PLAYER(String s) {
        return Component.m_237110_((String)"chat.recruits.team_creation.addedPlayer", (Object[])new Object[]{s});
    }

    public static Component ADDED_PLAYER_LEADER(String s) {
        return Component.m_237110_((String)"chat.recruits.team_creation.addedPlayerLeader", (Object[])new Object[]{s});
    }

    public static Component CAN_NOT_ADD_OTHER_LEADER() {
        return Component.m_237115_((String)"chat.recruits.team_creation.canNotAddOtherLeader");
    }

    public static Component PLAYER_LEFT_TEAM_LEADER(String s) {
        return Component.m_237110_((String)"chat.recruits.team_creation.playerLeftTeamLeader", (Object[])new Object[]{s});
    }

    public static void addPlayerToData(ServerLevel level, String teamName, int x, String namePlayerToAdd) {
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(teamName);
        recruitsTeam.addPlayer(x);
        if (x > 0) {
            recruitsTeam.removeJoinRequest(namePlayerToAdd);
        }
    }

    public static void addNPCToData(ServerLevel level, String teamName, int x) {
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(teamName);
        if (recruitsTeam != null) {
            recruitsTeam.addNPCs(x);
        } else {
            Main.LOGGER.error("Could not modify recruits team: " + teamName + ".Team does not exist.");
        }
    }

    public static void sendJoinRequest(ServerLevel level, ServerPlayer player, String stringID) {
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(stringID);
        if (recruitsTeam != null) {
            if (recruitsTeam.addPlayerAsJoinRequest(player.m_7755_().getString())) {
                Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> recruitsTeamManager.getTeamLeader(recruitsTeam, level)), (Object)new MessageToClientSetDiplomaticToast(7, recruitsTeam, player.m_7755_().getString()));
            }
        } else {
            Main.LOGGER.error("Could not add join request for " + stringID + ".Team does not exist.");
        }
    }

    public static void tryToRemoveFromTeam(Team team, ServerPlayer serverPlayer, ServerPlayer potentialRemovePlayer, ServerLevel level, String nameToRemove, boolean menu) {
        boolean isPlayerToRemove;
        if (potentialRemovePlayer != null && team != null && (isPlayerToRemove = potentialRemovePlayer.m_7755_().getString().equals(nameToRemove))) {
            TeamEvents.leaveTeam(false, potentialRemovePlayer, null, level, true);
            potentialRemovePlayer.m_213846_(PLAYER_REMOVED);
            if (menu) {
                serverPlayer.m_213846_(TeamEvents.REMOVE_PLAYER_LEADER(potentialRemovePlayer.m_5446_().getString()));
            }
            List<AbstractRecruitEntity> recruits = TeamEvents.getRecruitsOfPlayer(serverPlayer.m_20148_(), level);
            int recruitCount = recruits.size();
            TeamEvents.addNPCToData(level, team.m_5758_(), -recruitCount);
            TeamEvents.removeRecruitFromTeam(recruits, team, level);
        }
    }

    public static ItemStack getCurrency() {
        String str = (String)RecruitsServerConfig.RecruitCurrency.get();
        Optional holder = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)str));
        ItemStack currencyItemStack = holder.map(itemHolder -> ((Item)itemHolder.m_203334_()).m_7968_()).orElseGet(() -> ((Item)Items.f_42616_).m_7968_());
        return currencyItemStack;
    }

    public static boolean playerHasEnoughEmeralds(ServerPlayer player, int price) {
        Inventory playerInv = player.m_150109_();
        int playerEmeralds = 0;
        Item currency = TeamEvents.getCurrency().m_41720_();
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack itemStackInSlot = playerInv.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (!itemInSlot.equals(currency)) continue;
            playerEmeralds += itemStackInSlot.m_41613_();
        }
        return playerEmeralds >= price || player.m_7500_();
    }

    public static void doPayment(Player player, int costs) {
        Inventory playerInv = player.m_150109_();
        int playerEmeralds = 0;
        ItemStack currencyItemStack = TeamEvents.getCurrency();
        playerEmeralds = TeamEvents.playerGetEmeraldsInInventory(player, currencyItemStack.m_41720_());
        playerEmeralds -= costs;
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack itemStackInSlot = playerInv.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != currencyItemStack.m_41720_()) continue;
            playerInv.m_8016_(i);
        }
        ItemStack emeraldsLeft = TeamEvents.getCurrency();
        emeraldsLeft.m_41764_(playerEmeralds);
        playerInv.m_36054_(emeraldsLeft);
    }

    public static int playerGetEmeraldsInInventory(Player player, Item currency) {
        int emeralds = 0;
        Inventory playerInv = player.m_150109_();
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack itemStackInSlot = playerInv.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != currency) continue;
            emeralds += itemStackInSlot.m_41613_();
        }
        return emeralds;
    }

    public static void assignToTeamMate(ServerPlayer oldOwner, UUID newOwnerUUID, AbstractRecruitEntity recruit) {
        ServerLevel level = (ServerLevel)oldOwner.m_20193_();
        Team team = oldOwner.m_5647_();
        if (team != null) {
            List list = team.m_6809_().stream().toList();
            List playerList = level.m_6907_();
            boolean playerNotFound = false;
            ServerPlayer newOwner = playerList.stream().filter(player -> player.m_20148_().equals(newOwnerUUID)).findFirst().orElse(null);
            if (newOwner != null) {
                if (list.contains(newOwner.m_7755_().getString())) {
                    if (!RecruitEvents.recruitsPlayerUnitManager.canPlayerRecruit(team.m_5758_(), newOwnerUUID)) {
                        oldOwner.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team.assignNewOwnerLimitReached"));
                        return;
                    }
                    recruit.disband((Player)oldOwner, true, true);
                    Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> newOwner), (Object)new MessageToClientSetToast(0, oldOwner.m_7755_().getString()));
                    recruit.hire((Player)newOwner);
                } else {
                    playerNotFound = true;
                }
            } else {
                playerNotFound = true;
            }
            if (playerNotFound) {
                oldOwner.m_213846_((Component)Component.m_237115_((String)"chat.recruits.team.assignNewOwnerNotFound"));
            }
        }
    }

    @SubscribeEvent
    public void onTypeCommandEvent(CommandEvent event) {
        if (event.getParseResults() != null) {
            String command = event.getParseResults().getReader().getString();
            CommandSourceStack sourceStack = (CommandSourceStack)event.getParseResults().getContext().build(command).getSource();
            ServerPlayer sender = sourceStack.m_230896_();
            ServerLevel level = this.server.m_129783_();
            if (sender != null) {
                if (command.contains("team")) {
                    if (command.contains("add")) {
                        ItemStack mainhand = sender.m_21205_();
                        String[] parts = command.split(" ");
                        String teamName = parts[2];
                        TeamEvents.createTeam(false, sender, level, teamName, sender.m_7755_().getString(), (ItemStack)(mainhand.m_41720_() instanceof BannerItem ? mainhand : null), ChatFormatting.WHITE, (byte)0);
                        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.team.add.success", (Object[])new Object[]{teamName}), true);
                        event.setCanceled(true);
                        TeamEvents.serverSideUpdateTeam(level);
                    } else if (command.contains("remove")) {
                        String[] parts = command.split(" ");
                        String teamName = parts[2];
                        TeamEvents.leaveTeam(true, sender, teamName, level, false);
                        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.team.remove.success", (Object[])new Object[]{teamName}), true);
                        event.setCanceled(true);
                        TeamEvents.serverSideUpdateTeam(level);
                    } else if (command.contains("join") || command.contains("leave")) {
                        TeamEvents.serverSideUpdateTeam(level);
                    }
                }
            } else if (command.contains("team")) {
                if (command.contains("add")) {
                    String[] parts = command.split(" ");
                    String teamName = parts[2];
                    this.createTeamConsole(sourceStack, level, teamName, "white", (byte)0);
                    event.setCanceled(true);
                } else if (command.contains("remove")) {
                    String[] parts = command.split(" ");
                    String teamName = parts[2];
                    PlayerTeam playerTeam = this.server.m_129896_().m_83489_(teamName);
                    if (playerTeam != null) {
                        this.server.m_129896_().m_83475_(playerTeam);
                        recruitsTeamManager.removeTeam(teamName);
                        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.team.remove.success", (Object[])new Object[]{teamName}), true);
                    } else {
                        sourceStack.m_81352_((Component)Component.m_237110_((String)"team.notFound", (Object[])new Object[]{teamName}));
                    }
                    event.setCanceled(true);
                } else if (command.contains("join")) {
                    String[] parts = command.split(" ");
                    String teamName = parts[2];
                    String playerName = parts[3];
                    ServerPlayer player = this.server.m_6846_().m_11255_(playerName);
                    if (player != null) {
                        TeamEvents.addPlayerToTeam(player, this.server.m_129783_(), teamName, playerName);
                        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.team.join.success.single", (Object[])new Object[]{playerName, teamName}), true);
                        TeamEvents.serverSideUpdateTeam(level);
                    } else {
                        sourceStack.m_81352_((Component)Component.m_237115_((String)"argument.player.unknown"));
                    }
                    event.setCanceled(true);
                } else if (command.contains("leave")) {
                    String[] parts = command.split(" ");
                    String playerName = parts[2];
                    ServerPlayer player = this.server.m_6846_().m_11255_(playerName);
                    if (player != null) {
                        Team team = player.m_5647_();
                        TeamEvents.tryToRemoveFromTeam(team, player, player, this.server.m_129783_(), playerName, false);
                        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.team.leave.success.single", (Object[])new Object[]{playerName}), true);
                        TeamEvents.serverSideUpdateTeam(level);
                    } else {
                        sourceStack.m_81352_((Component)Component.m_237115_((String)"argument.player.unknown"));
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    private void createTeamConsole(CommandSourceStack sourceStack, ServerLevel level, String teamName, String color, byte colorByte) {
        PlayerTeam team = this.server.m_129896_().m_83489_(teamName);
        ItemStack banner = Items.f_42672_.m_7968_();
        if (team == null) {
            if (teamName.chars().count() <= 13L) {
                if (!teamName.isBlank() && !teamName.isEmpty()) {
                    if (!recruitsTeamManager.isNameInUse(teamName)) {
                        ServerScoreboard scoreboard = this.server.m_129896_();
                        PlayerTeam newTeam = scoreboard.m_83492_(teamName);
                        newTeam.m_83353_((Component)Component.m_237113_((String)teamName));
                        newTeam.m_83351_(Objects.requireNonNull(ChatFormatting.m_126657_((String)color)));
                        newTeam.m_83355_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamFriendlyFireSetting.get() != false);
                        newTeam.m_83362_((Boolean)RecruitsServerConfig.GlobalTeamSetting.get() != false && (Boolean)RecruitsServerConfig.GlobalTeamSeeFriendlyInvisibleSetting.get() != false);
                        recruitsTeamManager.addTeam(teamName, new UUID(0L, 0L), "none", banner.serializeNBT(), colorByte, newTeam.m_7414_());
                        Main.LOGGER.info("The new Team " + teamName + " has been created by console.");
                        recruitsTeamManager.save(this.server.m_129783_());
                    } else {
                        sourceStack.m_81352_((Component)Component.m_237115_((String)"chat.recruits.team_creation.team_exists").m_130940_(ChatFormatting.RED));
                    }
                } else {
                    sourceStack.m_81352_((Component)Component.m_237115_((String)"chat.recruits.team_creation.noname").m_130940_(ChatFormatting.RED));
                }
            } else {
                sourceStack.m_81352_((Component)Component.m_237115_((String)"chat.recruits.team_creation.teamname_to_long").m_130940_(ChatFormatting.RED));
            }
        } else {
            sourceStack.m_81352_((Component)Component.m_237115_((String)"chat.recruits.team_creation.team_exists").m_130940_(ChatFormatting.RED));
        }
    }

    public static void serverSideUpdateTeam(ServerLevel level) {
        ArrayList<AbstractRecruitEntity> recruitList = new ArrayList<AbstractRecruitEntity>();
        for (Entity entity : level.m_142646_().m_142273_()) {
            if (!(entity instanceof AbstractRecruitEntity)) continue;
            AbstractRecruitEntity recruit = (AbstractRecruitEntity)entity;
            recruitList.add(recruit);
        }
        for (AbstractRecruitEntity recruit : recruitList) {
            recruit.needsTeamUpdate = true;
        }
        recruitsTeamManager.save(level);
    }

    private static List<AbstractRecruitEntity> getRecruitsOfPlayer(UUID player_uuid, ServerLevel level) {
        ArrayList<AbstractRecruitEntity> list = new ArrayList<AbstractRecruitEntity>();
        for (Entity entity : level.m_142646_().m_142273_()) {
            AbstractRecruitEntity recruit;
            if (!(entity instanceof AbstractRecruitEntity) || (recruit = (AbstractRecruitEntity)entity).getOwner() == null || !recruit.getOwnerUUID().equals(player_uuid)) continue;
            list.add(recruit);
        }
        return list;
    }

    public static void addRecruitToTeam(List<AbstractRecruitEntity> recruits, Team team, ServerLevel level) {
        for (AbstractRecruitEntity recruit : recruits) {
            TeamEvents.addRecruitToTeam(recruit, team, level);
        }
    }

    public static void addRecruitToTeam(AbstractRecruitEntity recruit, Team team, ServerLevel level) {
        boolean flag;
        String teamName = team.m_5758_();
        PlayerTeam playerteam = level.m_6188_().m_83489_(teamName);
        RecruitsTeam recruitsTeam = recruitsTeamManager.getTeamByStringID(teamName);
        boolean bl = flag = playerteam != null && level.m_6188_().m_6546_(recruit.m_20149_(), playerteam);
        if (!flag) {
            Main.LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)teamName);
        } else {
            recruit.m_6710_(null);
            if (recruitsTeam != null) {
                recruit.setColor(recruitsTeam.getUnitColor());
            }
        }
    }

    public static void removeRecruitFromTeam(String teamName, ServerPlayer player, ServerLevel level) {
        List<AbstractRecruitEntity> recruits = TeamEvents.getRecruitsOfPlayer(player.m_20148_(), level);
        PlayerTeam team = level.m_6188_().m_83489_(teamName);
        if (team != null) {
            TeamEvents.removeRecruitFromTeam(recruits, (Team)team, level);
        }
    }

    public static void removeRecruitFromTeam(List<AbstractRecruitEntity> recruits, Team team, ServerLevel level) {
        for (AbstractRecruitEntity recruit : recruits) {
            TeamEvents.removeRecruitFromTeam(recruit, team, level);
        }
    }

    public static void removeRecruitFromTeam(AbstractRecruitEntity recruit, Team team, ServerLevel level) {
        PlayerTeam recruitTeam;
        Team recruitsTeam = recruit.m_5647_();
        if (recruitsTeam != null && recruitsTeam.equals(team) && (recruitTeam = level.m_6188_().m_83489_(team.m_5758_())) != null) {
            level.m_6188_().m_6519_(recruit.m_20149_(), recruitTeam);
        }
    }

    static {
        PLAYER_REMOVED = Component.m_237115_((String)"chat.recruits.team_creation.removedPlayer");
    }
}

