/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.team;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.events.RecruitsToastManager;
import com.talhanation.recruits.client.gui.team.RecruitsTeamEntry;
import com.talhanation.recruits.client.gui.team.RecruitsTeamList;
import com.talhanation.recruits.client.gui.widgets.ListScreenBase;
import com.talhanation.recruits.network.MessageSendJoinRequestTeam;
import com.talhanation.recruits.network.MessageToServerRequestUpdateTeamList;
import com.talhanation.recruits.world.RecruitsTeam;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class RecruitsTeamListScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/select_player.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.recruits.team_creation.teams_list");
    protected static final Component JOIN_BUTTON = Component.m_237115_((String)"gui.recruits.button.join");
    protected static final Component BACK_BUTTON = Component.m_237115_((String)"gui.recruits.button.back");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected RecruitsTeamList teamList;
    protected EditBox searchBox;
    protected String lastSearch;
    protected int units;
    protected Screen parent;
    private RecruitsTeam selected;
    private Button backButton;
    private Button sendJoinRequestButton;
    private int gapTop;
    private int gapBottom;

    public RecruitsTeamListScreen(Screen parent) {
        super(TITLE, 236, 0);
        this.parent = parent;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageToServerRequestUpdateTeamList());
        this.gapTop = (int)((double)this.f_96544_ * 0.1);
        this.gapBottom = (int)((double)this.f_96544_ * 0.1);
        this.guiLeft += 2;
        this.guiTop = this.gapTop;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.gapTop - this.gapBottom - 16) / 18);
        if (this.teamList != null) {
            this.teamList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.teamList = new RecruitsTeamList(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18, 36, this);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 8, this.guiTop + 16, 220, 16, (Component)Component.m_237113_((String)""));
        this.searchBox.m_94199_(16);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.teamList);
        this.m_264313_((GuiEventListener)this.searchBox);
        int buttonY = this.guiTop + 16 + 5 + this.units * 18;
        this.backButton = new ExtendedButton(this.guiLeft + 129, buttonY, 100, 20, BACK_BUTTON, button -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
        this.sendJoinRequestButton = new ExtendedButton(this.guiLeft + 7, buttonY, 100, 20, JOIN_BUTTON, button -> {
            RecruitsToastManager.setTeamToastForPlayer(RecruitsToastManager.Images.LETTER, RecruitsToastManager.TOAST_SENT_JOIN_REQUEST_TITLE, RecruitsToastManager.TOAST_TO(this.selected.getTeamDisplayName()), this.selected);
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSendJoinRequestTeam(this.parent.getMinecraft().f_91074_.m_20148_(), this.selected.getStringID()));
        });
        this.sendJoinRequestButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.sendJoinRequestButton);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.teamList != null) {
            this.teamList.tick();
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        boolean flag = super.m_7933_(p_96552_, p_96553_, p_96554_);
        this.selected = null;
        this.teamList.m_7522_(null);
        this.sendJoinRequestButton.f_93623_ = false;
        return flag;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.teamList.isEmpty()) {
            this.teamList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, "EMPTY_SEARCH", n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            guiGraphics.m_280056_(this.f_96547_, "", this.searchBox.m_252754_(), this.searchBox.m_252907_(), -1, false);
        }
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.teamList.setFilter(string);
            this.lastSearch = string;
        }
    }

    public boolean m_6375_(double x, double y, int z) {
        if (this.teamList != null) {
            this.teamList.m_6375_(x, y, z);
        }
        boolean flag = super.m_6375_(x, y, z);
        if (this.teamList.m_7222_() != null) {
            this.selected = ((RecruitsTeamEntry)this.teamList.m_7222_()).getTeamInfo();
            this.sendJoinRequestButton.f_93623_ = this.f_96541_.f_91074_.m_5647_() == null;
        }
        return flag;
    }

    public RecruitsTeam getSelected() {
        return this.selected;
    }

    public Component m_96636_() {
        return TITLE;
    }
}

