/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.compat;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import de.maxhenkel.recruits.corelib.death.Death;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Corpse {
    public static void spawnCorpse(AbstractInventoryEntity recruit) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("PlayerUuid", recruit.m_20148_());
        nbt.m_128359_("PlayerName", recruit.m_7755_().getString());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(Arrays.asList(recruit.inventory.m_8020_(4), recruit.inventory.m_8020_(5), recruit.inventory.m_8020_(3), recruit.inventory.m_8020_(2), recruit.inventory.m_8020_(1), recruit.inventory.m_8020_(0)));
        ListTag tagList = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", i);
            ((ItemStack)list.get(i)).m_41739_(slot);
            tagList.add((Object)slot);
        }
        nbt.m_128365_("Equipment", (Tag)tagList);
        ArrayList<ItemStack> list1 = new ArrayList<ItemStack>(Arrays.asList(recruit.inventory.m_8020_(5), recruit.inventory.m_8020_(6), recruit.inventory.m_8020_(7), recruit.inventory.m_8020_(8), recruit.inventory.m_8020_(9), recruit.inventory.m_8020_(10), recruit.inventory.m_8020_(11), recruit.inventory.m_8020_(12), recruit.inventory.m_8020_(13), recruit.inventory.m_8020_(14)));
        ListTag tagList1 = new ListTag();
        for (int k = 0; k < list1.size(); ++k) {
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", k);
            ((ItemStack)list1.get(k)).m_41739_(slot);
            tagList1.add((Object)slot);
        }
        nbt.m_128365_("MainInventory", (Tag)tagList1);
        ArrayList<ItemStack> list2 = new ArrayList<ItemStack>(Arrays.asList(recruit.inventory.m_8020_(3), recruit.inventory.m_8020_(2), recruit.inventory.m_8020_(1), recruit.inventory.m_8020_(0)));
        ListTag tagList2 = new ListTag();
        for (int k = 0; k < list2.size(); ++k) {
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", k);
            ((ItemStack)list2.get(k)).m_41739_(slot);
            tagList2.add((Object)slot);
        }
        nbt.m_128365_("ArmorInventory", (Tag)tagList2);
        ArrayList<ItemStack> list3 = new ArrayList<ItemStack>(List.of(recruit.inventory.m_8020_(4)));
        ListTag tagList3 = new ListTag();
        for (int k = 0; k < list3.size(); ++k) {
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("Slot", k);
            ((ItemStack)list3.get(k)).m_41739_(slot);
            tagList3.add((Object)slot);
        }
        nbt.m_128365_("OffHandInventory", (Tag)tagList3);
        nbt.m_128356_("Timestamp", System.currentTimeMillis());
        nbt.m_128405_("Experience", 6);
        nbt.m_128347_("PosX", recruit.m_20185_());
        nbt.m_128347_("PosY", recruit.m_20186_());
        nbt.m_128347_("PosZ", recruit.m_20189_());
        nbt.m_128359_("Dimension", recruit.m_20193_().m_46472_().m_135782_().toString());
        nbt.m_128344_("Model", (byte)0);
        Death death = Death.fromNBT(nbt);
        try {
            Corpse.createCorpseFromDeath(recruit, death, nbt, (ServerLevel)recruit.m_20193_());
        }
        catch (ClassNotFoundException e) {
            Main.LOGGER.warn("Was not able to spawn recruit corpse for " + recruit.m_7755_().getString());
        }
    }

    public static void createCorpseFromDeath(AbstractInventoryEntity recruit, Death death, CompoundTag deathCompound, ServerLevel level) throws ClassNotFoundException {
        try {
            Class<?> corpseClass = Class.forName("de.maxhenkel.corpse.entities.CorpseEntity");
            Class[] constructorParamTypes = new Class[]{Level.class};
            Constructor<?> corpseConstructor = corpseClass.getConstructor(constructorParamTypes);
            Object corpseInstance = corpseConstructor.newInstance(level);
            Method setUUIDMethod = corpseClass.getMethod("setCorpseUUID", UUID.class);
            setUUIDMethod.invoke(corpseInstance, death.getPlayerUUID());
            Method setNameMethod = corpseClass.getMethod("setCorpseName", String.class);
            setNameMethod.invoke(corpseInstance, death.getPlayerName());
            Method setEquipmentMethod = corpseClass.getMethod("setEquipment", NonNullList.class);
            setEquipmentMethod.invoke(corpseInstance, death.getEquipment());
            Class<?> deathClass = Class.forName("de.maxhenkel.corpse.corelib.death.Death");
            Method deathFromNBTMethod = deathClass.getMethod("fromNBT", CompoundTag.class);
            de.maxhenkel.corpse.corelib.death.Death deathObject = (de.maxhenkel.corpse.corelib.death.Death)deathFromNBTMethod.invoke(null, deathCompound);
            Field deathField = corpseClass.getDeclaredField("death");
            deathField.setAccessible(true);
            deathField.set(corpseInstance, deathObject);
            if (corpseInstance instanceof Entity) {
                Entity corpseEntity = (Entity)corpseInstance;
                corpseEntity.m_6034_(death.getPosX(), Math.max(death.getPosY(), (double)level.m_141937_()), death.getPosZ());
                corpseEntity.m_146922_(recruit.m_146908_());
                level.m_7967_(corpseEntity);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.warn("Was not able to spawn recruit corpse for " + recruit.m_7755_().getString() + e);
        }
    }
}

