/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.compat;

import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;

public class CrossbowWeapon
implements IWeapon {
    @Override
    @Nullable
    public Item getWeapon() {
        return Items.f_42717_;
    }

    @Override
    public double getMoveSpeedAmp() {
        return 0.4;
    }

    @Override
    public int getAttackCooldown() {
        return 30;
    }

    @Override
    public int getWeaponLoadTime() {
        ItemStack weapon = this.getWeapon().m_7968_();
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)weapon);
        return 20 - quickChargeLevel * 4;
    }

    @Override
    public float getProjectileSpeed() {
        return 2.0f;
    }

    @Override
    public AbstractHurtingProjectile getProjectile(LivingEntity shooter) {
        return null;
    }

    @Override
    public AbstractArrow getProjectileArrow(LivingEntity shooter) {
        return new Arrow(shooter.m_20193_(), shooter);
    }

    @Override
    public boolean isLoaded(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof CrossbowItem) {
            return CrossbowItem.m_40932_((ItemStack)itemStack);
        }
        return false;
    }

    @Override
    public void setLoaded(ItemStack stack, boolean loaded) {
    }

    @Override
    public AbstractHurtingProjectile shoot(LivingEntity shooter, AbstractHurtingProjectile projectile, double x, double y, double z) {
        return null;
    }

    @Override
    public AbstractArrow shootArrow(LivingEntity shooter, AbstractArrow projectile, double x, double y, double z) {
        double distance = shooter.m_20275_(x, y, z);
        double heightDiff = y - shooter.m_20186_();
        double d0 = x - shooter.m_20185_();
        double d1 = y - projectile.m_20186_();
        double d2 = z - shooter.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float force = 2.25f;
        float accuracy = 0.2f;
        double angle = IRangedRecruit.getAngleDistanceModifier(distance, 85, 4) + IRangedRecruit.getCrossbowAngleHeightModifier(distance, heightDiff) / 100.0;
        projectile.m_6686_(d0, d1 + d3 * angle, d2, force, accuracy);
        return projectile;
    }

    @Override
    public SoundEvent getShootSound() {
        return SoundEvents.f_11687_;
    }

    @Override
    public SoundEvent getLoadSound() {
        return SoundEvents.f_11841_;
    }

    @Override
    public boolean isGun() {
        return false;
    }

    @Override
    public boolean canMelee() {
        return false;
    }

    @Override
    public boolean isBow() {
        return false;
    }

    @Override
    public boolean isCrossBow() {
        return true;
    }

    @Override
    public void performRangedAttackIWeapon(AbstractRecruitEntity shooter, double x, double y, double z, float projectileSpeed) {
        int k;
        AbstractArrow projectileEntity = this.getProjectileArrow((LivingEntity)shooter);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)shooter.m_21205_());
        if (i > 0) {
            projectileEntity.m_36767_((byte)i);
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)shooter.m_21205_())) > 0) {
            // empty if block
        }
        this.shootArrow((LivingEntity)shooter, projectileEntity, x, y, z);
        shooter.m_5496_(this.getShootSound(), 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.4f + 0.8f));
        shooter.m_20193_().m_7967_((Entity)projectileEntity);
        if (((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
            shooter.consumeArrow();
            projectileEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        shooter.damageMainHandItem();
    }
}

