/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.compat;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import com.talhanation.recruits.util.Kalkuel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SmallShips {
    private final Boat boat;
    private final CaptainEntity captain;

    public SmallShips(Boat boat, CaptainEntity captain) {
        this.boat = boat;
        this.captain = captain;
    }

    public Boat getBoat() {
        return this.boat;
    }

    public static boolean isSmallShip(Entity entity) {
        if (entity == null) {
            return false;
        }
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(entity)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isCaptainDriver() {
        List passengers = this.boat.m_20197_();
        return !passengers.isEmpty() && ((Entity)passengers.get(0)).equals((Object)this.captain);
    }

    public float getShipSpeed() {
        float speed = 0.0f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method shipClassGetSpeed = shipClass.getMethod("getSpeed", new Class[0]);
                speed = ((Float)shipClassGetSpeed.invoke(ship, new Object[0])).floatValue();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
        return speed;
    }

    public void setSailState(int state) {
        try {
            Class<?> sailableClass;
            Field coolDownField;
            int coolDown;
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat) && (coolDown = (coolDownField = shipClass.getField("sailStateCooldown")).getInt(this.boat)) == 0 && (sailableClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Sailable")).isInstance(this.boat)) {
                Object sailable = sailableClass.cast(this.boat);
                Method getSailStateCooldown = sailableClass.getMethod("getSailStateCooldown", new Class[0]);
                int configCoolDown = (Integer)getSailStateCooldown.invoke(sailable, new Object[0]);
                Method setSailState = sailableClass.getMethod("setSailState", Byte.TYPE);
                Method getSailState = sailableClass.getMethod("getSailState", new Class[0]);
                byte currentSail = (Byte)getSailState.invoke(sailable, new Object[0]);
                if (currentSail != (byte)state) {
                    setSailState.invoke(sailable, (byte)state);
                }
                coolDownField.setInt(this.boat, configCoolDown);
            }
        }
        catch (Exception e) {
            Main.LOGGER.info("shipClass oder Sailable-Klasse nicht gefunden: " + e.getMessage());
        }
    }

    public void rotateShip(boolean inputLeft, boolean inputRight) {
        float maxRotSp = 2.0f;
        float rotAcceleration = 0.35f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method getRotSpeed = shipClass.getMethod("getRotSpeed", new Class[0]);
                Method setRotSpeed = shipClass.getMethod("setRotSpeed", Float.TYPE);
                Method updateControls = shipClass.getMethod("updateControls", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Player.class);
                float boatRotSpeed = ((Float)getRotSpeed.invoke(ship, new Object[0])).floatValue();
                updateControls.invoke(ship, false, false, inputLeft, inputRight, null);
                float rotationSpeed = SmallShips.subtractToZero(boatRotSpeed, SmallShips.getVelocityResistance() * 2.5f);
                if (inputRight && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration / 8.0f, maxRotSp);
                }
                if (inputLeft && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration / 8.0f, -maxRotSp);
                }
                this.boat.f_38266_ = rotationSpeed;
                this.boat.m_146922_(this.boat.m_146908_() + this.boat.f_38266_);
                setRotSpeed.invoke(ship, Float.valueOf(rotationSpeed));
            }
        }
        catch (Exception e) {
            Main.LOGGER.info("shipClass nicht gefunden w\u00c3\u00a4hrend rotateShip: " + e.getMessage());
        }
    }

    private static float subtractToZero(float value, float amount) {
        if (value > 0.0f) {
            return Math.max(value - amount, 0.0f);
        }
        if (value < 0.0f) {
            return Math.min(value + amount, 0.0f);
        }
        return 0.0f;
    }

    private static float getVelocityResistance() {
        return 0.007f;
    }

    public void updateBoatControl(double posX, double posZ, double speedFactor, double turnFactor) {
        if (((Entity)this.boat.m_20197_().get(0)).equals((Object)this.captain)) {
            String id = this.boat.m_20078_();
            if (!(Main.isSmallShipsLoaded && Main.isSmallShipsCompatible && id.contains("smallships"))) {
                this.updateVanillaBoatControl(posX, posZ, speedFactor, turnFactor);
            }
        }
    }

    public void updateControl() {
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method controlBoat = shipClass.getDeclaredMethod("controlBoat", new Class[0]);
                controlBoat.setAccessible(true);
                controlBoat.invoke(ship, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("" + e);
        }
    }

    public void updateSmallShipsControl(boolean inputLeft, boolean inputRight, int state) {
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method shipClassIsLeashed = shipClass.getMethod("isShipLeashed", new Class[0]);
                boolean isLeashed = (Boolean)shipClassIsLeashed.invoke(ship, new Object[0]);
                if (!this.boat.m_20069_() || isLeashed) {
                    return;
                }
                this.rotateShip(inputLeft, inputRight);
                this.setSailState(state);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    public void updateSmallShipsControl(double posX, double posZ, int state) {
        double ref;
        Vec3 forward = this.boat.m_20156_().m_82524_(-90.0f).m_82541_();
        Vec3 target = new Vec3(posX, 0.0, posZ);
        Vec3 toTarget = this.boat.m_20182_().m_82546_(target);
        double phi = Kalkuel.horizontalAngleBetweenVectors(forward, toTarget);
        boolean inputLeft = phi < (ref = (double)63.334f);
        boolean inputRight = phi > ref;
        double deviation = Math.abs(phi - ref);
        double stopThreshold = ref * (double)0.8f;
        double slowThreshold = ref * (double)0.35f;
        if (deviation > stopThreshold) {
            state = 0;
        } else if (deviation > slowThreshold) {
            state = 1;
        }
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method shipClassIsLeashed = shipClass.getMethod("isShipLeashed", new Class[0]);
                boolean isLeashed = (Boolean)shipClassIsLeashed.invoke(ship, new Object[0]);
                if (!this.boat.m_20069_() || isLeashed) {
                    return;
                }
                this.rotateShip(inputLeft, inputRight);
                this.setSailState(state);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    public static void rotateSmallShip(Boat boat, boolean inputLeft, boolean inputRight) {
        float maxRotSp = 2.0f;
        float boatRotSpeed = 0.0f;
        float rotAcceleration = 0.35f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(boat)) {
                Object ship = shipClass.cast(boat);
                Method shipClassSetRotSpeed = shipClass.getMethod("setRotSpeed", Float.TYPE);
                Method shipClassGetRotSpeed = shipClass.getMethod("getRotSpeed", new Class[0]);
                Method shipClassUpdateControls = shipClass.getMethod("updateControls", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Player.class);
                boatRotSpeed = ((Float)shipClassGetRotSpeed.invoke(ship, new Object[0])).floatValue();
                shipClassUpdateControls.invoke(ship, false, false, inputLeft, inputRight, null);
                float rotationSpeed = SmallShips.subtractToZero(boatRotSpeed, SmallShips.getVelocityResistance() * 2.5f);
                if (inputRight && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (inputLeft && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
                boat.f_38266_ = rotationSpeed;
                boat.m_146922_(boat.m_146908_() + boat.f_38266_);
                shipClassSetRotSpeed.invoke(ship, Float.valueOf(rotationSpeed));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
    }

    static boolean rotateShipTowardsPos(Boat boat, Vec3 targetVec) {
        boolean rotated = false;
        if (targetVec != null) {
            double ref;
            Vec3 forward = boat.m_20156_().m_82541_();
            Vec3 target = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82480_);
            Vec3 toTarget = boat.m_20182_().m_82546_(target).m_82541_();
            double phi = Kalkuel.horizontalAngleBetweenVectors(forward, toTarget);
            boolean inputLeft = phi < (ref = (double)63.334f);
            boolean inputRight = phi > ref;
            SmallShips.rotateSmallShip(boat, inputLeft, inputRight);
            if (Math.abs(phi - ref) <= ref * (double)0.35f) {
                rotated = true;
            }
        }
        return rotated;
    }

    private void setSmallShipsSailState(Boat boat, int state) {
        block6: {
            try {
                int coolDown;
                Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
                Field coolDownFlied = shipClass.getField("sailStateCooldown");
                if (coolDownFlied == null || (coolDown = coolDownFlied.getInt(boat)) != 0) break block6;
                try {
                    Object sailable;
                    Class<?> sailableClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Sailable");
                    if (sailableClass.isInstance(boat) && (sailable = sailableClass.cast(boat)) != null) {
                        Method sailableClassGetSailStateCooldown = sailableClass.getMethod("getSailStateCooldown", new Class[0]);
                        int configCoolDown = (Integer)sailableClassGetSailStateCooldown.invoke(sailable, new Object[0]);
                        Method sailableClassSetSailState = sailableClass.getMethod("setSailState", Byte.TYPE);
                        Method sailableClassGetSailState = sailableClass.getMethod("getSailState", new Class[0]);
                        byte currentSail = (Byte)sailableClassGetSailState.invoke(sailable, new Object[0]);
                        if (currentSail != (byte)state) {
                            sailableClassSetSailState.invoke(sailable, (byte)state);
                        }
                        coolDownFlied.setInt(boat, configCoolDown);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Main.LOGGER.info("SailableClass was not found");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
    }

    private void updateVanillaBoatControl(double posX, double posZ, double speedFactor, double turnFactor) {
        this.boat.m_20334_(Kalkuel.calculateMotionX((float)speedFactor, this.boat.m_146908_()), this.boat.m_20184_().f_82480_, Kalkuel.calculateMotionZ((float)speedFactor, this.boat.m_146908_()));
    }

    public boolean hasCannons() {
        try {
            Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
            if (cannonAbleClass.isInstance(this.boat)) {
                Object cannonAble = cannonAbleClass.cast(this.boat);
                Method cannonAbleClassGetCannons = cannonAbleClass.getMethod("getCannons", new Class[0]);
                List list = (List)cannonAbleClassGetCannons.invoke(cannonAble, new Object[0]);
                return list.size() > 0;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("Cannonable Class was not found");
        }
        return false;
    }

    public boolean canShootCannons() {
        return SmallShips.canShootCannons((Entity)this.boat);
    }

    public static boolean canShootCannons(Entity vehicle) {
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            try {
                Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
                if (cannonAbleClass.isInstance(boat)) {
                    Object cannonAble = cannonAbleClass.cast(boat);
                    Method cannonAbleClassCanShootCannons = cannonAbleClass.getMethod("canShoot", new Class[0]);
                    return (Boolean)cannonAbleClassCanShootCannons.invoke(cannonAble, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("Cannonable Class was not found");
            }
        }
        return false;
    }

    public static void shootCannonsSmallShip(CaptainEntity driver, Boat boat, Entity target, boolean leftSide) {
        if (boat == null || target == null || driver == null) {
            return;
        }
        double distanceToTarget = driver.m_20280_(target);
        double speed = 3.2f;
        double accuracy = 2.0;
        float rotation = leftSide ? 1.57f : -1.57f;
        Vec3 shootVec = boat.m_20156_().m_82524_(rotation).m_82541_();
        double heightDiff = target.m_20186_() - driver.m_20186_();
        double angle = IRangedRecruit.getCannonAngleDistanceModifier(distanceToTarget, 2) + IRangedRecruit.getCannonAngleHeightModifier(distanceToTarget, heightDiff) / 100.0;
        double yShootVec = shootVec.m_7098_() + angle;
        try {
            Class<?> cannonAbleClass = Class.forName("com.talhanation.smallships.world.entity.ship.abilities.Cannonable");
            if (cannonAbleClass.isInstance(boat)) {
                Object cannonAble = cannonAbleClass.cast(boat);
                Method cannonAbleClassTriggerCannons = cannonAbleClass.getMethod("triggerCannons", Vec3.class, Double.TYPE, LivingEntity.class, Double.TYPE, Double.TYPE);
                cannonAbleClassTriggerCannons.invoke(cannonAble, shootVec, yShootVec, driver, speed, accuracy);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("Cannonable Class was not found");
        }
    }

    @Nullable
    public static ItemStack getSmallShipsItem() {
        return ((Item)ForgeRegistries.ITEMS.getDelegateOrThrow(ResourceLocation.m_135820_((String)"smallships:oak_cog")).get()).m_7968_();
    }

    public void repairShip(CaptainEntity captain) {
        block4: {
            int amount = 10 + captain.m_20193_().f_46441_.m_188503_(5);
            try {
                ItemStack itemStack;
                int i;
                Class<?> shipClass;
                if (!Main.isSmallShipsLoaded || !Main.isSmallShipsCompatible || !this.boat.m_20078_().contains("smallships") || !(shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship")).isInstance(this.boat)) break block4;
                Object ship = shipClass.cast(this.boat);
                Method getDamageMethod = shipClass.getMethod("getDamage", new Class[0]);
                float damage = ((Float)getDamageMethod.invoke(ship, new Object[0])).floatValue();
                if (!(damage > 5.0f)) break block4;
                Method shipRepairMethod = shipClass.getMethod("repairShip", Integer.TYPE);
                shipRepairMethod.invoke(ship, amount);
                for (i = 0; i < captain.getInventory().m_6643_(); ++i) {
                    itemStack = captain.getInventory().m_8020_(i);
                    if (!itemStack.m_204117_(ItemTags.f_13168_)) continue;
                    itemStack.m_41774_(1);
                    break;
                }
                for (i = 0; i < captain.getInventory().m_6643_(); ++i) {
                    itemStack = captain.getInventory().m_8020_(i);
                    if (!itemStack.m_150930_(Items.f_42749_)) continue;
                    itemStack.m_41774_(1);
                    break;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Main.LOGGER.info("shipClass was not found");
            }
        }
    }

    public float getDamage() {
        float damage = 0.0f;
        try {
            Class<?> shipClass = Class.forName("com.talhanation.smallships.world.entity.ship.Ship");
            if (shipClass.isInstance(this.boat)) {
                Object ship = shipClass.cast(this.boat);
                Method shipClassGetDamage = shipClass.getMethod("getDamage", new Class[0]);
                damage = ((Float)shipClassGetDamage.invoke(ship, new Object[0])).floatValue();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Main.LOGGER.info("shipClass was not found");
        }
        return damage;
    }

    public boolean isGalley() {
        return this.boat.m_20078_().contains("galley");
    }
}

