/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.TeamEvents;
import com.talhanation.recruits.compat.Corpse;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.inventory.RecruitSimpleContainer;
import com.talhanation.recruits.pathfinding.AsyncPathfinderMob;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInventoryEntity
extends AsyncPathfinderMob {
    public RecruitSimpleContainer inventory;
    private int beforeItemSlot = -1;
    private LazyOptional<?> itemHandler = null;

    public AbstractInventoryEntity(EntityType<? extends AbstractInventoryEntity> entityType, Level world) {
        super(entityType, world);
        this.createInventory();
        this.m_21553_(true);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        nbt.m_128365_("Items", (Tag)listnbt);
        nbt.m_128405_("BeforeItemSlot", this.getBeforeItemSlot());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ListTag listnbt = nbt.m_128437_("Items", 10);
        this.createInventory();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        ListTag armorItems = nbt.m_128437_("ArmorItems", 10);
        for (int i = 0; i < this.f_21351_.size(); ++i) {
            int index = this.getInventorySlotIndex(Mob.m_147233_((ItemStack)ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i))));
            this.inventory.m_6836_(index, ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i)));
        }
        ListTag handItems = nbt.m_128437_("HandItems", 10);
        for (int i = 0; i < this.f_21350_.size(); ++i) {
            int index = i == 0 ? 5 : 4;
            this.inventory.m_6836_(index, ItemStack.m_41712_((CompoundTag)handItems.m_128728_(i)));
        }
        int beforeItemSlot = nbt.m_128451_("BeforeItemSlot");
        this.setBeforeItemSlot(beforeItemSlot);
        if (this.getBeforeItemSlot() != -1) {
            this.resetItemInHand();
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return 15;
    }

    public int getInventoryColumns() {
        return 3;
    }

    public int getInventorySlotIndex(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return 0;
            }
            case CHEST: {
                return 1;
            }
            case LEGS: {
                return 2;
            }
            case FEET: {
                return 3;
            }
            case OFFHAND: {
                return 4;
            }
            case MAINHAND: {
                return 5;
            }
        }
        return 6;
    }

    public EquipmentSlot getEquipmentSlotIndex(int id) {
        switch (id) {
            case 0: {
                return EquipmentSlot.HEAD;
            }
            case 1: {
                return EquipmentSlot.CHEST;
            }
            case 2: {
                return EquipmentSlot.LEGS;
            }
            case 3: {
                return EquipmentSlot.FEET;
            }
            case 4: {
                return EquipmentSlot.OFFHAND;
            }
            case 5: {
                return EquipmentSlot.MAINHAND;
            }
        }
        return null;
    }

    public void m_21008_(@NotNull InteractionHand hand, @NotNull ItemStack itemStack) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
            this.inventory.m_6836_(5, itemStack);
        } else {
            if (hand != InteractionHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.m_8061_(EquipmentSlot.OFFHAND, itemStack);
            this.inventory.m_6836_(4, itemStack);
        }
    }

    public void m_8061_(@NotNull EquipmentSlot slotIn, @NotNull ItemStack stack) {
        super.m_8061_(slotIn, stack);
        switch (slotIn) {
            case HEAD: {
                if (!this.inventory.m_8020_(0).m_41619_()) break;
                this.inventory.m_6836_(0, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case CHEST: {
                if (!this.inventory.m_8020_(1).m_41619_()) break;
                this.inventory.m_6836_(1, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case LEGS: {
                if (!this.inventory.m_8020_(2).m_41619_()) break;
                this.inventory.m_6836_(2, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case FEET: {
                if (!this.inventory.m_8020_(3).m_41619_()) break;
                this.inventory.m_6836_(3, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case OFFHAND: {
                if (!this.inventory.m_8020_(4).m_41619_()) break;
                this.inventory.m_6836_(4, (ItemStack)this.f_21350_.get(slotIn.m_20749_()));
                break;
            }
            case MAINHAND: {
                if (!this.inventory.m_8020_(5).m_41619_()) break;
                this.inventory.m_6836_(5, (ItemStack)this.f_21350_.get(slotIn.m_20749_()));
            }
        }
    }

    @NotNull
    public SlotAccess m_141942_(int slot) {
        return slot == 499 ? new SlotAccess(){

            public ItemStack m_142196_() {
                return new ItemStack((ItemLike)Items.f_42009_);
            }

            public boolean m_142104_(ItemStack stack) {
                if (stack.m_41619_()) {
                    AbstractInventoryEntity.this.createInventory();
                    return true;
                }
                return false;
            }
        } : super.m_141942_(slot);
    }

    public void createInventory() {
        RecruitSimpleContainer inventory = this.inventory;
        this.inventory = new RecruitSimpleContainer(this.getInventorySize(), this){};
        if (inventory != null) {
            int i = Math.min(inventory.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void m_6667_(DamageSource dmg) {
        super.m_6667_(dmg);
        if (Main.isCorpseLoaded && !Main.isRPGZLoaded && !this.m_20193_().m_5776_() && ((Boolean)RecruitsServerConfig.CompatCorpseMod.get()).booleanValue()) {
            Corpse.spawnCorpse(this);
        } else if (this.m_20193_().m_46469_().m_46207_(GameRules.f_46137_)) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                this.m_19983_(this.inventory.m_8020_(i));
            }
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.canEquipItem(itemstack)) {
            this.equipItem(itemstack);
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
        } else {
            RecruitSimpleContainer inventory = this.inventory;
            boolean flag = inventory.m_19183_(itemstack);
            if (!flag) {
                return;
            }
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            ItemStack itemstack1 = inventory.m_19173_(itemstack);
            if (itemstack1.m_41619_()) {
                itemEntity.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    public void equipItem(ItemStack itemStack) {
        EquipmentSlot equipmentslot = AbstractInventoryEntity.m_147233_(itemStack);
        ItemStack currentArmor = this.m_6844_(equipmentslot);
        this.m_19983_(currentArmor);
        this.m_8061_(equipmentslot, itemStack);
        this.inventory.m_6836_(this.getInventorySlotIndex(equipmentslot), itemStack);
        Equipable equipable = Equipable.m_269088_((ItemStack)itemStack);
        if (equipable != null) {
            this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), equipable.m_150681_(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public boolean canEquipItem(@NotNull ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            EquipmentSlot equipmentslot = AbstractInventoryEntity.m_147233_(itemStack);
            ItemStack currentArmor = this.m_6844_(equipmentslot);
            boolean flag = this.m_7808_(itemStack, currentArmor);
            return flag && this.m_7252_(itemStack);
        }
        return false;
    }

    public boolean hasSameTypeOfItem(ItemStack stack) {
        return this.getInventory().f_19147_.stream().anyMatch(itemStack -> itemStack.m_41778_().equals(stack.m_41778_()));
    }

    public boolean canEquipItemToSlot(@NotNull ItemStack itemStack, EquipmentSlot slot) {
        if (!itemStack.m_41619_()) {
            ItemStack currentArmor = this.m_6844_(slot);
            boolean flag = this.m_7808_(itemStack, currentArmor);
            return flag && this.m_7252_(itemStack) && itemStack.canEquip(slot, (Entity)this);
        }
        return false;
    }

    public boolean m_7243_(@NotNull ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ArmorItem) {
            EquipmentSlot equipmentslot = AbstractInventoryEntity.m_147233_(itemStack);
            return this.m_6844_(equipmentslot).m_41619_() && !this.hasSameTypeOfItem(itemStack) && this.canEquipItem(itemStack);
        }
        return itemStack.m_41614_();
    }

    @NotNull
    public static EquipmentSlot m_147233_(ItemStack itemStack) {
        EquipmentSlot slot = itemStack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Item item = itemStack.m_41720_();
        if (!(itemStack.m_150930_(Items.f_42047_) || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock)) {
            if (item instanceof ArmorItem) {
                return ((ArmorItem)item).m_40402_();
            }
            if (itemStack.m_150930_(Items.f_42741_)) {
                return EquipmentSlot.CHEST;
            }
            if (item instanceof SwordItem) {
                return EquipmentSlot.MAINHAND;
            }
            return itemStack.canPerformAction(ToolActions.SHIELD_BLOCK) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        }
        return EquipmentSlot.HEAD;
    }

    protected boolean m_7808_(@NotNull ItemStack replacer, ItemStack current) {
        if (current.m_41619_()) {
            return true;
        }
        Item item = current.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem digger = (DiggerItem)item;
            item = replacer.m_41720_();
            if (item instanceof SwordItem) {
                SwordItem sword = (SwordItem)item;
                if (digger.m_41008_() != sword.m_43299_()) {
                    return digger.m_41008_() < sword.m_43299_();
                }
                return this.m_21477_(replacer, current);
            }
        }
        if (replacer.m_41720_() instanceof SwordItem) {
            if (!(current.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem sworditem = (SwordItem)replacer.m_41720_();
            SwordItem sworditem1 = (SwordItem)current.m_41720_();
            if (sworditem.m_43299_() != sworditem1.m_43299_()) {
                return sworditem.m_43299_() > sworditem1.m_43299_();
            }
            return this.m_21477_(replacer, current);
        }
        if (replacer.m_41720_() instanceof BowItem && current.m_41720_() instanceof BowItem) {
            return this.m_21477_(replacer, current);
        }
        if (replacer.m_41720_() instanceof CrossbowItem && current.m_41720_() instanceof CrossbowItem) {
            return this.m_21477_(replacer, current);
        }
        if (replacer.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)current)) {
                return false;
            }
            if (!(current.m_41720_() instanceof ArmorItem)) {
                return true;
            }
            ArmorItem armoritem = (ArmorItem)replacer.m_41720_();
            ArmorItem armoritem1 = (ArmorItem)current.m_41720_();
            if (armoritem.m_40404_() != armoritem1.m_40404_()) {
                return armoritem.m_40404_() > armoritem1.m_40404_();
            }
            if (armoritem.m_40405_() != armoritem1.m_40405_()) {
                return armoritem.m_40405_() > armoritem1.m_40405_();
            }
            return this.m_21477_(replacer, current);
        }
        if (replacer.m_41720_() instanceof DiggerItem) {
            if (current.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (current.m_41720_() instanceof DiggerItem) {
                DiggerItem diggeritem = (DiggerItem)replacer.m_41720_();
                DiggerItem diggeritem1 = (DiggerItem)current.m_41720_();
                if (diggeritem.m_41008_() != diggeritem1.m_41008_()) {
                    return diggeritem.m_41008_() > diggeritem1.m_41008_();
                }
                return this.m_21477_(replacer, current);
            }
        }
        return false;
    }

    public abstract Predicate<ItemEntity> getAllowedItems();

    public abstract void openGUI(Player var1);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public void consumeArrow() {
        for (ItemStack itemStack : this.inventory.f_19147_) {
            if (!itemStack.m_204117_(ItemTags.f_13161_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    public boolean canTakeArrows() {
        int count = 0;
        for (ItemStack itemstack : this.inventory.f_19147_) {
            if (!itemstack.m_204117_(ItemTags.f_13161_)) continue;
            count += itemstack.m_41613_();
        }
        return count < 32;
    }

    public boolean canTakeCannonBalls() {
        int count = 0;
        for (ItemStack itemstack : this.inventory.f_19147_) {
            if (!itemstack.m_41778_().contains("cannon_ball")) continue;
            count += itemstack.m_41613_();
        }
        return count < 50;
    }

    public boolean canTakePlanks() {
        int count = 0;
        for (ItemStack itemstack : this.inventory.f_19147_) {
            if (!itemstack.m_204117_(ItemTags.f_13168_)) continue;
            count += itemstack.m_41613_();
        }
        return count < 64;
    }

    public boolean canTakeIronNuggets() {
        int count = 0;
        for (ItemStack itemstack : this.inventory.f_19147_) {
            if (!itemstack.m_150930_(Items.f_42749_)) continue;
            count += itemstack.m_41613_();
        }
        return count < 64;
    }

    public boolean canTakeCartridge() {
        int count = 0;
        for (ItemStack itemstack : this.inventory.f_19147_) {
            if (!itemstack.m_41778_().contains("cartridge")) continue;
            count += itemstack.m_41613_();
        }
        return count < 32;
    }

    public void resetItemInHand() {
        ItemStack foodStack = this.m_21206_().m_41777_();
        ItemStack beforeItem = this.inventory.m_8020_(this.getBeforeItemSlot()).m_41777_();
        this.inventory.m_8016_(this.getBeforeItemSlot());
        this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        this.m_21008_(InteractionHand.OFF_HAND, beforeItem.m_41777_());
        this.inventory.m_6836_(this.getBeforeItemSlot(), foodStack.m_41777_());
        this.setBeforeItemSlot(-1);
    }

    public boolean isPaymentInContainer(Container container) {
        int amount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_150930_(TeamEvents.getCurrency().m_41720_())) continue;
            amount += itemStack.m_41613_();
        }
        return amount >= (Integer)RecruitsServerConfig.RecruitsPaymentAmount.get();
    }

    @Nullable
    public ItemStack getCurrencyFromInv(Container inv) {
        ItemStack currency = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (!itemStack.m_150930_(TeamEvents.getCurrency().m_41720_())) continue;
            currency = itemStack;
            break;
        }
        return currency;
    }

    public void doPayment(Container container) {
        int amount = (Integer)RecruitsServerConfig.RecruitsPaymentAmount.get();
        for (int i = 0; i < amount; ++i) {
            ItemStack currency = this.getCurrencyFromInv(container);
            if (currency == null) continue;
            currency.m_41774_(amount);
        }
    }

    public void setBeforeItemSlot(int i) {
        this.beforeItemSlot = i;
    }

    public int getBeforeItemSlot() {
        return this.beforeItemSlot;
    }
}

