/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.ai.FleeFire;
import com.talhanation.recruits.entities.ai.FleeTNT;
import com.talhanation.recruits.entities.ai.FleeTarget;
import com.talhanation.recruits.entities.ai.UseShield;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class AbstractOrderAbleEntity
extends AbstractInventoryEntity {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> HOME_POS = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> XP = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> isEating = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> isInOrder = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(AbstractOrderAbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ItemStack beforeFoodItem;

    public AbstractOrderAbleEntity(EntityType<? extends AbstractOrderAbleEntity> entityType, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)entityType, world);
        this.f_21364_ = 12;
    }

    public double m_6049_() {
        return -0.35;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_21203_();
        this.m_5844_();
        if (this.getIsEating() && !this.m_6117_()) {
            if (this.beforeFoodItem != null) {
                this.resetItemInHand();
            }
            this.setIsEating(false);
        }
    }

    public void m_6083_() {
        super.m_6083_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        return spawnData;
    }

    public void setDropEquipment() {
        this.m_5907_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FleeTNT(this));
        this.f_21345_.m_25352_(0, (Goal)new FleeTarget(this));
        this.f_21345_.m_25352_(0, (Goal)new FleeFire(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new UseShield(this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.15, true));
        this.f_21345_.m_25352_(7, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.15, 32.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(FLEEING, (Object)false);
        this.f_19804_.m_135372_(XP, (Object)0);
        this.f_19804_.m_135372_(KILLS, (Object)0);
        this.f_19804_.m_135372_(LEVEL, (Object)1);
        this.f_19804_.m_135372_(isEating, (Object)true);
        this.f_19804_.m_135372_(isInOrder, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("isInOrder", this.getIsInOrder());
        nbt.m_128379_("Fleeing", this.getFleeing());
        nbt.m_128379_("isEating", this.getIsEating());
        nbt.m_128405_("Xp", this.getXp());
        nbt.m_128405_("Level", this.getXpLevel());
        nbt.m_128405_("Kills", this.getKills());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setIsInOrder(nbt.m_128471_("isInOrder"));
        this.setXpLevel(nbt.m_128451_("Level"));
        this.setFleeing(nbt.m_128471_("Fleeing"));
        this.setIsEating(nbt.m_128471_("isEating"));
        this.setXp(nbt.m_128451_("Xp"));
        this.setKills(nbt.m_128451_("Kills"));
    }

    public boolean getIsInOrder() {
        return (Boolean)this.f_19804_.m_135370_(isInOrder);
    }

    public BlockPos getAssassinOnPos() {
        return this.m_20097_();
    }

    public boolean getFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public int getKills() {
        return (Integer)this.f_19804_.m_135370_(KILLS);
    }

    public int getXpLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public int getXp() {
        return (Integer)this.f_19804_.m_135370_(XP);
    }

    public boolean getIsEating() {
        return (Boolean)this.f_19804_.m_135370_(isEating);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(Pose pos, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    public int m_8132_() {
        return super.m_8132_();
    }

    public int m_5792_() {
        return 8;
    }

    public BlockPos getHomePos() {
        return ((Optional)this.f_19804_.m_135370_(HOME_POS)).orElse(null);
    }

    public void setIsInOrder(boolean bool) {
        this.f_19804_.m_135381_(isInOrder, (Object)bool);
    }

    public void setFleeing(boolean bool) {
        this.f_19804_.m_135381_(FLEEING, (Object)bool);
    }

    public void addXpLevel(int level) {
        int currentLevel = this.getXpLevel();
        int newLevel = currentLevel + level;
        this.makelevelUpSound();
        this.f_19804_.m_135381_(LEVEL, (Object)newLevel);
    }

    public void setKills(int kills) {
        this.f_19804_.m_135381_(KILLS, (Object)kills);
    }

    public void setXpLevel(int XpLevel) {
        this.f_19804_.m_135381_(LEVEL, (Object)XpLevel);
    }

    public void setXp(int xp) {
        this.f_19804_.m_135381_(XP, (Object)xp);
    }

    public void addXp(int xp) {
        int currentXp = this.getXp();
        int newXp = currentXp + xp;
        this.f_19804_.m_135381_(XP, (Object)newXp);
    }

    public void setIsEating(boolean bool) {
        this.f_19804_.m_135381_(isEating, (Object)bool);
    }

    public void setEquipment() {
    }

    public boolean m_6469_(DamageSource dmg, float amt) {
        if (this.m_6673_(dmg)) {
            return false;
        }
        Entity entity = dmg.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amt = (amt + 1.0f) / 2.0f;
        }
        this.addXp(1);
        this.checkLevel();
        return super.m_6469_(dmg, amt);
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        this.addXp(2);
        this.checkLevel();
        this.damageMainHandItem();
        return flag;
    }

    public void addLevelBuffs() {
        int level = this.getXpLevel();
        if (level <= 10) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 3.0, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("attack_bonus_level", 0.15, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("knockback_bonus_level", 0.01, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("speed_bonus_level", 0.01, AttributeModifier.Operation.ADDITION));
        }
        if (level > 10) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof AbstractOrderAbleEntity) {
                AbstractOrderAbleEntity otherRecruit = (AbstractOrderAbleEntity)target;
                return false;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    @Override
    public void m_6667_(DamageSource dmg) {
        super.m_6667_(dmg);
    }

    public void checkLevel() {
        int currentXp = this.getXp();
        if (currentXp >= 1000) {
            this.addXpLevel(1);
            this.setXp(0);
            this.addLevelBuffs();
            this.m_5634_(10.0f);
        }
    }

    public void makelevelUpSound() {
        this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_12509_, this.m_5720_(), 15.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_12275_, this.m_5720_(), 15.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 11; i < 15; ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (damageSource.m_276093_(DamageTypes.f_268631_) && damageSource.m_276093_(DamageTypes.f_268468_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                itemstack.m_41721_((int)damage);
            }
        }
    }

    protected void damageMainHandItem() {
        ItemStack itemstack = this.inventory.m_8020_(9);
        if (itemstack.m_41720_().isDamageable(itemstack)) {
            itemstack.m_41721_(1);
        }
    }

    public boolean m_214076_(ServerLevel p_241847_1_, LivingEntity p_241847_2_) {
        this.addXp(2);
        this.setKills(this.getKills() + 1);
        return super.m_214076_(p_241847_1_, p_241847_2_);
    }

    protected void m_7909_(float damage) {
        if (this.f_20935_.m_41720_() instanceof ShieldItem) {
            ItemStack itemstack;
            int i = 1 + Mth.m_14143_((float)damage);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, entity -> entity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.m_141942_(9).m_142104_(ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    this.m_141942_(10).m_142104_(ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                this.m_141942_(10).m_142104_(ItemStack.f_41583_);
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_20193_().f_46441_.m_188501_() * 0.4f);
            }
            if ((itemstack = this.inventory.m_8020_(10)).m_41720_() instanceof ShieldItem) {
                itemstack.m_41721_((int)damage);
            }
        }
    }

    @Override
    public abstract void openGUI(Player var1);

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_20193_().f_46443_) {
            boolean flag = false;
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_()) {
            int i = this.f_19796_.m_188503_(5);
            switch (i) {
                case 0: {
                    player.m_213846_((Component)Component.m_237113_((String)(this.m_7755_().getString() + ":  Hello my Friend.")));
                    break;
                }
                case 1: {
                    player.m_213846_((Component)Component.m_237113_((String)(this.m_7755_().getString() + ": Life is only worth as much as emeralds...")));
                    break;
                }
                default: {
                    player.m_213846_((Component)Component.m_237113_((String)(this.m_7755_().getString() + ": Pay me I'll get rid of your headache!")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

