/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ICompanion;
import java.util.Comparator;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RestGoal
extends Goal {
    private final AbstractRecruitEntity recruit;
    private Stack<BlockPos> stackOfBeds;
    private BlockPos sleepPos;
    private long lastCanUseCheck;
    public static final IntegerProperty MULTI_BLOCK_INDEX = IntegerProperty.m_61631_((String)"multi_block_index", (int)0, (int)2);

    public RestGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    private boolean isHealth() {
        return this.recruit.m_21223_() < this.recruit.m_21233_();
    }

    private boolean isMorale() {
        return this.recruit.getMorale() < 45.0f;
    }

    private boolean canRest() {
        ICompanion companion;
        AbstractRecruitEntity abstractRecruitEntity = this.recruit;
        if (abstractRecruitEntity instanceof ICompanion && (companion = (ICompanion)((Object)abstractRecruitEntity)).isAtMission()) {
            return false;
        }
        return !(!this.recruit.getShouldRest() && !this.recruit.m_20193_().m_46462_() || this.recruit.getFollowState() != 0 || this.recruit.m_5448_() != null || !this.isMorale() && !this.isHealth());
    }

    public boolean m_8036_() {
        long i = this.recruit.m_20193_().m_46467_();
        if (i - this.lastCanUseCheck >= 20L) {
            this.lastCanUseCheck = i;
            return this.canRest();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.canRest();
    }

    public void m_8056_() {
        super.m_8056_();
        this.stackOfBeds = this.getListOfBeds();
    }

    public void m_8041_() {
        super.m_8041_();
        this.stackOfBeds.removeAllElements();
        this.recruit.m_5796_();
        this.recruit.m_21258_();
        this.recruit.setShouldRest(false);
    }

    public void m_8037_() {
        if (this.recruit.m_5803_()) {
            this.recruit.m_21573_().m_26573_();
            this.recruit.m_5634_(0.0025f);
            if (this.recruit.getMorale() < 60.0f) {
                this.recruit.setMoral(this.recruit.getMorale() + 0.0025f);
            }
            return;
        }
        if (!this.stackOfBeds.isEmpty()) {
            if (this.sleepPos != null) {
                BlockState state = this.recruit.m_20193_().m_8055_(this.sleepPos);
                if (state.isBed((BlockGetter)this.recruit.m_20193_(), this.sleepPos, (LivingEntity)this.recruit) && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61445_)).booleanValue()) {
                    this.goToBed(this.sleepPos);
                } else {
                    this.sleepPos = this.stackOfBeds.pop();
                }
            } else {
                this.sleepPos = this.stackOfBeds.pop();
            }
        } else {
            this.m_8041_();
        }
    }

    private void goToBed(BlockPos bedPos) {
        if (bedPos == null) {
            return;
        }
        PathNavigation pathFinder = this.recruit.m_21573_();
        pathFinder.m_26519_((double)bedPos.m_123341_(), (double)bedPos.m_123342_(), (double)bedPos.m_123343_(), 1.0);
        this.recruit.m_21563_().m_24950_((double)bedPos.m_123341_(), (double)(bedPos.m_123342_() + 1), (double)bedPos.m_123343_(), 10.0f, (float)this.recruit.m_8132_());
        if (bedPos.m_203193_((Position)this.recruit.m_20182_()) <= 75.0) {
            this.recruit.m_5802_(bedPos);
            this.recruit.m_21250_(bedPos);
            pathFinder.m_26573_();
        }
    }

    private Stack<BlockPos> getListOfBeds() {
        Stack<BlockPos> stack = new Stack<BlockPos>();
        int range = 25;
        for (int x = -range; x < range; ++x) {
            for (int y = -3; y < 10; ++y) {
                for (int z = -range; z < range; ++z) {
                    BlockPos pos2 = this.recruit.m_20097_().m_7918_(x, y, z);
                    BlockState state = this.recruit.m_20193_().m_8055_(pos2);
                    if (!state.isBed((BlockGetter)this.recruit.m_20193_(), pos2, (LivingEntity)this.recruit) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61445_)).booleanValue()) continue;
                    try {
                        if ((Integer)state.m_61143_((Property)MULTI_BLOCK_INDEX) == 1) {
                            stack.push(pos2);
                            continue;
                        }
                        if (state.m_61143_((Property)BlockStateProperties.f_61391_) != BedPart.HEAD) continue;
                        stack.push(pos2);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        stack.push(pos2);
                    }
                }
            }
        }
        stack.sort(Comparator.comparing(pos -> this.recruit.m_20238_(pos.m_252807_())));
        return stack;
    }
}

