/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.async;

import com.talhanation.recruits.util.ProcessState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.NotNull;

public class FindTarget<T extends LivingEntity> {
    public volatile ProcessState processState = ProcessState.WAITING;
    private final double followDistance;
    private final List<Runnable> postProcessing = new ArrayList<Runnable>(0);
    protected final Class<T> targetType;
    private Deque<LivingEntity> targetStack = new ArrayDeque<LivingEntity>();
    protected TargetingConditions targetConditionsNormal;
    private final Mob mob;

    public FindTarget(Mob mob, Class<T> targetType, double followDistance, @Nullable Predicate<LivingEntity> predicate) {
        this.targetType = targetType;
        this.mob = mob;
        this.followDistance = followDistance;
        this.targetConditionsNormal = TargetingConditions.m_148352_().m_26883_(followDistance).m_26888_(predicate).m_148355_();
    }

    protected AABB getTargetSearchArea(double range) {
        return this.mob.m_20191_().m_82377_(range, range, range);
    }

    public synchronized void findTargetNormal() {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        if (this.processState == ProcessState.COMPLETED || this.processState == ProcessState.PROCESSING) {
            return;
        }
        this.processState = ProcessState.PROCESSING;
        List list = this.mob.m_20193_().m_45976_(this.targetType, this.getTargetSearchArea(this.followDistance));
        list.sort(Comparator.comparingDouble(entry -> entry.m_20280_((Entity)this.mob)));
        ArrayDeque<LivingEntity> newStack = new ArrayDeque<LivingEntity>();
        for (LivingEntity entry2 : list) {
            boolean passesFilter = this.targetConditionsNormal.m_26885_((LivingEntity)this.mob, entry2);
            if (!passesFilter) continue;
            newStack.addLast(entry2);
        }
        if (newStack.isEmpty()) {
            this.processState = ProcessState.COMPLETED;
            return;
        }
        this.targetStack = newStack;
        this.processState = ProcessState.COMPLETED;
        for (Runnable runnable : this.postProcessing) {
            runnable.run();
        }
    }

    public synchronized void postProcessing(@NotNull Runnable runnable) {
        if (this.isProcessed()) {
            runnable.run();
        } else {
            this.postProcessing.add(runnable);
        }
    }

    public Deque<LivingEntity> getTargets() {
        this.checkProcessed();
        return this.targetStack;
    }

    private void checkProcessed() {
        if (this.processState == ProcessState.WAITING || this.processState == ProcessState.PROCESSING) {
            this.findTargetNormal();
        }
    }

    public boolean isProcessed() {
        return this.processState == ProcessState.COMPLETED;
    }

    public synchronized void reset() {
        this.processState = ProcessState.WAITING;
        this.targetStack.clear();
        this.postProcessing.clear();
    }
}

