/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.entities.MessengerEntity;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageSendMessenger
implements Message<MessageSendMessenger> {
    private UUID recruit;
    private boolean start;
    private CompoundTag nbt;
    private String message;

    public MessageSendMessenger() {
    }

    public MessageSendMessenger(UUID recruit, RecruitsPlayerInfo targetPlayer, String message, boolean start) {
        this.recruit = recruit;
        this.message = message;
        this.start = start;
        this.nbt = targetPlayer != null ? targetPlayer.toNBT() : new CompoundTag();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(MessengerEntity.class, player.m_20191_().m_82400_(16.0), messenger -> messenger.m_20148_().equals(this.recruit)).forEach(messenger -> {
            if (messenger.m_20148_().equals(this.recruit)) {
                messenger.setMessage(this.message);
                if (!this.nbt.m_128456_()) {
                    messenger.setTargetPlayerInfo(RecruitsPlayerInfo.getFromNBT(this.nbt));
                }
                if (this.start) {
                    messenger.start();
                }
            }
        });
    }

    @Override
    public MessageSendMessenger fromBytes(FriendlyByteBuf buf) {
        this.recruit = buf.m_130259_();
        this.start = buf.readBoolean();
        this.message = buf.m_130277_();
        this.nbt = buf.m_130260_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.recruit);
        buf.writeBoolean(this.start);
        buf.m_130070_(this.message);
        buf.m_130079_(this.nbt);
    }
}

