/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.init.ModItems;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageWriteSpawnEgg
implements Message<MessageWriteSpawnEgg> {
    private UUID recruit;

    public MessageWriteSpawnEgg() {
    }

    public MessageWriteSpawnEgg(UUID recruit) {
        this.recruit = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(64.0), recruit -> recruit.m_20148_().equals(this.recruit)).forEach(recruitEntity -> {
            EntityType type = recruitEntity.m_6095_();
            ItemStack itemStack = null;
            if (type.m_20675_().equals("entity.recruits.recruit")) {
                itemStack = new ItemStack((ItemLike)ModItems.RECRUIT_SPAWN_EGG.get());
            } else if (type.m_20675_().equals("entity.recruits.recruit_shieldman")) {
                itemStack = new ItemStack((ItemLike)ModItems.RECRUIT_SHIELD_SPAWN_EGG.get());
            } else if (type.m_20675_().equals("entity.recruits.bowman")) {
                itemStack = new ItemStack((ItemLike)ModItems.BOWMAN_SPAWN_EGG.get());
            } else if (type.m_20675_().equals("entity.recruits.crossbowman")) {
                itemStack = new ItemStack((ItemLike)ModItems.CROSSBOWMAN_SPAWN_EGG.get());
            } else if (type.m_20675_().equals("entity.recruits.horseman")) {
                itemStack = new ItemStack((ItemLike)ModItems.HORSEMAN_SPAWN_EGG.get());
            } else if (type.m_20675_().equals("entity.recruits.nomad")) {
                itemStack = new ItemStack((ItemLike)ModItems.NOMAD_SPAWN_EGG.get());
            }
            CompoundTag entityTag = new CompoundTag();
            String name = recruitEntity.m_7755_().getString();
            Team team = recruitEntity.m_5647_();
            if (team != null) {
                entityTag.m_128359_("Team", team.m_5758_());
            }
            entityTag.m_128359_("Name", name);
            entityTag.m_128405_("AggroState", recruitEntity.getState());
            entityTag.m_128405_("FollowState", recruitEntity.getFollowState());
            entityTag.m_128379_("ShouldFollow", recruitEntity.getShouldFollow());
            entityTag.m_128379_("ShouldMount", recruitEntity.getShouldMount());
            entityTag.m_128379_("ShouldProtect", recruitEntity.getShouldProtect());
            entityTag.m_128379_("ShouldBlock", recruitEntity.getShouldBlock());
            entityTag.m_128405_("Group", recruitEntity.getGroup());
            entityTag.m_128405_("Variant", recruitEntity.getVariant());
            entityTag.m_128379_("Listen", recruitEntity.getListen());
            entityTag.m_128379_("Fleeing", recruitEntity.getFleeing());
            entityTag.m_128379_("isFollowing", recruitEntity.isFollowing());
            entityTag.m_128405_("Xp", recruitEntity.getXp());
            entityTag.m_128405_("Level", recruitEntity.getXpLevel());
            entityTag.m_128405_("Kills", recruitEntity.getKills());
            entityTag.m_128350_("Hunger", recruitEntity.getHunger());
            entityTag.m_128350_("Moral", recruitEntity.getMorale());
            entityTag.m_128379_("isOwned", recruitEntity.getIsOwned());
            entityTag.m_128405_("Cost", recruitEntity.getCost());
            entityTag.m_128405_("mountTimer", recruitEntity.getMountTimer());
            entityTag.m_128405_("upkeepTimer", recruitEntity.getUpkeepTimer());
            entityTag.m_128405_("Color", recruitEntity.getColor());
            entityTag.m_128405_("Biome", recruitEntity.getBiome());
            if (recruitEntity.getHoldPos() != null) {
                entityTag.m_128347_("HoldPosX", recruitEntity.getHoldPos().m_7096_());
                entityTag.m_128347_("HoldPosY", recruitEntity.getHoldPos().m_7098_());
                entityTag.m_128347_("HoldPosZ", recruitEntity.getHoldPos().m_7094_());
                entityTag.m_128379_("ShouldHoldPos", recruitEntity.getShouldHoldPos());
            }
            if (recruitEntity.getMovePos() != null) {
                entityTag.m_128405_("MovePosX", recruitEntity.getMovePos().m_123341_());
                entityTag.m_128405_("MovePosY", recruitEntity.getMovePos().m_123342_());
                entityTag.m_128405_("MovePosZ", recruitEntity.getMovePos().m_123343_());
                entityTag.m_128379_("ShouldMovePos", recruitEntity.getShouldMovePos());
            }
            if (recruitEntity.getOwnerUUID() != null) {
                entityTag.m_128362_("OwnerUUID", recruitEntity.getOwnerUUID());
            }
            if (recruitEntity.getMountUUID() != null) {
                entityTag.m_128362_("MountUUID", recruitEntity.getMountUUID());
            }
            if (recruitEntity.getProtectUUID() != null) {
                entityTag.m_128362_("ProtectUUID", recruitEntity.getProtectUUID());
            }
            if (recruitEntity.getUpkeepUUID() != null) {
                entityTag.m_128362_("UpkeepUUID", recruitEntity.getUpkeepUUID());
            }
            if (recruitEntity.getUpkeepPos() != null) {
                entityTag.m_128405_("UpkeepPosX", recruitEntity.getUpkeepPos().m_123341_());
                entityTag.m_128405_("UpkeepPosY", recruitEntity.getUpkeepPos().m_123342_());
                entityTag.m_128405_("UpkeepPosZ", recruitEntity.getUpkeepPos().m_123343_());
            }
            ListTag listnbt = new ListTag();
            for (int i = 0; i < recruitEntity.inventory.m_6643_(); ++i) {
                ItemStack itemstack = recruitEntity.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundnbt = new CompoundTag();
                compoundnbt.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            entityTag.m_128365_("Items", (Tag)listnbt);
            ListTag listtag = new ListTag();
            for (Object itemstack : recruitEntity.f_21351_) {
                CompoundTag compoundtag = new CompoundTag();
                if (!itemstack.m_41619_()) {
                    itemstack.m_41739_(compoundtag);
                }
                listtag.add((Object)compoundtag);
            }
            entityTag.m_128365_("ArmorItems", (Tag)listtag);
            ListTag listtag1 = new ListTag();
            for (ItemStack itemstack1 : recruitEntity.f_21350_) {
                CompoundTag compoundtag1 = new CompoundTag();
                if (!itemstack1.m_41619_()) {
                    itemstack1.m_41739_(compoundtag1);
                }
                listtag1.add((Object)compoundtag1);
            }
            entityTag.m_128365_("HandItems", (Tag)listtag1);
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128365_("EntityTag", (Tag)entityTag);
            if (itemStack != null && player.m_21205_().m_41619_()) {
                itemStack.m_41751_(itemTag);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            }
        });
    }

    @Override
    public MessageWriteSpawnEgg fromBytes(FriendlyByteBuf buf) {
        this.recruit = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.recruit);
    }
}

