/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.talhanation.recruits.pathfinding.NodeEvaluatorGenerator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class NodeEvaluatorCache {
    private static final Map<NodeEvaluatorGenerator, ConcurrentLinkedQueue<NodeEvaluator>> threadLocalNodeEvaluators = new ConcurrentHashMap<NodeEvaluatorGenerator, ConcurrentLinkedQueue<NodeEvaluator>>();
    private static final Map<NodeEvaluator, NodeEvaluatorGenerator> nodeEvaluatorToGenerator = new ConcurrentHashMap<NodeEvaluator, NodeEvaluatorGenerator>();

    @NotNull
    private static Queue<NodeEvaluator> getDequeForGenerator(@NotNull NodeEvaluatorGenerator generator) {
        return threadLocalNodeEvaluators.computeIfAbsent(generator, key -> new ConcurrentLinkedQueue());
    }

    @NotNull
    public static NodeEvaluator takeNodeEvaluator(@NotNull NodeEvaluatorGenerator generator) {
        NodeEvaluator nodeEvaluator = NodeEvaluatorCache.getDequeForGenerator(generator).poll();
        if (nodeEvaluator == null) {
            nodeEvaluator = generator.generate();
        }
        nodeEvaluatorToGenerator.put(nodeEvaluator, generator);
        return nodeEvaluator;
    }

    public static void returnNodeEvaluator(@NotNull NodeEvaluator nodeEvaluator) {
        NodeEvaluatorGenerator generator = nodeEvaluatorToGenerator.remove(nodeEvaluator);
        Validate.notNull((Object)generator, (String)"NodeEvaluator already returned", (Object[])new Object[0]);
        NodeEvaluatorCache.getDequeForGenerator(generator).offer(nodeEvaluator);
    }
}

