/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import java.util.List;
import net.minecraft.world.level.pathfinder.Node;

public class PathAnalyzer {
    public static double pathStraightness(List<Node> path) {
        if (path == null || path.size() < 3) {
            return 100.0;
        }
        double totalAngleChange = 0.0;
        int segmentCount = 0;
        for (int i = 1; i < path.size() - 1; ++i) {
            Node prev = path.get(i - 1);
            Node current = path.get(i);
            Node next = path.get(i + 1);
            double angle = PathAnalyzer.calculateAngle(prev, current, next);
            totalAngleChange += Math.abs(angle);
            ++segmentCount;
        }
        if (segmentCount == 0) {
            return 100.0;
        }
        return totalAngleChange / (double)segmentCount;
    }

    private static double calculateAngle(Node a, Node b, Node c) {
        double dx1 = b.f_77271_ - a.f_77271_;
        double dz1 = b.f_77273_ - a.f_77273_;
        double dx2 = c.f_77271_ - b.f_77271_;
        double dz2 = c.f_77273_ - b.f_77273_;
        double dotProduct = dx1 * dx2 + dz1 * dz2;
        double mag1 = Math.sqrt(dx1 * dx1 + dz1 * dz1);
        double mag2 = Math.sqrt(dx2 * dx2 + dz2 * dz2);
        if (mag1 == 0.0 || mag2 == 0.0) {
            return 0.0;
        }
        double cosTheta = dotProduct / (mag1 * mag2);
        return Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, cosTheta))));
    }
}

