/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.IStrategicFire;
import com.talhanation.recruits.inventory.CommandMenu;
import com.talhanation.recruits.network.MessageAddRecruitToTeam;
import com.talhanation.recruits.network.MessageCommandScreen;
import com.talhanation.recruits.util.FormationUtils;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CommandEvents {
    public static void onMovementCommand(ServerPlayer player, List<AbstractRecruitEntity> recruits, int movementState, int formation) {
        if (formation != 0 && (movementState == 2 || movementState == 4 || movementState == 6 || movementState == 7 || movementState == 8)) {
            Vec3 targetPos = null;
            switch (movementState) {
                case 2: {
                    targetPos = FormationUtils.getGeometricMedian(recruits, (ServerLevel)player.m_20193_());
                    break;
                }
                case 4: {
                    targetPos = player.m_20182_();
                    break;
                }
                case 6: {
                    HitResult hitResult = player.m_19907_(200.0, 1.0f, true);
                    targetPos = hitResult.m_82450_();
                    break;
                }
                case 7: {
                    Vec3 center = FormationUtils.getGeometricMedian(recruits, (ServerLevel)player.m_20193_());
                    Vec3 forward = player.m_20156_();
                    Vec3 pos = center.m_82549_(forward.m_82490_(CommandEvents.getForwardScale(recruits)));
                    BlockPos blockPos = FormationUtils.getPositionOrSurface(player.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                    targetPos = new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_);
                    break;
                }
                case 8: {
                    Vec3 center = FormationUtils.getGeometricMedian(recruits, (ServerLevel)player.m_20193_());
                    Vec3 forward = player.m_20156_();
                    Vec3 pos = center.m_82549_(forward.m_82490_(-CommandEvents.getForwardScale(recruits)));
                    BlockPos blockPos = FormationUtils.getPositionOrSurface(player.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                    targetPos = new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_);
                }
            }
            CommandEvents.applyFormation(formation, recruits, player, targetPos);
        } else {
            for (AbstractRecruitEntity recruit : recruits) {
                int state = recruit.getFollowState();
                switch (movementState) {
                    case 0: {
                        if (state == 0) break;
                        recruit.setFollowState(0);
                        break;
                    }
                    case 1: {
                        if (state == 1) break;
                        recruit.setFollowState(1);
                        break;
                    }
                    case 2: {
                        if (state == 2) break;
                        recruit.setFollowState(2);
                        break;
                    }
                    case 3: {
                        if (state == 3) break;
                        recruit.setFollowState(3);
                        break;
                    }
                    case 4: {
                        if (state == 4) break;
                        recruit.setFollowState(4);
                        break;
                    }
                    case 5: {
                        if (state == 5) break;
                        recruit.setFollowState(5);
                        break;
                    }
                    case 6: {
                        HitResult hitResult = player.m_19907_(100.0, 1.0f, true);
                        if (hitResult.m_6662_() != HitResult.Type.BLOCK) break;
                        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                        BlockPos blockpos = blockHitResult.m_82425_();
                        recruit.setMovePos(blockpos);
                        recruit.setFollowState(0);
                        recruit.setShouldMovePos(true);
                        break;
                    }
                    case 7: {
                        Vec3 forward = player.m_20156_();
                        Vec3 pos = recruit.m_20182_().m_82549_(forward.m_82490_(CommandEvents.getForwardScale(recruit)));
                        BlockPos blockPos = FormationUtils.getPositionOrSurface(player.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                        Vec3 targetPos = new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_);
                        recruit.setHoldPos(targetPos);
                        recruit.ownerRot = player.m_146908_();
                        recruit.setFollowState(3);
                        break;
                    }
                    case 8: {
                        Vec3 forward = player.m_20156_();
                        Vec3 pos = recruit.m_20182_().m_82549_(forward.m_82490_(-CommandEvents.getForwardScale(recruit)));
                        BlockPos blockPos = FormationUtils.getPositionOrSurface(player.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                        Vec3 targetPos = new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_);
                        recruit.setHoldPos(targetPos);
                        recruit.ownerRot = player.m_146908_();
                        recruit.setFollowState(3);
                    }
                }
                recruit.isInFormation = false;
            }
        }
        for (AbstractRecruitEntity recruit : recruits) {
            recruit.setUpkeepTimer(recruit.getUpkeepCooldown());
            if (recruit.getShouldMount()) {
                recruit.setShouldMount(false);
            }
            CommandEvents.checkPatrolLeaderState(recruit);
            recruit.forcedUpkeep = false;
        }
    }

    private static double getForwardScale(List<AbstractRecruitEntity> recruits) {
        for (AbstractRecruitEntity recruit : recruits) {
            if (!(recruit instanceof CaptainEntity)) continue;
            return CommandEvents.getForwardScale(recruit);
        }
        return 10.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double getForwardScale(AbstractRecruitEntity recruit) {
        if (!(recruit instanceof CaptainEntity)) return 10.0;
        CaptainEntity captain = (CaptainEntity)recruit;
        if (captain.smallShipsController.ship == null) return 10.0;
        if (!captain.smallShipsController.ship.isCaptainDriver()) return 10.0;
        return 25.0;
    }

    public static void applyFormation(int formation, List<AbstractRecruitEntity> recruits, ServerPlayer player, Vec3 targetPos) {
        switch (formation) {
            case 1: {
                FormationUtils.lineUpFormation(player, recruits, targetPos);
                break;
            }
            case 2: {
                FormationUtils.squareFormation(player, recruits, targetPos);
                break;
            }
            case 3: {
                FormationUtils.triangleFormation(player, recruits, targetPos);
                break;
            }
            case 4: {
                FormationUtils.hollowCircleFormation(player, recruits, targetPos);
                break;
            }
            case 5: {
                FormationUtils.hollowSquareFormation(player, recruits, targetPos);
                break;
            }
            case 6: {
                FormationUtils.vFormation(player, recruits, targetPos);
                break;
            }
            case 7: {
                FormationUtils.circleFormation(player, recruits, targetPos);
                break;
            }
            case 8: {
                FormationUtils.movementFormation(player, recruits, targetPos);
            }
        }
    }

    public static void onMovementCommandGUI(AbstractRecruitEntity recruit, int movementState) {
        int state = recruit.getFollowState();
        switch (movementState) {
            case 0: {
                if (state == 0) break;
                recruit.setFollowState(0);
                break;
            }
            case 1: {
                if (state == 1) break;
                recruit.setFollowState(1);
                break;
            }
            case 2: {
                if (state == 2) break;
                recruit.setFollowState(2);
                break;
            }
            case 3: {
                if (state == 3) break;
                recruit.setFollowState(3);
                break;
            }
            case 4: {
                if (state == 4) break;
                recruit.setFollowState(4);
                break;
            }
            case 5: {
                if (state == 5) break;
                recruit.setFollowState(5);
            }
        }
        recruit.setUpkeepTimer(recruit.getUpkeepCooldown());
        if (recruit.getShouldMount()) {
            recruit.setShouldMount(false);
        }
        CommandEvents.checkPatrolLeaderState(recruit);
        recruit.forcedUpkeep = false;
    }

    public static void checkPatrolLeaderState(AbstractRecruitEntity recruit) {
        if (recruit instanceof AbstractLeaderEntity) {
            AbstractLeaderEntity leader = (AbstractLeaderEntity)recruit;
            AbstractLeaderEntity.State patrolState = AbstractLeaderEntity.State.fromIndex(leader.getPatrollingState());
            if (patrolState == AbstractLeaderEntity.State.PATROLLING || patrolState == AbstractLeaderEntity.State.WAITING) {
                leader.setPatrolState(AbstractLeaderEntity.State.PAUSED);
            } else if (patrolState == AbstractLeaderEntity.State.RETREATING || patrolState == AbstractLeaderEntity.State.UPKEEP) {
                leader.resetPatrolling();
                leader.setPatrolState(AbstractLeaderEntity.State.IDLE);
            }
        }
    }

    public static void onAggroCommand(UUID player_uuid, AbstractRecruitEntity recruit, int x_state, UUID group, boolean fromGui) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            int state = recruit.getState();
            switch (x_state) {
                case 0: {
                    if (state == 0) break;
                    recruit.setAggroState(0);
                    break;
                }
                case 1: {
                    if (state == 1) break;
                    recruit.setAggroState(1);
                    break;
                }
                case 2: {
                    if (state == 2) break;
                    recruit.setAggroState(2);
                    break;
                }
                case 3: {
                    if (state == 3) break;
                    recruit.setAggroState(3);
                }
            }
        }
    }

    public static void onAttackCommand(Player player, UUID player_uuid, List<AbstractRecruitEntity> list, UUID group) {
        HitResult hitResult = player.m_19907_(100.0, 1.0f, false);
        BlockPos blockpos = null;
        AABB aabb = null;
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            blockpos = entityHitResult.m_82443_().m_20097_();
            Entity entity = entityHitResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                targets.add(living);
            }
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            blockpos = blockHitResult.m_82425_();
        } else {
            return;
        }
        aabb = new AABB(blockpos).m_82400_(10.0);
        list.removeIf(recruit -> !recruit.isEffectedByCommand(player_uuid, group));
        List validTargets = player.m_20193_().m_45976_(LivingEntity.class, aabb);
        if (list.isEmpty() || validTargets.isEmpty()) {
            return;
        }
        AbstractRecruitEntity firstRecruit = list.get(0);
        validTargets.removeIf(target -> !firstRecruit.m_6779_((LivingEntity)target));
        if (validTargets.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            AbstractRecruitEntity recruit2 = list.get(i);
            LivingEntity target2 = (LivingEntity)validTargets.get(i % validTargets.size());
            recruit2.m_6710_(target2);
            recruit2.setHoldPos(target2.m_20182_());
            recruit2.setFollowState(3);
        }
    }

    public static void onStrategicFireCommand(Player player, UUID player_uuid, AbstractRecruitEntity recruit, UUID group, boolean should) {
        if (recruit.isEffectedByCommand(player_uuid, group) && recruit instanceof IStrategicFire) {
            IStrategicFire bowman = (IStrategicFire)((Object)recruit);
            HitResult hitResult = player.m_19907_(100.0, 1.0f, false);
            bowman.setShouldStrategicFire(should);
            if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockPos blockpos = blockHitResult.m_82425_();
                bowman.setStrategicFirePos(blockpos);
            }
        }
    }

    public static void openCommandScreen(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return Component.m_237113_((String)"command_screen");
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new CommandMenu(i, playerEntity);
                }
            }, packetBuffer -> packetBuffer.m_130077_(player.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCommandScreen(player));
        }
    }

    @SubscribeEvent
    public void onServerPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            int formation;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_19797_ % 20 == 0 && (formation = CommandEvents.getSavedFormation((Player)serverPlayer)) > 0) {
                int[] savedPos = CommandEvents.getSavedFormationPos((Player)serverPlayer);
                if (savedPos.length == 0) {
                    savedPos = new int[]{(int)serverPlayer.m_20185_(), (int)serverPlayer.m_20189_()};
                    CommandEvents.saveFormationPos((Player)serverPlayer, savedPos);
                }
                int savedX = savedPos[0];
                int savedZ = savedPos[1];
                Vec3 oldPos = new Vec3((double)savedX, serverPlayer.m_20186_(), (double)savedZ);
                Vec3 targetPosition = serverPlayer.m_20182_();
                if (targetPosition.m_82557_(oldPos) > 50.0) {
                    List recruits = Objects.requireNonNull(serverPlayer).m_20193_().m_45976_(AbstractRecruitEntity.class, serverPlayer.m_20191_().m_82400_(200.0));
                    List<RecruitsGroup> groups = RecruitEvents.recruitsGroupsManager.getPlayerGroups((Player)serverPlayer);
                    if (groups == null) {
                        return;
                    }
                    List<UUID> uuid = CommandEvents.getSavedUUIDList((Player)serverPlayer, "ActiveGroups");
                    recruits.removeIf(recruit -> !uuid.contains(recruit.getGroup()));
                    groups.removeIf(group -> !uuid.contains(group.getUUID()));
                    CommandEvents.applyFormation(formation, recruits, serverPlayer, targetPosition);
                    int[] position = new int[]{(int)targetPosition.f_82479_, (int)targetPosition.f_82481_};
                    CommandEvents.saveFormationPos((Player)serverPlayer, position);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag playerData = event.getEntity().getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (!data.m_128441_("MaxRecruits")) {
            data.m_128405_("MaxRecruits", ((Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get()).intValue());
        }
        if (!data.m_128441_("CommandingGroup")) {
            data.m_128405_("CommandingGroup", 0);
        }
        if (!data.m_128441_("TotalRecruits")) {
            data.m_128405_("TotalRecruits", 0);
        }
        if (!data.m_128441_("ActiveGroups")) {
            data.m_128365_("ActiveGroups", (Tag)new ListTag());
        }
        if (!data.m_128441_("Formation")) {
            data.m_128405_("Formation", 0);
        }
        if (!data.m_128441_("FormationPos")) {
            data.m_128385_("FormationPos", new int[]{(int)event.getEntity().m_20185_(), (int)event.getEntity().m_20189_()});
        }
        playerData.m_128365_("PlayerPersisted", (Tag)data);
    }

    public static int getSavedFormation(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        return nbt.m_128451_("Formation");
    }

    public static void saveFormation(Player player, int formation) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128405_("Formation", formation);
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    public static void saveUUIDList(Player player, String key, Collection<UUID> uuids) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag persisted = playerNBT.m_128469_("PlayerPersisted");
        ListTag list = new ListTag();
        for (UUID uuid : uuids) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("UUID", uuid);
            list.add((Object)tag);
        }
        persisted.m_128365_(key, (Tag)list);
        playerNBT.m_128365_("PlayerPersisted", (Tag)persisted);
    }

    public static List<UUID> getSavedUUIDList(Player player, String key) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag persisted = playerNBT.m_128469_("PlayerPersisted");
        ArrayList<UUID> result = new ArrayList<UUID>();
        if (!persisted.m_128425_(key, 9)) {
            return result;
        }
        ListTag list = persisted.m_128437_(key, 10);
        for (Tag t : list) {
            CompoundTag tag = (CompoundTag)t;
            if (!tag.m_128403_("UUID")) continue;
            result.add(tag.m_128342_("UUID"));
        }
        return result;
    }

    public static int[] getSavedFormationPos(Player player) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        return nbt.m_128465_("FormationPos");
    }

    public static void saveFormationPos(Player player, int[] pos) {
        CompoundTag playerNBT = player.getPersistentData();
        CompoundTag nbt = playerNBT.m_128469_("PlayerPersisted");
        nbt.m_128385_("FormationPos", pos);
        playerNBT.m_128365_("PlayerPersisted", (Tag)nbt);
    }

    public static void handleRecruiting(Player player, RecruitsGroup group, AbstractRecruitEntity recruit) {
        boolean playerCanPay;
        String name = recruit.m_7755_().getString() + ": ";
        int sollPrice = recruit.getCost();
        Inventory playerInv = player.m_150109_();
        int playerEmeralds = 0;
        String str = (String)RecruitsServerConfig.RecruitCurrency.get();
        Optional holder = ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)str));
        ItemStack currencyItemStack = holder.map(itemHolder -> ((Item)itemHolder.m_203334_()).m_7968_()).orElseGet(() -> ((Item)Items.f_42616_).m_7968_());
        Item currency = currencyItemStack.m_41720_();
        for (int i = 0; i < playerInv.m_6643_(); ++i) {
            ItemStack itemStackInSlot = playerInv.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (!itemInSlot.equals(currency)) continue;
            playerEmeralds += itemStackInSlot.m_41613_();
        }
        boolean bl = playerCanPay = playerEmeralds >= sollPrice;
        if (playerCanPay || player.m_7500_()) {
            if (recruit.hire(player, group)) {
                playerEmeralds -= sollPrice;
                for (int i = 0; i < playerInv.m_6643_(); ++i) {
                    ItemStack itemStackInSlot = playerInv.m_8020_(i);
                    Item itemInSlot = itemStackInSlot.m_41720_();
                    if (!itemInSlot.equals(currency)) continue;
                    playerInv.m_8016_(i);
                }
                ItemStack emeraldsLeft = currencyItemStack.m_41777_();
                emeraldsLeft.m_41764_(playerEmeralds);
                playerInv.m_36054_(emeraldsLeft);
                if (player.m_5647_() != null) {
                    if (player.m_20193_().f_46443_) {
                        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAddRecruitToTeam(player.m_5647_().m_5758_(), 1));
                    } else {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        FactionEvents.addNPCToData(serverPlayer.m_284548_(), player.m_5647_().m_5758_(), 1);
                    }
                }
            }
        } else {
            player.m_213846_((Component)CommandEvents.TEXT_HIRE_COSTS(name, sollPrice, currency));
        }
    }

    public static void onMountButton(UUID player_uuid, AbstractRecruitEntity recruit, UUID mount_uuid, UUID group) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            if (mount_uuid != null) {
                recruit.shouldMount(true, mount_uuid);
            } else if (recruit.getMountUUID() != null) {
                recruit.shouldMount(true, recruit.getMountUUID());
            }
            recruit.dismount = 0;
        }
    }

    public static void onDismountButton(UUID player_uuid, AbstractRecruitEntity recruit, UUID group) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.shouldMount(false, null);
            if (recruit.m_20159_()) {
                recruit.m_8127_();
                recruit.dismount = 180;
            }
        }
    }

    public static void onProtectButton(UUID player_uuid, AbstractRecruitEntity recruit, UUID protect_uuid, UUID group) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.shouldProtect(true, protect_uuid);
        }
    }

    public static void onClearTargetButton(UUID player_uuid, AbstractRecruitEntity recruit, UUID group) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.m_6710_(null);
            recruit.m_6598_(null);
            recruit.m_21335_(null);
            recruit.m_6703_(null);
        }
    }

    public static void onClearUpkeepButton(UUID player_uuid, AbstractRecruitEntity recruit, UUID group) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.clearUpkeepEntity();
            recruit.clearUpkeepPos();
        }
    }

    public static void onUpkeepCommand(UUID player_uuid, AbstractRecruitEntity recruit, UUID group, boolean isEntity, UUID entity_uuid, BlockPos blockPos) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            if (isEntity) {
                recruit.setUpkeepUUID(Optional.of(entity_uuid));
                recruit.clearUpkeepPos();
            } else {
                recruit.setUpkeepPos(blockPos);
                recruit.clearUpkeepEntity();
            }
            recruit.forcedUpkeep = true;
            recruit.setUpkeepTimer(0);
            CommandEvents.onClearTargetButton(player_uuid, recruit, group);
        }
    }

    public static void onShieldsCommand(ServerPlayer serverPlayer, UUID player_uuid, AbstractRecruitEntity recruit, UUID group, boolean shields) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.setShouldBlock(shields);
        }
    }

    public static void onRangedFireCommand(ServerPlayer serverPlayer, UUID player_uuid, AbstractRecruitEntity recruit, UUID group, boolean should) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            recruit.setShouldRanged(should);
            if (should) {
                if (recruit instanceof CrossBowmanEntity) {
                    recruit.switchMainHandItem(itemStack -> itemStack.m_41720_() instanceof CrossbowItem);
                }
                if (recruit instanceof BowmanEntity) {
                    recruit.switchMainHandItem(itemStack -> itemStack.m_41720_() instanceof BowItem);
                }
            } else {
                recruit.switchMainHandItem(itemStack -> itemStack.m_41720_() instanceof SwordItem);
            }
        }
    }

    public static void onRestCommand(ServerPlayer serverPlayer, UUID player_uuid, AbstractRecruitEntity recruit, UUID group, boolean should) {
        if (recruit.isEffectedByCommand(player_uuid, group)) {
            CommandEvents.onClearTargetButton(player_uuid, recruit, group);
            recruit.setShouldRest(should);
        }
    }

    private static MutableComponent TEXT_HIRE_COSTS(String name, int sollPrice, Item item) {
        return Component.m_237110_((String)"chat.recruits.text.hire_costs", (Object[])new Object[]{name, String.valueOf(sollPrice), item.m_41466_().getString()});
    }
}

