/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.events;

import com.talhanation.recruits.client.gui.commandscreen.ICommandCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CommandCategoryManager {
    private static final LinkedHashMap<ICommandCategory, Integer> categories = new LinkedHashMap();

    private CommandCategoryManager() {
    }

    public static void register(ICommandCategory category) {
        CommandCategoryManager.register(category, 0);
    }

    public static void register(ICommandCategory category, int priority) {
        categories.put(category, priority);
    }

    public static List<ICommandCategory> getCategories() {
        ArrayList<Map.Entry<ICommandCategory, Integer>> entries = new ArrayList<Map.Entry<ICommandCategory, Integer>>(categories.entrySet());
        entries.sort(Comparator.comparingInt(Map.Entry::getValue));
        ArrayList<ICommandCategory> result = new ArrayList<ICommandCategory>(entries.size());
        for (Map.Entry entry : entries) {
            result.add((ICommandCategory)entry.getKey());
        }
        return Collections.unmodifiableList(result);
    }

    public static ICommandCategory getByIndex(int index) {
        List<ICommandCategory> cats = CommandCategoryManager.getCategories();
        if (index >= 0 && index < cats.size()) {
            return cats.get(index);
        }
        return cats.isEmpty() ? null : cats.get(0);
    }

    public static ICommandCategory getNext(ICommandCategory current) {
        List<ICommandCategory> cats = CommandCategoryManager.getCategories();
        int i = cats.indexOf(current);
        if (i != -1 && i < cats.size() - 1) {
            return cats.get(i + 1);
        }
        return current;
    }

    public static ICommandCategory getPrevious(ICommandCategory current) {
        List<ICommandCategory> cats = CommandCategoryManager.getCategories();
        int i = cats.indexOf(current);
        if (i > 0) {
            return cats.get(i - 1);
        }
        return current;
    }
}

