/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.commandscreen;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.CommandScreen;
import com.talhanation.recruits.client.gui.commandscreen.ICommandCategory;
import com.talhanation.recruits.client.gui.group.RecruitsCommandButton;
import com.talhanation.recruits.client.gui.group.RecruitsFormationButton;
import com.talhanation.recruits.network.MessageSaveFormationFollowMovement;
import com.talhanation.recruits.world.RecruitsGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MovementCategory
implements ICommandCategory {
    private static final MutableComponent TEXT_MOVE = Component.m_237115_((String)"gui.recruits.command.text.move");
    private static final MutableComponent TEXT_MOVE_HOLD = Component.m_237115_((String)"gui.recruits.command.text.move_hold");
    private static final MutableComponent TEXT_FORWARD = Component.m_237115_((String)"gui.recruits.command.text.forward");
    private static final MutableComponent TEXT_BACKWARD = Component.m_237115_((String)"gui.recruits.command.text.backward");
    private static final MutableComponent TEXT_FOLLOW = Component.m_237115_((String)"gui.recruits.command.text.follow");
    private static final MutableComponent TEXT_WANDER = Component.m_237115_((String)"gui.recruits.command.text.wander");
    private static final MutableComponent TEXT_HOLD_POS = Component.m_237115_((String)"gui.recruits.command.text.holdPos");
    private static final MutableComponent TEXT_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.command.text.backToPos");
    private static final MutableComponent TEXT_FORMATION_LINEUP = Component.m_237115_((String)"gui.recruits.command.text.formation_lineup");
    private static final MutableComponent TEXT_FORMATION_SQUARE = Component.m_237115_((String)"gui.recruits.command.text.formation_square");
    private static final MutableComponent TEXT_FORMATION_TRIANGLE = Component.m_237115_((String)"gui.recruits.command.text.formation_triangle");
    private static final MutableComponent TEXT_FORMATION_HOLLOW_SQUARE = Component.m_237115_((String)"gui.recruits.command.text.formation_hollow_square");
    private static final MutableComponent TEXT_FORMATION_HOLLOW_CIRCLE = Component.m_237115_((String)"gui.recruits.command.text.formation_hollow_circle");
    private static final MutableComponent TEXT_FORMATION_V = Component.m_237115_((String)"gui.recruits.command.text.formation_v");
    private static final MutableComponent TEXT_FORMATION_CIRCLE = Component.m_237115_((String)"gui.recruits.command.text.formation_circle");
    private static final MutableComponent TEXT_FORMATION_MOVEMENT = Component.m_237115_((String)"gui.recruits.command.text.formation_movement");
    private static final MutableComponent TEXT_FORMATION_NONE = Component.m_237115_((String)"gui.recruits.command.text.formation_none");
    private static final MutableComponent TEXT_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.command.text.holdMyPos");
    private static final MutableComponent TOOLTIP_MOVE = Component.m_237115_((String)"gui.recruits.command.tooltip.move_hold");
    private static final MutableComponent TOOLTIP_FORWARD = Component.m_237115_((String)"gui.recruits.command.tooltip.forward");
    private static final MutableComponent TOOLTIP_FORMATION = Component.m_237115_((String)"gui.recruits.command.tooltip.formation");
    private static final MutableComponent TOOLTIP_BACKWARD = Component.m_237115_((String)"gui.recruits.command.tooltip.backward");
    private static final MutableComponent TOOLTIP_FOLLOW = Component.m_237115_((String)"gui.recruits.command.tooltip.follow");
    private static final MutableComponent TOOLTIP_WANDER = Component.m_237115_((String)"gui.recruits.command.tooltip.wander");
    private static final MutableComponent TOOLTIP_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.holdMyPos");
    private static final MutableComponent TOOLTIP_HOLD_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.holdPos");
    private static final MutableComponent TOOLTIP_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.command.tooltip.backToPos");
    private static final MutableComponent TOOLTIP_MOVEMENT = Component.m_237115_((String)"gui.recruits.command.tooltip.movement");

    @Override
    public Component getToolTipName() {
        return TOOLTIP_MOVEMENT;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.f_42463_);
    }

    @Override
    public void createButtons(CommandScreen screen, int x, int y, List<RecruitsGroup> groups, Player player) {
        boolean isOneGroupActive = groups.stream().anyMatch(g -> !g.isDisabled());
        RecruitsCommandButton moveButton = new RecruitsCommandButton(x, y - 50, (Component)TEXT_MOVE, button -> {
            screen.sendMovementCommandToServer(6);
            screen.sendCommandInChat(6);
        });
        moveButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOVE));
        moveButton.f_93623_ = isOneGroupActive && screen.rayBlockPos != null;
        screen.m_142416_(moveButton);
        RecruitsCommandButton forwardButton = new RecruitsCommandButton(x - 60, y - 25, (Component)TEXT_FORWARD, button -> {
            screen.sendMovementCommandToServer(7);
            screen.sendCommandInChat(7);
        });
        forwardButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FORWARD));
        forwardButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(forwardButton);
        RecruitsCommandButton followButton = new RecruitsCommandButton(x + 60, y - 25, (Component)TEXT_FOLLOW, button -> {
            if (CommandScreen.formation.getIndex() != 0) {
                ArrayList<UUID> activeGroups = new ArrayList<UUID>();
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    activeGroups.add(group.getUUID());
                }
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveFormationFollowMovement(player.m_20148_(), activeGroups, CommandScreen.formation.getIndex()));
            } else {
                screen.sendMovementCommandToServer(1);
            }
            screen.sendCommandInChat(1);
        });
        followButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FOLLOW));
        followButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(followButton);
        RecruitsCommandButton wanderButton = new RecruitsCommandButton(x + 120, y, (Component)TEXT_WANDER, button -> {
            screen.sendMovementCommandToServer(0);
            screen.sendCommandInChat(0);
        });
        wanderButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_WANDER));
        wanderButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(wanderButton);
        RecruitsCommandButton backToPosButton = new RecruitsCommandButton(x - 120, y, (Component)TEXT_BACK_TO_POS, button -> {
            screen.sendMovementCommandToServer(3);
            screen.sendCommandInChat(3);
        });
        backToPosButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_POS));
        backToPosButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(backToPosButton);
        RecruitsCommandButton holdPosButton = new RecruitsCommandButton(x + 60, y + 25, (Component)TEXT_HOLD_POS, button -> {
            screen.sendMovementCommandToServer(2);
            screen.sendCommandInChat(2);
        });
        holdPosButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_POS));
        holdPosButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(holdPosButton);
        RecruitsCommandButton backwardButton = new RecruitsCommandButton(x - 60, y + 25, (Component)TEXT_BACKWARD, button -> {
            screen.sendMovementCommandToServer(8);
            screen.sendCommandInChat(8);
        });
        backwardButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACKWARD));
        backwardButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(backwardButton);
        RecruitsFormationButton noneFormationButton = new RecruitsFormationButton(CommandScreen.Formation.NONE, x, y + 50, button -> screen.setFormation(CommandScreen.Formation.NONE));
        noneFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_NONE));
        screen.m_142416_(noneFormationButton);
        RecruitsFormationButton lineUpFormationButton = new RecruitsFormationButton(CommandScreen.Formation.LINE, x - 21, y + 50, button -> screen.setFormation(CommandScreen.Formation.LINE));
        lineUpFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_LINEUP));
        screen.m_142416_(lineUpFormationButton);
        RecruitsFormationButton squareFormationButton = new RecruitsFormationButton(CommandScreen.Formation.SQUARE, x + 21, y + 50, button -> screen.setFormation(CommandScreen.Formation.SQUARE));
        squareFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_SQUARE));
        screen.m_142416_(squareFormationButton);
        RecruitsFormationButton triangleFormationButton = new RecruitsFormationButton(CommandScreen.Formation.TRIANGLE, x - 42, y + 50, button -> screen.setFormation(CommandScreen.Formation.TRIANGLE));
        triangleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_TRIANGLE));
        screen.m_142416_(triangleFormationButton);
        RecruitsFormationButton VFormFormationButton = new RecruitsFormationButton(CommandScreen.Formation.VFORM, x + 42, y + 50, button -> screen.setFormation(CommandScreen.Formation.VFORM));
        VFormFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_V));
        screen.m_142416_(VFormFormationButton);
        RecruitsFormationButton hcircleFormationButton = new RecruitsFormationButton(CommandScreen.Formation.HCIRCLE, x - 63, y + 50, button -> screen.setFormation(CommandScreen.Formation.HCIRCLE));
        hcircleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_HOLLOW_CIRCLE));
        screen.m_142416_(hcircleFormationButton);
        RecruitsFormationButton hSquareFormationButton = new RecruitsFormationButton(CommandScreen.Formation.HSQUARE, x + 63, y + 50, button -> screen.setFormation(CommandScreen.Formation.HSQUARE));
        hSquareFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_HOLLOW_SQUARE));
        screen.m_142416_(hSquareFormationButton);
        RecruitsFormationButton circleFormationButton = new RecruitsFormationButton(CommandScreen.Formation.CIRCLE, x - 84, y + 50, button -> screen.setFormation(CommandScreen.Formation.CIRCLE));
        circleFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_CIRCLE));
        screen.m_142416_(circleFormationButton);
        RecruitsFormationButton movementFormationButton = new RecruitsFormationButton(CommandScreen.Formation.MOVEMENT, x + 84, y + 50, button -> screen.setFormation(CommandScreen.Formation.MOVEMENT));
        movementFormationButton.m_257544_(Tooltip.m_257550_((Component)TEXT_FORMATION_MOVEMENT));
        screen.m_142416_(movementFormationButton);
        noneFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.NONE;
        lineUpFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.LINE;
        squareFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.SQUARE;
        hSquareFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.HSQUARE;
        triangleFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.TRIANGLE;
        VFormFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.VFORM;
        hcircleFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.HCIRCLE;
        circleFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.CIRCLE;
        movementFormationButton.f_93623_ = CommandScreen.formation == CommandScreen.Formation.MOVEMENT;
    }
}

