/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.overlay;

import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.overlay.ClaimOverlayRenderer;
import com.talhanation.recruits.config.RecruitsClientConfig;
import com.talhanation.recruits.world.RecruitsClaim;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClaimOverlayManager {
    private OverlayState currentState = OverlayState.HIDDEN;
    private long stateChangeTime = 0L;
    private long claimEntryTime = 0L;
    private int tickCounter = 0;
    private ChunkPos lastPlayerChunk = null;
    private String lastKnownClaimName = "";
    private String lastKnownFactionName = "";
    private int lastKnownHealth = -1;
    private boolean lastKnownSiegeState = false;
    private static final long FADE_DURATION = 500L;
    private static final long FULL_DISPLAY_DURATION = 5000L;
    private static final int DATA_UPDATE_INTERVAL = 20;
    private static final int CHUNK_CHECK_INTERVAL = 10;
    private static final int PANEL_WIDTH = 150;
    private final ClaimOverlayRenderer renderer = new ClaimOverlayRenderer();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean needsUpdate;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 10 == 0) {
            this.updateCurrentClaim(mc.f_91074_.m_20183_());
        }
        boolean bl = needsUpdate = this.tickCounter % 20 == 0;
        if (needsUpdate && ClientManager.currentClaim != null) {
            this.checkForDataChanges();
        }
        this.updateOverlayState();
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91065_.m_93088_().f_94524_) {
            return;
        }
        if (!mc.f_91065_.m_93090_().f_93699_.isEmpty()) {
            return;
        }
        if (((Boolean)RecruitsClientConfig.DisableClaimGUIOverlay.get()).booleanValue()) {
            return;
        }
        float alpha = this.calculateAlpha();
        if (alpha <= 0.01f) {
            return;
        }
        if (ClientManager.currentClaim != null) {
            this.renderer.render(event.getGuiGraphics(), mc, ClientManager.currentClaim, this.currentState, alpha, this.getPanelWidth());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(ClientPlayerNetworkEvent.LoggingOut event) {
        this.reset();
    }

    @SubscribeEvent
    public void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        this.reset();
    }

    private void updateCurrentClaim(BlockPos playerPos) {
        ChunkPos currentChunk = new ChunkPos(playerPos);
        if (currentChunk.equals((Object)this.lastPlayerChunk)) {
            ClientManager.currentClaim = null;
            for (RecruitsClaim claim : ClientManager.recruitsClaims) {
                if (!claim.containsChunk(currentChunk)) continue;
                ClientManager.currentClaim = claim;
                break;
            }
            return;
        }
        this.lastPlayerChunk = currentChunk;
        RecruitsClaim previousClaim = ClientManager.currentClaim;
        ClientManager.currentClaim = null;
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (!claim.containsChunk(currentChunk)) continue;
            ClientManager.currentClaim = claim;
            break;
        }
        this.handleClaimTransition(previousClaim, ClientManager.currentClaim);
    }

    private void handleClaimTransition(RecruitsClaim previousClaim, RecruitsClaim newClaim) {
        if (previousClaim == null && newClaim != null) {
            this.claimEntryTime = System.currentTimeMillis();
            this.transitionToState(OverlayState.FULL, true);
            this.updateCachedData(newClaim);
        } else if (previousClaim != null && newClaim == null) {
            this.transitionToState(OverlayState.HIDDEN, true);
        } else if (previousClaim != null && newClaim != null && !previousClaim.equals(newClaim)) {
            this.claimEntryTime = System.currentTimeMillis();
            this.transitionToState(OverlayState.FULL, true);
            this.updateCachedData(newClaim);
        }
    }

    private void checkForDataChanges() {
        if (ClientManager.currentClaim == null) {
            return;
        }
        RecruitsClaim claim = ClientManager.currentClaim;
        boolean hasChanges = false;
        if (!claim.getName().equals(this.lastKnownClaimName)) {
            this.lastKnownClaimName = claim.getName();
            hasChanges = true;
        }
        if (!claim.getOwnerFactionStringID().equals(this.lastKnownFactionName)) {
            this.lastKnownFactionName = claim.getOwnerFactionStringID();
            hasChanges = true;
        }
        if (claim.getHealth() != this.lastKnownHealth) {
            this.lastKnownHealth = claim.getHealth();
            hasChanges = true;
        }
        if (claim.isUnderSiege != this.lastKnownSiegeState) {
            this.lastKnownSiegeState = claim.isUnderSiege;
            hasChanges = true;
            if (claim.isUnderSiege) {
                this.claimEntryTime = System.currentTimeMillis();
                this.transitionToState(OverlayState.FULL, false);
            }
        }
        if (hasChanges) {
            this.renderer.markDataChanged();
        }
    }

    private void updateCachedData(RecruitsClaim claim) {
        if (claim == null) {
            this.lastKnownClaimName = "";
            this.lastKnownFactionName = "";
            this.lastKnownHealth = -1;
            this.lastKnownSiegeState = false;
            return;
        }
        this.lastKnownClaimName = claim.getName();
        this.lastKnownFactionName = claim.getOwnerFactionStringID();
        this.lastKnownHealth = claim.getHealth();
        this.lastKnownSiegeState = claim.isUnderSiege;
    }

    private void updateOverlayState() {
        OverlayState desiredState;
        if (ClientManager.currentClaim == null || ClientManager.currentClaim.isUnderSiege) {
            return;
        }
        long timeInClaim = System.currentTimeMillis() - this.claimEntryTime;
        OverlayState overlayState = desiredState = timeInClaim < 5000L ? OverlayState.FULL : OverlayState.COMPACT;
        if (this.currentState != desiredState) {
            this.transitionToState(desiredState, true);
        }
    }

    private void transitionToState(OverlayState newState, boolean fade) {
        if (this.currentState == newState) {
            return;
        }
        this.stateChangeTime = fade ? System.currentTimeMillis() : System.currentTimeMillis() - 500L;
        this.currentState = newState;
    }

    private float calculateAlpha() {
        if (this.currentState == OverlayState.HIDDEN) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.stateChangeTime;
        if (elapsed >= 500L) {
            return 1.0f;
        }
        float progress = (float)elapsed / 500.0f;
        if (this.currentState == OverlayState.HIDDEN) {
            return 1.0f - progress;
        }
        return progress;
    }

    public int getPanelWidth() {
        return 150;
    }

    public OverlayState getCurrentState() {
        return this.currentState;
    }

    private void reset() {
        ClientManager.recruitsClaims.clear();
        ClientManager.currentClaim = null;
        this.currentState = OverlayState.HIDDEN;
        this.lastPlayerChunk = null;
        this.tickCounter = 0;
        this.updateCachedData(null);
        this.renderer.clearCache();
    }

    public static enum OverlayState {
        HIDDEN,
        FULL,
        COMPACT;

    }
}

