/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;

public class ChunkImage {
    private final NativeImage image;
    private final DynamicTexture texture;
    private final ResourceLocation textureId;

    public ChunkImage(ClientLevel level, ChunkPos pos) {
        this.image = this.generateVanillaStyleImage(level, pos);
        this.texture = new DynamicTexture(this.image);
        this.textureId = Minecraft.m_91087_().m_91097_().m_118490_("chunk_" + pos.f_45578_ + "_" + pos.f_45579_, this.texture);
    }

    private NativeImage generateVanillaStyleImage(ClientLevel level, ChunkPos pos) {
        NativeImage img = new NativeImage(NativeImage.Format.RGBA, 16, 16, true);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.m_45604_() + x;
                int worldZ = pos.m_45605_() + z;
                int worldY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, worldX, worldZ) - 1;
                img.m_84988_(x, z, this.getVanillaReliefColor(level, new BlockPos(worldX, worldY, worldZ)));
            }
        }
        img.m_85123_();
        return img;
    }

    private int getVanillaReliefColor(ClientLevel level, BlockPos pos) {
        int heightWest;
        int heightSouth;
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return -16777216;
        }
        boolean isWaterLike = state.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
        if (isWaterLike) {
            int depth;
            BlockState topState = this.getTopWaterBlock(level, pos);
            MapColor mapColor = topState.m_284242_((BlockGetter)level, pos);
            if (mapColor == null) {
                mapColor = MapColor.f_283864_;
            }
            MapColor.Brightness brightness = (depth = this.getWaterDepth(level, pos)) > 6 ? MapColor.Brightness.LOWEST : (depth > 3 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL);
            return 0xFF000000 | mapColor.m_284280_(brightness);
        }
        MapColor mapColor = state.m_284242_((BlockGetter)level, pos);
        if (mapColor == null) {
            return -16777216;
        }
        int heightHere = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        int relHeight = heightHere - Math.max(heightSouth = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_() + 1), heightWest = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_() - 1, pos.m_123343_()));
        MapColor.Brightness brightness = relHeight > 2 ? MapColor.Brightness.HIGH : (relHeight > 0 ? MapColor.Brightness.NORMAL : (relHeight > -2 ? MapColor.Brightness.LOW : MapColor.Brightness.LOWEST));
        return 0xFF000000 | mapColor.m_284280_(brightness);
    }

    private BlockState getTopWaterBlock(ClientLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (this.isWaterLike(level.m_8055_((BlockPos)mutable)) && mutable.m_123342_() < level.m_151558_()) {
            mutable.m_122173_(Direction.UP);
        }
        return level.m_8055_(mutable.m_7495_());
    }

    private int getWaterDepth(ClientLevel level, BlockPos pos) {
        int depth = 0;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (this.isWaterLike(level.m_8055_((BlockPos)mutable)) && mutable.m_123342_() > level.m_141937_()) {
            ++depth;
            mutable.m_122173_(Direction.DOWN);
        }
        return depth;
    }

    private boolean isWaterLike(BlockState state) {
        return state.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
    }

    public NativeImage getNativeImage() {
        return this.image;
    }

    public boolean isMeaningful() {
        if (this.image == null) {
            return false;
        }
        int meaningful = 0;
        for (int i = 0; i < 256; ++i) {
            int pixel = this.image.m_84985_(i % 16, i / 16);
            int alpha = pixel >> 24 & 0xFF;
            int rgb = pixel & 0xFFFFFF;
            if (alpha <= 0 || rgb == 0) continue;
            ++meaningful;
        }
        return meaningful >= 25;
    }

    public void close() {
        try {
            if (this.image != null) {
                this.image.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.texture != null) {
                this.texture.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.textureId != null) {
            Minecraft.m_91087_().m_91097_().m_118513_(this.textureId);
        }
    }
}

