/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.worldmap.WorldMapScreen;
import com.talhanation.recruits.world.RecruitsClaim;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ClaimInfoMenu {
    private static final ResourceLocation SIEGE_ICON = new ResourceLocation("recruits:textures/gui/image/enemy.png");
    private final WorldMapScreen parent;
    private boolean visible = false;
    private boolean underSiege;
    private RecruitsClaim currentClaim;
    private BannerRenderer bannerRenderer;
    private BannerRenderer bannerRendererAttacker;
    public int x;
    public int y;
    public int width = 120;
    public int height = 215;

    public ClaimInfoMenu(WorldMapScreen parent) {
        this.parent = parent;
    }

    public void init() {
        this.bannerRenderer = new BannerRenderer(null);
        this.bannerRendererAttacker = new BannerRenderer(null);
    }

    public void openForClaim(RecruitsClaim claim, int x, int y) {
        this.currentClaim = claim;
        this.visible = true;
        this.bannerRenderer.setRecruitsFaction(claim.getOwnerFaction());
        this.underSiege = claim.isUnderSiege;
        if (!claim.attackingParties.isEmpty() && claim.attackingParties.get(0) != null) {
            this.bannerRendererAttacker.setRecruitsFaction(claim.attackingParties.get(0));
        }
        this.x = x;
        this.y = y;
        this.ensureWithinScreen();
    }

    private void ensureWithinScreen() {
        if (this.x + this.width > this.parent.f_96543_) {
            this.x = this.parent.f_96543_ - this.width - 10;
        }
        if (this.x < 10) {
            this.x = 10;
        }
        if (this.y + this.height > this.parent.f_96544_) {
            this.y = this.parent.f_96544_ - this.height - 10;
        }
        if (this.y < 10) {
            this.y = 10;
        }
    }

    public void render(GuiGraphics guiGraphics) {
        if (!this.visible || this.currentClaim == null) {
            return;
        }
        guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -872415232);
        guiGraphics.m_280637_(this.x, this.y, this.width, this.height, -1);
        guiGraphics.m_280137_(this.parent.getMinecraft().f_91062_, this.currentClaim.getName(), this.x + this.width / 2, this.y + 5, 0xFFFFFF);
        if (this.underSiege) {
            this.bannerRenderer.renderBanner(guiGraphics, this.x - 7 - 35 + this.width / 2, this.y + 65, this.width, this.height, 40);
            this.bannerRendererAttacker.renderBanner(guiGraphics, this.x - 7 + 30 + this.width / 2, this.y + 65, this.width, this.height, 40);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SIEGE_ICON);
            int iconSize = 18;
            guiGraphics.m_280163_(SIEGE_ICON, this.x + this.width / 2 - iconSize / 2, this.y + 50, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else {
            this.bannerRenderer.renderBanner(guiGraphics, this.x - 7 + this.width / 2, this.y + 70, this.width, this.height, 50);
        }
        int textY = this.y + 120;
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Faction: " + (this.currentClaim.getOwnerFaction() != null ? this.currentClaim.getOwnerFaction().getTeamDisplayName() : "None"), this.x + 5, textY, 0xFFFFFF);
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Owner: " + (this.currentClaim.getPlayerInfo() != null ? this.currentClaim.getPlayerInfo().getName() : "Unknown"), this.x + 5, textY += 15, 0xFFFFFF);
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Block-Place: " + this.currentClaim.isBlockPlacementAllowed(), this.x + 5, textY += 15, 0xFFFFFF);
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Block-Break: " + this.currentClaim.isBlockBreakingAllowed(), this.x + 5, textY += 15, 0xFFFFFF);
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Block-Use: " + this.currentClaim.isBlockInteractionAllowed(), this.x + 5, textY += 15, 0xFFFFFF);
        guiGraphics.m_280488_(this.parent.getMinecraft().f_91062_, "Chunks: " + this.currentClaim.getClaimedChunks().size() + "/50", this.x + 5, textY += 15, 0xFFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.visible && this.isMouseOver(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.visible) {
            return false;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        return false;
    }

    private boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public void close() {
        this.visible = false;
        this.currentClaim = null;
        this.bannerRenderer.setRecruitsFaction(null);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }
}

