/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyEditScreen;
import com.talhanation.recruits.client.gui.worldmap.ClaimEditScreen;
import com.talhanation.recruits.client.gui.worldmap.WorldMapScreen;
import com.talhanation.recruits.network.MessageTeleportPlayer;
import com.talhanation.recruits.network.MessageUpdateClaim;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WorldMapContextMenu {
    private static final Component TEXT_DIPLOMACY = Component.m_237115_((String)"gui.recruits.map.diplomacy");
    private static final Component TEXT_CLAIM_CHUNK = Component.m_237115_((String)"gui.recruits.map.claim_chunk");
    private static final Component TEXT_CLAIM_AREA = Component.m_237115_((String)"gui.recruits.map.claim_area");
    private static final Component TEXT_EDIT_CLAIM = Component.m_237115_((String)"gui.recruits.map.edit_claim");
    private static final Component TEXT_REMOVE_CHUNK = Component.m_237115_((String)"gui.recruits.map.remove_chunk");
    private static final Component TEXT_CENTER_MAP = Component.m_237115_((String)"gui.recruits.map.center_map");
    private static final Component TEXT_REMOVE_CHUNK_ADMIN = Component.m_237115_((String)"gui.recruits.map.remove_chunk_admin");
    private static final Component TEXT_DELETE_CLAIM_ADMIN = Component.m_237115_((String)"gui.recruits.map.delete_claim_admin");
    private static final Component TEXT_TELEPORT_ADMIN = Component.m_237115_((String)"gui.recruits.map.teleport_admin");
    private final List<ContextMenuEntry> entries = new ArrayList<ContextMenuEntry>();
    private int x;
    private int y;
    private boolean visible = false;
    private final int width = 150;
    private final int entryHeight = 20;
    private final WorldMapScreen worldMapScreen;
    private String hoveredEntryTag = null;

    public WorldMapContextMenu(WorldMapScreen worldMapScreen) {
        this.worldMapScreen = worldMapScreen;
        ItemStack itemStackClaimChunk = new ItemStack((ItemLike)ClientManager.currencyItemStack.m_41720_());
        itemStackClaimChunk.m_41764_(ClientManager.configValueChunkCost);
        ItemStack itemStackClaimArea = new ItemStack((ItemLike)ClientManager.currencyItemStack.m_41720_());
        itemStackClaimArea.m_41764_(worldMapScreen.getClaimCost(ClientManager.ownFaction));
        this.addEntry(TEXT_DIPLOMACY.getString(), () -> ClientManager.ownFaction != null && this.worldMapScreen.selectedClaim != null && this.worldMapScreen.selectedClaim.getOwnerFaction() != null && !ClientManager.ownFaction.getStringID().equals(this.worldMapScreen.selectedClaim.getOwnerFactionStringID()), screen -> Minecraft.m_91087_().m_91152_((Screen)new DiplomacyEditScreen((Screen)screen, screen.selectedClaim.getOwnerFaction())));
        this.addEntry(TEXT_CLAIM_CHUNK.getString(), () -> this.worldMapScreen.canClaimChunk(worldMapScreen.selectedChunk) && (this.worldMapScreen.isPlayerFactionLeader() || this.worldMapScreen.isPlayerClaimLeader(worldMapScreen.getNeighborClaim(worldMapScreen.selectedChunk))), WorldMapScreen::claimChunk, itemStackClaimChunk, "bufferzone, chunk");
        this.addEntry(TEXT_CLAIM_AREA.getString(), () -> this.worldMapScreen.canClaimArea(worldMapScreen.getClaimArea(worldMapScreen.selectedChunk)) && this.worldMapScreen.isPlayerFactionLeader(), WorldMapScreen::claimArea, itemStackClaimArea, "bufferzone, area");
        this.addEntry(TEXT_EDIT_CLAIM.getString(), () -> this.worldMapScreen.selectedClaim != null && this.worldMapScreen.isPlayerFactionLeader(this.worldMapScreen.selectedClaim.getOwnerFaction()) || this.worldMapScreen.isPlayerClaimLeader(), screen -> {
            screen.getMinecraft().m_91152_((Screen)new ClaimEditScreen((WorldMapScreen)((Object)screen), screen.selectedClaim, screen.getPlayer()));
            screen.selectedClaim = null;
        });
        this.addEntry(TEXT_REMOVE_CHUNK.getString(), () -> this.worldMapScreen.selectedChunk != null && this.worldMapScreen.selectedClaim != null && worldMapScreen.canRemoveChunk(worldMapScreen.selectedChunk, worldMapScreen.selectedClaim) && (this.worldMapScreen.isPlayerFactionLeader(worldMapScreen.selectedClaim.getOwnerFaction()) || this.worldMapScreen.isPlayerClaimLeader(worldMapScreen.selectedClaim)), screen -> {
            if (screen.selectedClaim.containsChunk(screen.selectedChunk)) {
                screen.selectedClaim.removeChunk(screen.selectedChunk);
                screen.selectedChunk = null;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(screen.selectedClaim));
            }
        });
        this.addEntry(TEXT_CENTER_MAP.getString(), WorldMapScreen::centerOnPlayer);
        this.addEntry(TEXT_REMOVE_CHUNK_ADMIN.getString(), () -> this.worldMapScreen.selectedChunk != null && this.worldMapScreen.selectedClaim != null && this.worldMapScreen.isPlayerAdminAndCreative() && worldMapScreen.canRemoveChunk(worldMapScreen.selectedChunk, worldMapScreen.selectedClaim) && !this.worldMapScreen.isPlayerFactionLeader(worldMapScreen.selectedClaim.getOwnerFaction()) && !this.worldMapScreen.isPlayerClaimLeader(worldMapScreen.selectedClaim), screen -> {
            if (screen.selectedClaim.containsChunk(screen.selectedChunk)) {
                screen.selectedClaim.removeChunk(screen.selectedChunk);
                screen.selectedChunk = null;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(screen.selectedClaim));
            }
        }, "admin");
        this.addEntry(TEXT_DELETE_CLAIM_ADMIN.getString(), () -> this.worldMapScreen.isPlayerAdminAndCreative() && this.worldMapScreen.selectedClaim != null, screen -> {
            screen.selectedClaim.isRemoved = true;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(screen.selectedClaim));
            screen.selectedClaim = null;
        }, "admin");
        this.addEntry(TEXT_TELEPORT_ADMIN.getString(), worldMapScreen::isPlayerAdminAndCreative, screen -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageTeleportPlayer(screen.getClickedBlockPos())), "admin");
    }

    public void addEntry(String text, BooleanSupplier condition, Consumer<WorldMapScreen> action, ItemStack itemStack, String tag) {
        this.entries.add(new ContextMenuEntry((Component)Component.m_237113_((String)text), condition, action, itemStack, tag));
    }

    public void addEntry(String text, BooleanSupplier condition, Consumer<WorldMapScreen> action, String tag) {
        this.entries.add(new ContextMenuEntry((Component)Component.m_237113_((String)text), condition, action, ItemStack.f_41583_, tag));
    }

    public void addEntry(String text, BooleanSupplier condition, Consumer<WorldMapScreen> action) {
        this.entries.add(new ContextMenuEntry((Component)Component.m_237113_((String)text), condition, action, ItemStack.f_41583_, ""));
    }

    public void addEntry(String text, Consumer<WorldMapScreen> action) {
        this.addEntry(text, () -> true, action);
    }

    public void openAt(int x, int y) {
        this.x = Math.max(10, Math.min(x, this.worldMapScreen.f_96543_ - 150 - 10));
        this.y = Math.max(10, Math.min(y, this.worldMapScreen.f_96544_ - this.entries.size() * 20 - 10));
        this.visible = true;
    }

    public void close() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getHoveredEntryTag() {
        return this.hoveredEntryTag;
    }

    public void render(GuiGraphics guiGraphics, WorldMapScreen screen) {
        if (!this.visible) {
            return;
        }
        this.hoveredEntryTag = null;
        int visibleEntries = (int)this.entries.stream().filter(entry -> entry.shouldShow(screen)).count();
        int height = visibleEntries * 20;
        guiGraphics.m_280509_(this.x, this.y, this.x + 150, this.y + height, -15066598);
        guiGraphics.m_280637_(this.x, this.y, 150, height, -11184811);
        int entryY = this.y;
        for (ContextMenuEntry entry2 : this.entries) {
            if (!entry2.shouldShow(screen)) continue;
            boolean hovered = this.isMouseOverEntry(this.x, entryY);
            if (hovered) {
                this.hoveredEntryTag = entry2.getTag();
            }
            int bgColor = hovered ? -13421773 : -15066598;
            guiGraphics.m_280509_(this.x, entryY, this.x + 150, entryY + 20, bgColor);
            int textColor = entry2.getTag().equals("admin") ? (hovered ? -43691 : -5618620) : (hovered ? 0xFFFFFF : 0xCCCCCC);
            guiGraphics.m_280430_(screen.getMinecraft().f_91062_, entry2.text(), this.x + 8, entryY + 6, textColor);
            if (!entry2.stack.m_41619_()) {
                guiGraphics.m_280203_(entry2.stack, this.x + 150 - 20, entryY + 1);
                guiGraphics.m_280370_(screen.getMinecraft().f_91062_, entry2.stack, this.x + 150 - 20, entryY + 1);
            }
            entryY += 20;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, WorldMapScreen screen) {
        if (!this.visible || button != 0) {
            return false;
        }
        int entryY = this.y;
        for (ContextMenuEntry entry : this.entries) {
            if (!entry.shouldShow(screen)) continue;
            if (mouseX >= (double)this.x && mouseX <= (double)(this.x + 150) && mouseY >= (double)entryY && mouseY <= (double)(entryY + 20)) {
                entry.execute(screen);
                this.close();
                return true;
            }
            entryY += 20;
        }
        this.close();
        return false;
    }

    private boolean isMouseOverEntry(int entryX, int entryY) {
        double mouseX = this.worldMapScreen.mouseX;
        double mouseY = this.worldMapScreen.mouseY;
        return mouseX >= (double)entryX && mouseX <= (double)(entryX + 150) && mouseY >= (double)entryY && mouseY <= (double)(entryY + 20);
    }

    private record ContextMenuEntry(Component text, BooleanSupplier condition, Consumer<WorldMapScreen> action, ItemStack stack, String tag) {
        public String getTag() {
            return this.tag;
        }

        public boolean shouldShow(WorldMapScreen screen) {
            return this.condition.getAsBoolean();
        }

        public void execute(WorldMapScreen screen) {
            this.action.accept(screen);
        }
    }
}

