/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.worldmap;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.ClientManager;
import com.talhanation.recruits.client.gui.worldmap.ChunkTile;
import com.talhanation.recruits.client.gui.worldmap.ChunkTileManager;
import com.talhanation.recruits.client.gui.worldmap.ClaimInfoMenu;
import com.talhanation.recruits.client.gui.worldmap.ClaimRenderer;
import com.talhanation.recruits.client.gui.worldmap.WorldMapContextMenu;
import com.talhanation.recruits.compat.SmallShips;
import com.talhanation.recruits.network.MessageDoPayment;
import com.talhanation.recruits.network.MessageUpdateClaim;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import com.talhanation.recruits.world.RecruitsRoute;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class WorldMapScreen
extends Screen {
    private static final ResourceLocation MAP_ICONS = new ResourceLocation("textures/map/map_icons.png");
    private final ChunkTileManager tileManager;
    private final Player player;
    private static final double MIN_SCALE = 0.5;
    private static final double MAX_SCALE = 10.0;
    private static final double DEFAULT_SCALE = 2.0;
    private static final double SCALE_STEP = 0.1;
    private static final int CHUNK_HIGHLIGHT_COLOR = 0x40FFFFFF;
    private static final int CHUNK_SELECTION_COLOR = -1;
    private static final int DARK_GRAY_BG = -15724528;
    private double offsetX = 0.0;
    private double offsetZ = 0.0;
    public static double scale = 2.0;
    public double lastMouseX;
    public double lastMouseY;
    private boolean isDragging = false;
    private ChunkPos hoveredChunk = null;
    ChunkPos selectedChunk = null;
    private int clickedBlockX = 0;
    private int clickedBlockZ = 0;
    private int hoverBlockX = 0;
    private int hoverBlockZ = 0;
    private WorldMapContextMenu contextMenu = new WorldMapContextMenu(this);
    RecruitsClaim selectedClaim = null;
    private ClaimInfoMenu claimInfoMenu = new ClaimInfoMenu(this);
    public RecruitsRoute selectedRoute;
    private static final ItemStack BOAT_STACK = new ItemStack((ItemLike)Items.f_42453_);
    public double mouseX;
    public double mouseY;
    private long lastFpsTime = 0L;
    private int fpsCounter = 0;
    private int currentFps = 0;

    public WorldMapScreen() {
        super((Component)Component.m_237113_((String)""));
        this.tileManager = ChunkTileManager.getInstance();
        this.player = Minecraft.m_91087_().f_91074_;
    }

    public BlockPos getHoveredBlockPos() {
        return new BlockPos(this.hoverBlockX, 0, this.hoverBlockZ);
    }

    public BlockPos getClickedBlockPos() {
        return new BlockPos(this.clickedBlockX, 0, this.clickedBlockZ);
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isPlayerAdminAndCreative() {
        return this.player.m_20310_(2) && this.player.m_7500_();
    }

    public double getScale() {
        return scale;
    }

    public void setSelectedChunk(ChunkPos chunk) {
        this.selectedChunk = chunk;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_.f_91073_ != null && this.player != null) {
            this.tileManager.initialize((Level)this.f_96541_.f_91073_);
            this.centerOnPlayer();
        }
        this.claimInfoMenu.init();
    }

    public void centerOnPlayer() {
        if (this.player != null) {
            int chunkX = this.player.m_146902_().f_45578_;
            int chunkZ = this.player.m_146902_().f_45579_;
            double pixelX = (double)(chunkX * 16) * scale;
            double pixelZ = (double)(chunkZ * 16) * scale;
            this.offsetX = -pixelX + (double)this.f_96543_ / 2.0;
            this.offsetZ = -pixelZ + (double)this.f_96544_ / 2.0;
        }
    }

    public void resetZoom() {
        scale = 2.0;
        this.centerOnPlayer();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        String entryTag;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280588_(0, 0, this.f_96543_, this.f_96544_);
        this.renderMapTiles(guiGraphics);
        ClaimRenderer.renderClaimsOverlay(guiGraphics, this.selectedClaim, this.offsetX, this.offsetZ, scale);
        if (this.contextMenu.isVisible() && (entryTag = this.contextMenu.getHoveredEntryTag()) != null) {
            if (entryTag.contains("bufferzone")) {
                ClaimRenderer.renderBufferZone(guiGraphics, this.offsetX, this.offsetZ, scale);
            }
            if (entryTag.contains("area")) {
                ClaimRenderer.renderAreaPreview(guiGraphics, this.getClaimArea(this.selectedChunk), this.offsetX, this.offsetZ, scale);
            }
            if (entryTag.contains("chunk")) {
                ClaimRenderer.renderAreaPreview(guiGraphics, this.getClaimableChunks(this.selectedChunk, 16), this.offsetX, this.offsetZ, scale);
            }
        }
        if (this.player != null) {
            this.renderPlayerPosition(guiGraphics);
        }
        if (this.selectedChunk != null && (this.selectedClaim == null || this.contextMenu.isVisible())) {
            this.renderChunkOutline(guiGraphics, this.selectedChunk.f_45578_, this.selectedChunk.f_45579_, -1);
        }
        if (this.hoveredChunk != null) {
            this.renderChunkHighlight(guiGraphics, this.hoveredChunk.f_45578_, this.hoveredChunk.f_45579_);
        }
        if (this.selectedRoute != null) {
            this.renderRoute(guiGraphics);
        }
        guiGraphics.m_280618_();
        this.renderCoordinatesAndZoom(guiGraphics);
        this.contextMenu.render(guiGraphics, this);
        if (this.selectedClaim != null && this.claimInfoMenu.isVisible()) {
            Point p = this.getClaimInfoMenuPosition(this.selectedClaim, this.claimInfoMenu.width, this.claimInfoMenu.height);
            this.claimInfoMenu.setPosition(p.x, p.y);
            this.claimInfoMenu.render(guiGraphics);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -15724528);
    }

    private void renderMapTiles(GuiGraphics guiGraphics) {
        double tileSize = 160.0;
        double scaledTileSize = tileSize * scale;
        double leftEdge = -this.offsetX;
        double rightEdge = (double)this.f_96543_ - this.offsetX;
        double topEdge = -this.offsetZ;
        double bottomEdge = (double)this.f_96544_ - this.offsetZ;
        int startTileX = (int)Math.floor(leftEdge / scaledTileSize - 0.5);
        int endTileX = (int)Math.ceil(rightEdge / scaledTileSize + 0.5);
        int startTileZ = (int)Math.floor(topEdge / scaledTileSize - 0.5);
        int endTileZ = (int)Math.ceil(bottomEdge / scaledTileSize + 0.5);
        for (int tileZ = startTileZ; tileZ <= endTileZ; ++tileZ) {
            for (int tileX = startTileX; tileX <= endTileX; ++tileX) {
                ChunkTile tile = this.tileManager.getOrCreateTile(tileX, tileZ);
                ResourceLocation textureId = tile.getTextureId();
                if (textureId == null) continue;
                double tileWorldX = (double)tileX * scaledTileSize + this.offsetX;
                double tileWorldZ = (double)tileZ * scaledTileSize + this.offsetZ;
                double drawX = tileWorldX - 0.5;
                double drawZ = tileWorldZ - 0.5;
                double drawSize = scaledTileSize + 1.0;
                int x = (int)Math.floor(drawX);
                int z = (int)Math.floor(drawZ);
                int size = (int)Math.ceil(drawSize);
                if (Math.abs(scale - 1.0) < 0.01) {
                    x = (int)Math.round(tileWorldX);
                    z = (int)Math.round(tileWorldZ);
                    size = (int)Math.round(scaledTileSize);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureId);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.m_280163_(textureId, x, z, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    public void renderRoute(GuiGraphics guiGraphics) {
        if (this.selectedRoute.getWaypoints().isEmpty()) {
            return;
        }
        List<RecruitsRoute.Waypoint> waypoints = this.selectedRoute.getWaypoints();
        for (RecruitsRoute.Waypoint waypoint : waypoints) {
            if (waypoint == null) {
                return;
            }
            double playerWorldX = waypoint.getPosition().m_123341_();
            double playerWorldZ = waypoint.getPosition().m_123343_();
            int pixelX = (int)(this.offsetX + playerWorldX * scale);
            int pixelZ = (int)(this.offsetZ + playerWorldZ * scale);
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)pixelX, (float)pixelZ, 0.0f);
            pose.m_85849_();
            pose.m_85841_(3.0f, 3.0f, 3.0f);
            int iconIndex = 6;
            float u0 = (float)(iconIndex % 16) / 16.0f;
            float v0 = (float)(iconIndex / 16) / 16.0f;
            float u1 = u0 + 0.0625f;
            float v1 = v0 + 0.0625f;
            guiGraphics.m_280262_();
            VertexConsumer consumer = guiGraphics.m_280091_().m_6299_(RenderType.m_110497_((ResourceLocation)MAP_ICONS));
            Matrix4f matrix = pose.m_85850_().m_252922_();
            int light = 0xF000F0;
            int color = -1;
            consumer.m_252986_(matrix, -1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, 1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, -1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            pose.m_85849_();
        }
    }

    public void renderWaypoint(GuiGraphics guiGraphics) {
    }

    private void renderPlayerPosition(GuiGraphics guiGraphics) {
        if (this.player == null) {
            return;
        }
        double playerWorldX = this.player.m_20185_();
        double playerWorldZ = this.player.m_20189_();
        int pixelX = (int)(this.offsetX + playerWorldX * scale);
        int pixelZ = (int)(this.offsetZ + playerWorldZ * scale);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)pixelX, (float)pixelZ, 0.0f);
        if (this.player.m_20202_() instanceof Boat) {
            this.renderPlayerBoat(pose, guiGraphics);
        } else {
            this.renderPlayerIcon(pose, guiGraphics);
        }
        pose.m_85849_();
        this.renderPlayerNameTag(guiGraphics, pixelX, pixelZ);
    }

    private void renderPlayerBoat(PoseStack pose, GuiGraphics guiGraphics) {
        float yaw = this.player.m_146908_() % 360.0f;
        if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        boolean flipX = yaw > 0.0f;
        pose.m_85836_();
        if (flipX) {
            pose.m_85841_(-1.0f, 1.0f, 1.0f);
        }
        pose.m_85841_(1.5f, 1.5f, 1.5f);
        Lighting.m_84930_();
        ItemStack boat = BOAT_STACK;
        if (Main.isSmallShipsLoaded && this.player.m_20202_() != null && SmallShips.isSmallShip(this.player.m_20202_())) {
            boat = SmallShips.getSmallShipsItem();
        }
        RenderSystem.disableCull();
        guiGraphics.m_280480_(boat, -8, -8);
        RenderSystem.enableCull();
        pose.m_85849_();
    }

    private void renderPlayerIcon(PoseStack pose, GuiGraphics guiGraphics) {
        pose.m_252781_(Axis.f_252403_.m_252977_(this.player.m_146908_()));
        pose.m_85841_(5.0f, 5.0f, 5.0f);
        int iconIndex = 0;
        float u0 = (float)(iconIndex % 16) / 16.0f;
        float v0 = (float)(iconIndex / 16) / 16.0f;
        float u1 = u0 + 0.0625f;
        float v1 = v0 + 0.0625f;
        guiGraphics.m_280262_();
        VertexConsumer consumer = guiGraphics.m_280091_().m_6299_(RenderType.m_110497_((ResourceLocation)MAP_ICONS));
        Matrix4f matrix = pose.m_85850_().m_252922_();
        int light = 0xF000F0;
        int color = -1;
        consumer.m_252986_(matrix, -1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, -1.0f, -1.0f, 0.0f).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderPlayerNameTag(GuiGraphics guiGraphics, int pixelX, int pixelZ) {
        if (this.player != null && scale > 1.5) {
            String playerName = this.player.m_7755_().getString();
            float textScale = (float)Math.min(1.0, scale / 1.25);
            int textWidth = this.f_96547_.m_92895_(playerName);
            Objects.requireNonNull(this.f_96547_);
            int textHeight = 9;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)pixelX - (double)((float)textWidth * textScale) / 2.0, (double)pixelZ - (double)((float)textHeight * textScale) / 2.0 - 10.0, 0.0);
            guiGraphics.m_280168_().m_85841_(textScale, textScale, 1.0f);
            guiGraphics.m_280056_(this.f_96547_, playerName, 0, 0, 0xFFFFFF, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderChunkHighlight(GuiGraphics guiGraphics, int chunkX, int chunkZ) {
        int pixelX = (int)(this.offsetX + (double)(chunkX * 16) * scale);
        int pixelZ = (int)(this.offsetZ + (double)(chunkZ * 16) * scale);
        int size = (int)(16.0 * scale);
        guiGraphics.m_280509_(pixelX, pixelZ, pixelX + size, pixelZ + size, 0x40FFFFFF);
    }

    private void renderChunkOutline(GuiGraphics guiGraphics, int chunkX, int chunkZ, int color) {
        int pixelX = (int)(this.offsetX + (double)(chunkX * 16) * scale);
        int pixelZ = (int)(this.offsetZ + (double)(chunkZ * 16) * scale);
        int size = (int)(16.0 * scale);
        guiGraphics.m_280656_(pixelX, pixelX + size, pixelZ, color);
        guiGraphics.m_280656_(pixelX, pixelX + size, pixelZ + size, color);
        guiGraphics.m_280315_(pixelX, pixelZ, pixelZ + size, color);
        guiGraphics.m_280315_(pixelX + size, pixelZ, pixelZ + size, color);
    }

    private void renderCoordinatesAndZoom(GuiGraphics guiGraphics) {
        String coords = String.format("X: %d, Z: %d", this.hoverBlockX, this.hoverBlockZ);
        String zoom = String.format("Zoom: %.1fx", scale);
        String combined = coords + " | " + zoom;
        int textWidth = this.f_96547_.m_92895_(combined);
        int bgX = this.f_96543_ / 2 - textWidth / 2 - 8;
        int bgY = this.f_96544_ - 30;
        int bgWidth = textWidth + 16;
        guiGraphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + 20, Integer.MIN_VALUE);
        guiGraphics.m_280637_(bgX, bgY, bgWidth, 20, 0x40FFFFFF);
        guiGraphics.m_280137_(this.f_96547_, combined, this.f_96543_ / 2, this.f_96544_ - 25, 0xFFFFFF);
    }

    public void centerOnClaim(RecruitsClaim claim) {
        if (claim == null || claim.getCenter() == null) {
            return;
        }
        ChunkPos center = claim.getCenter();
        double pixelX = (double)(center.f_45578_ * 16) * scale;
        double pixelZ = (double)(center.f_45579_ * 16) * scale;
        this.offsetX = -pixelX + (double)this.f_96543_ / 2.0;
        this.offsetZ = -pixelZ + (double)this.f_96544_ / 2.0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        RecruitsClaim clickedClaim;
        if (this.claimInfoMenu.isVisible() && this.claimInfoMenu.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.contextMenu.isVisible() && this.contextMenu.mouseClicked(mouseX, mouseY, button, this)) {
            return true;
        }
        if (this.hoveredChunk != null) {
            this.selectedChunk = this.hoveredChunk;
        }
        if ((clickedClaim = ClaimRenderer.getClaimAtPosition(mouseX, mouseY, this.offsetX, this.offsetZ, scale)) != null) {
            this.selectedClaim = clickedClaim;
            this.claimInfoMenu.openForClaim(this.selectedClaim, (int)mouseX, (int)mouseY);
        } else {
            this.selectedClaim = null;
            this.claimInfoMenu.close();
        }
        if (button == 1) {
            double worldX = (mouseX - this.offsetX) / scale;
            double worldZ = (mouseY - this.offsetZ) / scale;
            this.clickedBlockX = (int)Math.floor(worldX);
            this.clickedBlockZ = (int)Math.floor(worldZ);
            this.contextMenu = new WorldMapContextMenu(this);
            this.contextMenu.openAt((int)mouseX, (int)mouseY);
            this.claimInfoMenu.close();
        }
        if (button == 0) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.isDragging = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.contextMenu.isVisible()) {
            return false;
        }
        if (button == 0) {
            this.isDragging = false;
        }
        if (this.claimInfoMenu.isVisible()) {
            this.claimInfoMenu.mouseReleased(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.offsetX += mouseX - this.lastMouseX;
            this.offsetZ += mouseY - this.lastMouseY;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (this.claimInfoMenu.isVisible()) {
                this.claimInfoMenu.close();
            }
            return true;
        }
        if (this.claimInfoMenu.isVisible()) {
            this.claimInfoMenu.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.claimInfoMenu.isVisible()) {
            this.claimInfoMenu.close();
        }
        if (this.contextMenu.isVisible()) {
            this.contextMenu.close();
        }
        double zoomFactor = 1.0 + (delta > 0.0 ? 0.1 : -0.1);
        double newScale = Math.max(0.5, Math.min(10.0, scale * zoomFactor));
        double mouseWorldX = (mouseX - this.offsetX) / scale;
        double mouseWorldZ = (mouseY - this.offsetZ) / scale;
        scale = newScale;
        this.offsetX = mouseX - mouseWorldX * scale;
        this.offsetZ = mouseY - mouseWorldZ * scale;
        return true;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int worldX = (int)((mouseX - this.offsetX) / scale);
        int worldZ = (int)((mouseY - this.offsetZ) / scale);
        this.hoverBlockX = (int)Math.floor(worldX);
        this.hoverBlockZ = (int)Math.floor(worldZ);
        this.hoveredChunk = new ChunkPos(this.hoverBlockX >> 4, this.hoverBlockZ >> 4);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.claimInfoMenu.isVisible()) {
                this.claimInfoMenu.close();
                return true;
            }
            if (this.contextMenu.isVisible()) {
                this.contextMenu.close();
                return true;
            }
            this.m_7379_();
            return true;
        }
        if (!this.contextMenu.isVisible() && !this.claimInfoMenu.isVisible()) {
            double moveSpeed = 40.0 / scale;
            switch (keyCode) {
                case 87: 
                case 265: {
                    this.offsetZ += moveSpeed;
                    break;
                }
                case 83: 
                case 264: {
                    this.offsetZ -= moveSpeed;
                    break;
                }
                case 65: 
                case 263: {
                    this.offsetX += moveSpeed;
                    break;
                }
                case 68: 
                case 262: {
                    this.offsetX -= moveSpeed;
                    break;
                }
                case 61: {
                    this.m_6050_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 1.0);
                    break;
                }
                case 45: {
                    this.m_6050_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, -1.0);
                    break;
                }
                case 67: {
                    this.centerOnPlayer();
                    break;
                }
                case 82: {
                    this.resetZoom();
                }
            }
        }
        return true;
    }

    public void m_7379_() {
        this.tileManager.close();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderFPS(GuiGraphics guiGraphics) {
        long currentTime = System.currentTimeMillis();
        ++this.fpsCounter;
        if (currentTime - this.lastFpsTime >= 1000L) {
            this.currentFps = this.fpsCounter;
            this.fpsCounter = 0;
            this.lastFpsTime = currentTime;
        }
        String fpsText = String.format("FPS: %d", this.currentFps);
        guiGraphics.m_280488_(this.f_96547_, fpsText, this.f_96543_ - this.f_96547_.m_92895_(fpsText) - 15, 5, 65280);
    }

    public boolean isPlayerFactionLeader() {
        return this.isPlayerFactionLeader(ClientManager.ownFaction);
    }

    public boolean isPlayerFactionLeader(RecruitsFaction faction) {
        if (this.player == null || faction == null) {
            return false;
        }
        return faction.getTeamLeaderUUID().equals(this.player.m_20148_());
    }

    public boolean isPlayerClaimLeader() {
        return this.isPlayerClaimLeader(this.selectedClaim);
    }

    public boolean isPlayerClaimLeader(RecruitsClaim claim) {
        if (this.player == null || claim == null) {
            return false;
        }
        return claim.getPlayerInfo().getUUID().equals(this.player.m_20148_());
    }

    public List<ChunkPos> getClaimArea(ChunkPos pos) {
        ArrayList<ChunkPos> area = new ArrayList<ChunkPos>();
        if (pos == null) {
            return area;
        }
        int range = 2;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                area.add(new ChunkPos(pos.f_45578_ + dx, pos.f_45579_ + dz));
            }
        }
        return area;
    }

    public void claimArea() {
        if (!this.canPlayerPay(this.getClaimCost(ClientManager.ownFaction), this.player)) {
            return;
        }
        if (!ClientManager.configValueIsClaimingAllowed) {
            return;
        }
        List<ChunkPos> area = this.getClaimArea(this.selectedChunk);
        RecruitsClaim newClaim = new RecruitsClaim(ClientManager.ownFaction);
        for (ChunkPos pos : area) {
            newClaim.addChunk(pos);
        }
        newClaim.setCenter(this.selectedChunk);
        newClaim.setPlayer(new RecruitsPlayerInfo(this.player.m_20148_(), this.player.m_7755_().getString(), ClientManager.ownFaction));
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDoPayment(this.player.m_20148_(), this.getClaimCost(ClientManager.ownFaction)));
        ClientManager.recruitsClaims.add(newClaim);
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(newClaim));
    }

    public void claimChunk() {
        String neighborID;
        if (!this.canPlayerPay(ClientManager.configValueChunkCost, this.player)) {
            return;
        }
        if (!ClientManager.configValueIsClaimingAllowed) {
            return;
        }
        RecruitsClaim neighborClaim = this.getNeighborClaim(this.selectedChunk);
        if (neighborClaim == null) {
            return;
        }
        String ownerID = ClientManager.ownFaction.getStringID();
        if (!Objects.equals(ownerID, neighborID = neighborClaim.getOwnerFaction().getStringID())) {
            return;
        }
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (!claim.equals(neighborClaim)) continue;
            neighborClaim.addChunk(this.selectedChunk);
            this.recalculateCenter(neighborClaim);
            break;
        }
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDoPayment(this.player.m_20148_(), ClientManager.configValueChunkCost));
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpdateClaim(neighborClaim));
    }

    @Nullable
    public RecruitsClaim getNeighborClaim(ChunkPos chunk) {
        ChunkPos[] neighbors;
        for (ChunkPos neighbor : neighbors = new ChunkPos[]{new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_ - 1, chunk.f_45579_), new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1), new ChunkPos(chunk.f_45578_, chunk.f_45579_ - 1)}) {
            for (RecruitsClaim claim : ClientManager.recruitsClaims) {
                if (!claim.containsChunk(neighbor)) continue;
                return claim;
            }
        }
        return null;
    }

    public void recalculateCenter(RecruitsClaim claim) {
        List<ChunkPos> claimedChunks = claim.getClaimedChunks();
        if (claimedChunks.isEmpty()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ChunkPos pos : claimedChunks) {
            if (pos.f_45578_ < minX) {
                minX = pos.f_45578_;
            }
            if (pos.f_45578_ > maxX) {
                maxX = pos.f_45578_;
            }
            if (pos.f_45579_ < minZ) {
                minZ = pos.f_45579_;
            }
            if (pos.f_45579_ <= maxZ) continue;
            maxZ = pos.f_45579_;
        }
        int centerX = (minX + maxX) / 2;
        int centerZ = (minZ + maxZ) / 2;
        claim.setCenter(new ChunkPos(centerX, centerZ));
    }

    public Rectangle getClaimScreenBounds(RecruitsClaim claim) {
        int minChunkX = Integer.MAX_VALUE;
        int maxChunkX = Integer.MIN_VALUE;
        int minChunkZ = Integer.MAX_VALUE;
        int maxChunkZ = Integer.MIN_VALUE;
        for (ChunkPos pos : claim.getClaimedChunks()) {
            minChunkX = Math.min(minChunkX, pos.f_45578_);
            maxChunkX = Math.max(maxChunkX, pos.f_45578_);
            minChunkZ = Math.min(minChunkZ, pos.f_45579_);
            maxChunkZ = Math.max(maxChunkZ, pos.f_45579_);
        }
        int x1 = (int)(this.offsetX + (double)(minChunkX * 16) * scale);
        int y1 = (int)(this.offsetZ + (double)(minChunkZ * 16) * scale);
        int x2 = (int)(this.offsetX + (double)((maxChunkX + 1) * 16) * scale);
        int y2 = (int)(this.offsetZ + (double)((maxChunkZ + 1) * 16) * scale);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Point getClaimInfoMenuPosition(RecruitsClaim claim, int menuWidth, int menuHeight) {
        Rectangle bounds = this.getClaimScreenBounds(claim);
        int margin = 10;
        int x = bounds.x + bounds.width + margin;
        int y = bounds.y + bounds.height / 2 - menuHeight / 2;
        if (x + menuWidth > this.f_96543_) {
            x = bounds.x - menuWidth - margin;
        }
        if (y < 10) {
            y = 10;
        }
        if (y + menuHeight > this.f_96544_ - 10) {
            y = this.f_96544_ - menuHeight - 10;
        }
        return new Point(x, y);
    }

    public boolean canRemoveChunk(ChunkPos pos, RecruitsClaim claim) {
        ChunkPos[] neighbors;
        if (pos == null || ClientManager.ownFaction == null) {
            return false;
        }
        if (this.isPlayerTooFar(pos)) {
            return false;
        }
        List<ChunkPos> claimedChunks = claim.getClaimedChunks();
        if (!claimedChunks.contains(pos)) {
            return false;
        }
        int unclaimedNeighborCount = 0;
        for (ChunkPos neighbor : neighbors = new ChunkPos[]{new ChunkPos(pos.f_45578_ + 1, pos.f_45579_), new ChunkPos(pos.f_45578_ - 1, pos.f_45579_), new ChunkPos(pos.f_45578_, pos.f_45579_ + 1), new ChunkPos(pos.f_45578_, pos.f_45579_ - 1)}) {
            if (claimedChunks.contains(neighbor)) continue;
            ++unclaimedNeighborCount;
        }
        return unclaimedNeighborCount >= 2;
    }

    private boolean isPlayerTooFar(ChunkPos pos) {
        if (pos == null) {
            return true;
        }
        int playerPosX = this.player.m_146902_().f_45578_;
        int playerPosZ = this.player.m_146902_().f_45579_;
        int diffX = Math.abs(playerPosX) - Math.abs(pos.f_45578_);
        int diffZ = Math.abs(playerPosZ) - Math.abs(pos.f_45579_);
        return Math.abs(diffZ) > 4 || Math.abs(diffX) > 4;
    }

    public int getClaimCost(RecruitsFaction ownerTeam) {
        if (!ClientManager.configValueCascadeClaimCost) {
            return ClientManager.configValueClaimCost;
        }
        int amount = 1;
        if (ownerTeam != null) {
            for (RecruitsClaim claim : ClientManager.recruitsClaims) {
                if (!claim.getOwnerFaction().getStringID().equals(ownerTeam.getStringID())) continue;
                ++amount;
            }
        }
        return amount * ClientManager.configValueClaimCost;
    }

    public boolean canPlayerPay(int cost, Player player) {
        return player.m_7500_() || cost <= player.m_150109_().m_18947_(ClientManager.currencyItemStack.m_41720_());
    }

    public static boolean isInBufferZone(ChunkPos chunk, RecruitsFaction ownFaction) {
        if (ownFaction == null) {
            return false;
        }
        for (RecruitsClaim claim : ClientManager.recruitsClaims) {
            if (claim.getOwnerFaction() == null || claim.getOwnerFaction().getStringID().equals(ownFaction.getStringID())) continue;
            for (ChunkPos claimChunk : claim.getClaimedChunks()) {
                int dx = Math.abs(chunk.f_45578_ - claimChunk.f_45578_);
                int dz = Math.abs(chunk.f_45579_ - claimChunk.f_45579_);
                if (dx > 3 || dz > 3 || dx == 0 && dz == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canClaimChunk(ChunkPos pos) {
        if (!ClientManager.configValueIsClaimingAllowed) {
            return false;
        }
        if (pos == null || ClientManager.ownFaction == null) {
            return false;
        }
        if (this.isPlayerTooFar(pos)) {
            return false;
        }
        for (RecruitsClaim existingClaim : ClientManager.recruitsClaims) {
            if (!existingClaim.containsChunk(pos)) continue;
            return false;
        }
        RecruitsClaim neighborClaim = this.getNeighborClaim(pos);
        if (neighborClaim == null) {
            return false;
        }
        if (neighborClaim.getClaimedChunks().size() >= RecruitsClaim.MAX_SIZE) {
            return false;
        }
        return !WorldMapScreen.isInBufferZone(pos, ClientManager.ownFaction);
    }

    public boolean canClaimArea(List<ChunkPos> areaChunks) {
        if (this.selectedChunk == null || areaChunks == null || areaChunks.isEmpty() || ClientManager.ownFaction == null) {
            return false;
        }
        if (this.isPlayerTooFar(this.selectedChunk)) {
            return false;
        }
        for (ChunkPos chunk : areaChunks) {
            for (RecruitsClaim existingClaim : ClientManager.recruitsClaims) {
                if (!existingClaim.containsChunk(chunk)) continue;
                return false;
            }
            if (!WorldMapScreen.isInBufferZone(chunk, ClientManager.ownFaction)) continue;
            return false;
        }
        return true;
    }

    public List<ChunkPos> getClaimableChunks(ChunkPos center, int radius) {
        ArrayList<ChunkPos> claimableChunks = new ArrayList<ChunkPos>();
        if (center == null || ClientManager.ownFaction == null) {
            return claimableChunks;
        }
        int minX = center.f_45578_ - radius;
        int maxX = center.f_45578_ + radius;
        int minZ = center.f_45579_ - radius;
        int maxZ = center.f_45579_ + radius;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                ChunkPos chunk = new ChunkPos(x, z);
                if (!this.canClaimChunkRaw(chunk)) continue;
                claimableChunks.add(chunk);
            }
        }
        return claimableChunks;
    }

    public boolean canClaimChunkRaw(ChunkPos pos) {
        for (RecruitsClaim existingClaim : ClientManager.recruitsClaims) {
            if (!existingClaim.containsChunk(pos)) continue;
            return false;
        }
        RecruitsClaim neighborClaim = this.getNeighborClaim(pos);
        if (neighborClaim == null) {
            return false;
        }
        return !WorldMapScreen.isInBufferZone(pos, ClientManager.ownFaction);
    }

    public boolean canAddRoute() {
        return this.selectedRoute != null;
    }

    public void addRoute() {
        RecruitsRoute newRoute = new RecruitsRoute("New Route");
    }
}

