/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.talhanation.recruits.ClaimEvents;
import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.VillagerNobleEntity;
import com.talhanation.recruits.items.RecruitsSpawnEgg;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsClaimManager;
import com.talhanation.recruits.world.RecruitsDiplomacyManager;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsHireTrade;
import com.talhanation.recruits.world.RecruitsHireTradesRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.server.command.EnumArgument;

public class RecruitsAdminCommands {
    private static final List<String> RELATIONS = List.of("Ally", "Neutral", "Enemy");
    private static final SuggestionProvider<CommandSourceStack> RELATION_SUGGESTIONS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("recruits:relations"), (context, builder) -> {
        for (String relation : RELATIONS) {
            builder.suggest(relation);
        }
        return builder.buildFuture();
    });

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"recruits").requires(source -> source.m_6761_(2));
        literalBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").then(Commands.m_82127_((String)"tpRecruitsToOwner").then(Commands.m_82129_((String)"Owner", (ArgumentType)ScoreHolderArgument.m_108239_()).suggests(ScoreHolderArgument.f_108210_).executes(conetext -> {
            ServerLevel level = ((CommandSourceStack)conetext.getSource()).m_81372_();
            return RecruitsAdminCommands.tpToOwner(level, ScoreHolderArgument.m_108246_((CommandContext)conetext, (String)"Owner"));
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unitsManager").then(Commands.m_82127_((String)"getUnitsCount").then(Commands.m_82129_((String)"Player", (ArgumentType)ScoreHolderArgument.m_108239_()).suggests(ScoreHolderArgument.f_108210_).executes(context -> {
            String playerName = ScoreHolderArgument.m_108223_((CommandContext)context, (String)"Player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_6846_().m_11255_(playerName);
            if (player == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Player found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            int unitCount = RecruitsAdminCommands.getUnitsCount(player);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " has " + unitCount + " from max. " + RecruitsServerConfig.MaxRecruitsForPlayer.get())), false);
            return 1;
        })))).then(Commands.m_82127_((String)"setUnitsCount").then(Commands.m_82129_((String)"Player", (ArgumentType)ScoreHolderArgument.m_108239_()).suggests(ScoreHolderArgument.f_108210_).then(Commands.m_82129_((String)"Amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            String playerName = ScoreHolderArgument.m_108223_((CommandContext)context, (String)"Player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_6846_().m_11255_(playerName);
            if (player == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Player found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"Amount");
            return RecruitsAdminCommands.setUnitsCount((CommandContext<CommandSourceStack>)context, player, amount);
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"factionManager").then(Commands.m_82127_((String)"getNPCCount").then(Commands.m_82129_((String)"Faction", (ArgumentType)TeamArgument.m_112088_()).executes(context -> {
            PlayerTeam playerTeam = TeamArgument.m_112091_((CommandContext)context, (String)"Faction");
            RecruitsFaction faction = FactionEvents.recruitsFactionManager.getFactionByStringID(playerTeam.m_5758_());
            if (faction == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Faction found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(faction.getTeamDisplayName() + " has " + faction.npcs + " from max. " + faction.maxNPCs)), false);
            return 1;
        })))).then(Commands.m_82127_((String)"setNPCCount").then(Commands.m_82129_((String)"Faction", (ArgumentType)TeamArgument.m_112088_()).then(Commands.m_82129_((String)"Amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            PlayerTeam playerTeam = TeamArgument.m_112091_((CommandContext)context, (String)"Faction");
            RecruitsFaction faction = FactionEvents.recruitsFactionManager.getFactionByStringID(playerTeam.m_5758_());
            if (faction == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Faction found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"Amount");
            return RecruitsAdminCommands.setFactionNPCsCount((CommandContext<CommandSourceStack>)context, faction, amount);
        }))))).then(Commands.m_82127_((String)"getLeader").then(Commands.m_82129_((String)"Faction", (ArgumentType)TeamArgument.m_112088_()).executes(context -> {
            PlayerTeam playerTeam = TeamArgument.m_112091_((CommandContext)context, (String)"Faction");
            RecruitsFaction faction = FactionEvents.recruitsFactionManager.getFactionByStringID(playerTeam.m_5758_());
            if (faction == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Faction found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("The Leader of " + faction.getTeamDisplayName() + " is " + faction.getTeamLeaderName())), false);
            return 1;
        })))).then(Commands.m_82127_((String)"setLeader").then(Commands.m_82129_((String)"Faction", (ArgumentType)TeamArgument.m_112088_()).then(Commands.m_82129_((String)"Player", (ArgumentType)ScoreHolderArgument.m_108239_()).suggests(ScoreHolderArgument.f_108210_).executes(context -> {
            PlayerTeam playerTeam = TeamArgument.m_112091_((CommandContext)context, (String)"Faction");
            RecruitsFaction faction = FactionEvents.recruitsFactionManager.getFactionByStringID(playerTeam.m_5758_());
            String playerName = ScoreHolderArgument.m_108223_((CommandContext)context, (String)"Player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_6846_().m_11255_(playerName);
            if (faction == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Faction found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (player == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Player found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (FactionEvents.isPlayerAlreadyAFactionLeader(player)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Player is already a Leader of another Faction!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (!playerTeam.m_6809_().contains(playerName)) {
                FactionEvents.addPlayerToTeam(null, ((CommandSourceStack)context.getSource()).m_81372_(), faction.getStringID(), playerName);
            }
            faction.setTeamLeaderID(player.m_20148_());
            faction.setTeamLeaderName(player.m_7755_().getString());
            FactionEvents.modifyTeam(((CommandSourceStack)context.getSource()).m_81372_(), faction.getStringID(), faction, ((CommandSourceStack)context.getSource()).m_230896_(), 0);
            FactionEvents.recruitsFactionManager.save(((CommandSourceStack)context.getSource()).m_81372_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("The Leader of " + faction.getTeamDisplayName() + " is now " + faction.getTeamLeaderName())), false);
            return 1;
        })))))).then(Commands.m_82127_((String)"diplomacyManager").then(Commands.m_82127_((String)"setRelations").then(Commands.m_82129_((String)"Faction1", (ArgumentType)TeamArgument.m_112088_()).then(Commands.m_82129_((String)"Faction2", (ArgumentType)TeamArgument.m_112088_()).then(Commands.m_82129_((String)"Relation", (ArgumentType)EnumArgument.enumArgument(RecruitsDiplomacyManager.DiplomacyStatus.class)).executes(context -> {
            PlayerTeam playerTeam1 = TeamArgument.m_112091_((CommandContext)context, (String)"Faction1");
            PlayerTeam playerTeam2 = TeamArgument.m_112091_((CommandContext)context, (String)"Faction2");
            RecruitsDiplomacyManager.DiplomacyStatus status = (RecruitsDiplomacyManager.DiplomacyStatus)((Object)((Object)context.getArgument("Relation", RecruitsDiplomacyManager.DiplomacyStatus.class)));
            if (playerTeam1.equals(playerTeam2)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Cannot set Diplomacy of same Faction!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (FactionEvents.recruitsDiplomacyManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"recruitsDiplomacyManager == null!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            FactionEvents.recruitsDiplomacyManager.setRelation(playerTeam1.m_5758_(), playerTeam2.m_5758_(), status, ((CommandSourceStack)context.getSource()).m_81372_());
            FactionEvents.recruitsDiplomacyManager.setRelation(playerTeam2.m_5758_(), playerTeam1.m_5758_(), status, ((CommandSourceStack)context.getSource()).m_81372_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(playerTeam1.m_5758_() + " and " + playerTeam2.m_5758_() + " are now " + status)), false);
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"claimManager").then(Commands.m_82127_((String)"getClaimAtPosition").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Claim: [" + claim + "]")), false);
            return 1;
        }))).then(Commands.m_82127_((String)"setAdminChunk").then(Commands.m_82129_((String)"isAdmin", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            boolean isAdmin = BoolArgumentType.getBool((CommandContext)ctx, (String)"isAdmin");
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            claim.setAdminClaim(isAdmin);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Claim [" + claim + "] is now set to admin = " + isAdmin)), false);
            ClaimEvents.recruitsClaimManager.broadcastClaimsToAll(((CommandSourceStack)ctx.getSource()).m_81372_());
            return 1;
        })))).then(Commands.m_82127_((String)"setHealth").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            claim.setHealth(amount);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Claim health was set to " + claim.getHealth())), false);
            ClaimEvents.recruitsClaimManager.broadcastClaimsToAll(((CommandSourceStack)ctx.getSource()).m_81372_());
            return 1;
        })))).then(Commands.m_82127_((String)"getHealth").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(claim + " has " + claim.getHealth() + "health")), false);
            return 1;
        }))).then(Commands.m_82127_((String)"setSiege").then(Commands.m_82129_((String)"siege", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            boolean siege = BoolArgumentType.getBool((CommandContext)ctx, (String)"siege");
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            claim.setAdminClaim(siege);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Claim [" + claim + "] is setSiege= " + siege)), false);
            ClaimEvents.recruitsClaimManager.broadcastClaimsToAll(((CommandSourceStack)ctx.getSource()).m_81372_());
            return 1;
        })))).then(Commands.m_82127_((String)"deleteClaim").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ChunkPos chunkPos = player.m_146902_();
            RecruitsClaim claim = RecruitsClaimManager.getClaimAt(chunkPos, ClaimEvents.recruitsClaimManager.getAllClaims().stream().toList());
            if (claim == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No claim found at your position."));
                return 0;
            }
            ClaimEvents.recruitsClaimManager.removeClaim(claim);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Claim [" + claim + "] is now deleted.")), false);
            ClaimEvents.recruitsClaimManager.broadcastClaimsToAll(((CommandSourceStack)ctx.getSource()).m_81372_());
            return 1;
        })))).then(Commands.m_82127_((String)"debugManager").then(Commands.m_82127_((String)"spawnFromEgg").then(Commands.m_82129_((String)"Amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"Amount");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
            if (player == null) {
                return 0;
            }
            ItemStack handItem = player.m_21205_();
            Item patt22833$temp = handItem.m_41720_();
            if (patt22833$temp instanceof RecruitsSpawnEgg) {
                RecruitsSpawnEgg recruitsSpawnEgg = (RecruitsSpawnEgg)patt22833$temp;
                BlockPos pos = player.m_20097_();
                EntityType<?> entitytype = recruitsSpawnEgg.m_43228_(handItem.m_41783_());
                ArrayList<AbstractRecruitEntity> recruitEntities = new ArrayList<AbstractRecruitEntity>();
                for (int i = 0; i < amount; ++i) {
                    Entity entity = entitytype.m_20615_((Level)serverLevel);
                    CompoundTag entityTag = handItem.m_41783_();
                    if (!(entity instanceof AbstractRecruitEntity)) continue;
                    AbstractRecruitEntity recruit = (AbstractRecruitEntity)entity;
                    if (entityTag == null) continue;
                    RecruitsSpawnEgg.fillRecruit(recruit, entityTag, pos);
                    recruitEntities.add((AbstractRecruitEntity)entity);
                }
                for (Entity entity : recruitEntities) {
                    serverLevel.m_7967_(entity);
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No Spawn Egg found!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nobleVillagerManager").then(Commands.m_82127_((String)"addNobleTrade").then(Commands.m_82129_((String)"Resource", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"MaxUses", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"VillagerNoble", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            int maxUses;
            RecruitsHireTrade hireTrade;
            VillagerNobleEntity nobleVillager;
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"VillagerNoble");
            if (entity instanceof VillagerNobleEntity) {
                nobleVillager = (VillagerNobleEntity)entity;
                ResourceLocation resourceLocation = ResourceLocationArgument.m_107011_((CommandContext)context, (String)"Resource");
                hireTrade = RecruitsHireTradesRegistry.getByResourceLocation(resourceLocation);
                if (hireTrade == null) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("No Trade for " + resourceLocation + " found!")));
                    return 0;
                }
                if (nobleVillager.hasTrade(resourceLocation)) {
                    nobleVillager.removeTrade(resourceLocation);
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Not a Noble Villager."));
                return 0;
            }
            hireTrade.maxUses = maxUses = IntegerArgumentType.getInteger((CommandContext)context, (String)"MaxUses");
            hireTrade.uses = maxUses;
            nobleVillager.addTrade(hireTrade);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Trade added!"), false);
            return 1;
        })))))).then(Commands.m_82127_((String)"refreshAllTrades").then(Commands.m_82129_((String)"VillagerNoble", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            List<RecruitsHireTrade> list;
            VillagerNobleEntity nobleVillager;
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"VillagerNoble");
            if (entity instanceof VillagerNobleEntity) {
                nobleVillager = (VillagerNobleEntity)entity;
                list = nobleVillager.getTrades();
                for (RecruitsHireTrade trade : list) {
                    trade.uses = trade.maxUses;
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Not a Noble Villager."));
                return 0;
            }
            nobleVillager.setTrades(list);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Trades refreshed!"), false);
            return 1;
        })))).then(Commands.m_82127_((String)"levelup").then(Commands.m_82129_((String)"VillagerNoble", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"VillagerNoble");
            if (!(entity instanceof VillagerNobleEntity)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Not a Noble Villager."));
                return 0;
            }
            VillagerNobleEntity nobleVillager = (VillagerNobleEntity)entity;
            nobleVillager.addTraderProgress(100);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Leveled up!"), false);
            return 1;
        })))).then(Commands.m_82127_((String)"removeNobleTrade").then(Commands.m_82129_((String)"Resource", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"VillagerNoble", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ResourceLocation resourceLocation;
            VillagerNobleEntity nobleVillager;
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"VillagerNoble");
            if (entity instanceof VillagerNobleEntity) {
                nobleVillager = (VillagerNobleEntity)entity;
                resourceLocation = ResourceLocationArgument.m_107011_((CommandContext)context, (String)"Resource");
                if (!nobleVillager.hasTrade(resourceLocation)) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("No Trade for " + resourceLocation + " found!")));
                    return 0;
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Not a Noble Villager."));
                return 0;
            }
            nobleVillager.removeTrade(resourceLocation);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Trade was removed!"), false);
            return 1;
        }))))));
        dispatcher.register(literalBuilder);
    }

    private static int tpToOwner(ServerLevel level, Collection<String> names) {
        List players = level.m_8795_(player -> names.contains(player.m_6302_()));
        ArrayList allEntities = new ArrayList();
        level.m_142646_().m_142273_().iterator().forEachRemaining(allEntities::add);
        List<AbstractRecruitEntity> recruits = allEntities.stream().filter(entity -> {
            AbstractRecruitEntity recruit;
            return entity instanceof AbstractRecruitEntity && (recruit = (AbstractRecruitEntity)((Object)entity)).isOwned();
        }).map(entity -> (AbstractRecruitEntity)((Object)entity)).toList();
        Map playerMap = players.stream().collect(Collectors.toMap(Entity::m_20148_, Function.identity()));
        for (AbstractRecruitEntity recruit : recruits) {
            ServerPlayer player2 = (ServerPlayer)playerMap.get(recruit.getOwnerUUID());
            if (player2 == null) continue;
            recruit.m_6021_(player2.m_20185_(), player2.m_20186_(), player2.m_20189_());
        }
        return 1;
    }

    private static int getUnitsCount(ServerPlayer player) {
        if (RecruitEvents.recruitsPlayerUnitManager != null) {
            return RecruitEvents.recruitsPlayerUnitManager.getRecruitCount(player.m_20148_());
        }
        return 0;
    }

    private static int setUnitsCount(CommandContext<CommandSourceStack> context, ServerPlayer player, int x) {
        if (RecruitEvents.recruitsPlayerUnitManager != null) {
            RecruitEvents.recruitsPlayerUnitManager.setRecruitCount((Player)player, x);
            RecruitEvents.recruitsPlayerUnitManager.save(((CommandSourceStack)context.getSource()).m_81372_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("The recruits count of " + player.m_7755_().getString() + " has been set to " + x + ".")), false);
            return 1;
        }
        return 0;
    }

    private static int setFactionNPCsCount(CommandContext<CommandSourceStack> context, RecruitsFaction faction, int x) {
        if (FactionEvents.recruitsFactionManager != null) {
            faction.setNPCs(x);
            FactionEvents.recruitsFactionManager.save(((CommandSourceStack)context.getSource()).m_81372_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("The npc count of " + faction.getStringID() + " has been set to " + x + ".")), false);
            return 1;
        }
        return 0;
    }
}

