/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RecruitsServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SERVER;
    public static ForgeConfigSpec.BooleanValue RecruitTablesPOIReleasing;
    public static ForgeConfigSpec.BooleanValue OverrideIronGolemSpawn;
    public static ForgeConfigSpec.BooleanValue PillagerFriendlyFire;
    public static ForgeConfigSpec.BooleanValue PillagerSpawn;
    public static ForgeConfigSpec.BooleanValue PillagerAttackMonsters;
    public static ForgeConfigSpec.BooleanValue ShouldPillagersRaidNaturally;
    public static ForgeConfigSpec.BooleanValue MonstersAttackPillagers;
    public static ForgeConfigSpec.IntValue MaxSpawnRecruitsInVillage;
    public static ForgeConfigSpec.IntValue MaxRecruitsForPlayer;
    public static ForgeConfigSpec.IntValue RecruitsMaxXpForLevelUp;
    public static ForgeConfigSpec.IntValue RecruitsMaxXpLevel;
    public static ForgeConfigSpec.BooleanValue PillagerIncreasedCombatRange;
    public static ForgeConfigSpec.BooleanValue VindicatorSpawnItems;
    public static ForgeConfigSpec.BooleanValue PillagerSpawnItems;
    public static ForgeConfigSpec.IntValue MaxAssassinCount;
    public static ForgeConfigSpec.IntValue RecruitCost;
    public static ForgeConfigSpec.IntValue BowmanCost;
    public static ForgeConfigSpec.IntValue ShieldmanCost;
    public static ForgeConfigSpec.IntValue NomadCost;
    public static ForgeConfigSpec.IntValue HorsemanCost;
    public static ForgeConfigSpec.IntValue CrossbowmanCost;
    public static ForgeConfigSpec.ConfigValue<List<String>> TargetBlackList;
    public static ForgeConfigSpec.ConfigValue<List<String>> MountWhiteList;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> RecruitStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> ShieldmanStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> BowmanStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> CrossbowmanStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> HorsemanStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> NomadStartEquipments;
    public static ForgeConfigSpec.ConfigValue<List<String>> AcceptedDamagesourceImmunity;
    public static ForgeConfigSpec.ConfigValue<List<String>> FoodBlackList;
    public static ForgeConfigSpec.BooleanValue ShouldRecruitPatrolsSpawn;
    public static ForgeConfigSpec.BooleanValue ShouldPillagerPatrolsSpawn;
    public static ForgeConfigSpec.DoubleValue RecruitPatrolsSpawnChance;
    public static ForgeConfigSpec.DoubleValue PillagerPatrolsSpawnChance;
    public static ForgeConfigSpec.ConfigValue<String> RecruitCurrency;
    public static ForgeConfigSpec.BooleanValue NoDamageImmunity;
    public static ForgeConfigSpec.IntValue PillagerPatrolSpawnInterval;
    public static ForgeConfigSpec.IntValue RecruitPatrolSpawnInterval;
    public static ForgeConfigSpec.IntValue RecruitPatrolDespawnTime;
    public static ForgeConfigSpec.IntValue FactionCreationCost;
    public static ForgeConfigSpec.BooleanValue GlobalTeamFriendlyFireSetting;
    public static ForgeConfigSpec.BooleanValue GlobalTeamSeeFriendlyInvisibleSetting;
    public static ForgeConfigSpec.BooleanValue GlobalTeamSetting;
    public static ForgeConfigSpec.BooleanValue RecruitHorseUnitsHorse;
    public static ForgeConfigSpec.BooleanValue RangedRecruitsNeedArrowsToShoot;
    public static ForgeConfigSpec.BooleanValue RecruitsChunkLoading;
    public static ForgeConfigSpec.BooleanValue UpdateCheckerServerside;
    public static ForgeConfigSpec.BooleanValue CompatCorpseMod;
    public static ForgeConfigSpec.BooleanValue UseAsyncPathfinding;
    public static ForgeConfigSpec.IntValue AsyncPathfindingThreadsCount;
    public static ForgeConfigSpec.BooleanValue UseAsyncTargetFinding;
    public static ForgeConfigSpec.IntValue AsyncTargetFindingThreadsCount;
    public static ForgeConfigSpec.IntValue MaxPlayersInFaction;
    public static ForgeConfigSpec.IntValue MaxNPCsInFaction;
    public static ForgeConfigSpec.BooleanValue ShouldFactionEditingBeAllowed;
    public static ForgeConfigSpec.BooleanValue ShouldFactionManagingBeAllowed;
    public static ForgeConfigSpec.BooleanValue AllowArrowCleaning;
    public static ForgeConfigSpec.BooleanValue RecruitsPayment;
    public static ForgeConfigSpec.IntValue RecruitsPaymentInterval;
    public static ForgeConfigSpec.IntValue RecruitsPaymentAmount;
    public static ForgeConfigSpec.EnumValue<AbstractRecruitEntity.NoPaymentAction> RecruitsNoPaymentAction;
    public static ForgeConfigSpec.BooleanValue QuickStartPillagerRaid;
    public static ForgeConfigSpec.BooleanValue BlockPlacingBreakingOnlyWhenClaimed;
    public static ForgeConfigSpec.BooleanValue ExplosionProtectionInClaims;
    public static ForgeConfigSpec.BooleanValue CascadeThePriceOfClaims;
    public static ForgeConfigSpec.IntValue ClaimingCost;
    public static ForgeConfigSpec.IntValue ChunkCost;
    public static ForgeConfigSpec.IntValue SiegeClaimsRecruitsAmount;
    public static ForgeConfigSpec.IntValue SiegeClaimsConquerTime;
    public static ForgeConfigSpec.BooleanValue NobleVillagerNeedsVillagers;
    public static ForgeConfigSpec.BooleanValue ShouldProfessionBlocksTrade;
    public static ForgeConfigSpec.BooleanValue NobleVillagerSpawn;
    public static ForgeConfigSpec.BooleanValue AllowClaiming;
    public static ArrayList<String> TARGET_BLACKLIST;
    public static ArrayList<String> FOOD_BLACKLIST;
    public static ArrayList<String> MOUNTS;
    public static ArrayList<List<String>> START_EQUIPMENT_RECRUIT;
    public static ArrayList<List<String>> START_EQUIPMENT_SHIELDMAN;
    public static ArrayList<List<String>> START_EQUIPMENT_HORSEMAN;
    public static ArrayList<List<String>> START_EQUIPMENT_BOWMAN;
    public static ArrayList<List<String>> START_EQUIPMENT_NOMAD;
    public static ArrayList<List<String>> START_EQUIPMENT_CROSSBOWMAN;
    public static ArrayList<String> DAMAGESOURCE;
    public static ArrayList<String> list;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        TARGET_BLACKLIST = new ArrayList<String>(Arrays.asList("minecraft:creeper", "minecraft:ghast", "minecraft:enderman", "minecraft:zombified_piglin", "corpse:corpse", "minecraft:armorstand"));
        FOOD_BLACKLIST = new ArrayList<String>(Arrays.asList("minecraft:poisonous_potato", "minecraft:spider_eye", "minecraft:pufferfish"));
        MOUNTS = new ArrayList<String>(Arrays.asList("minecraft:mule", "minecraft:donkey", "minecraft:horse", "minecraft:llama", "minecraft:pig", "minecraft:boat", "minecraft:minecart", "smallships:cog", "smallships:brigg", "smallships:galley", "smallships:drakkar", "camels:camel"));
        START_EQUIPMENT_RECRUIT = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:wooden_sword", "", "", "", "", ""), Arrays.asList("minecraft:stone_sword", "", "", "", "", "")));
        START_EQUIPMENT_SHIELDMAN = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:stone_sword", "minecraft:shield", "", "", "", ""), Arrays.asList("minecraft:wooden_axe", "minecraft:shield", "", "", "", "")));
        START_EQUIPMENT_HORSEMAN = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:stone_sword", "minecraft:shield", "", "", "", ""), Arrays.asList("minecraft:iron_sword", "minecraft:shield", "", "", "", "")));
        START_EQUIPMENT_BOWMAN = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:bow", "", "", "", "", "")));
        START_EQUIPMENT_NOMAD = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:bow", "", "", "", "", "")));
        START_EQUIPMENT_CROSSBOWMAN = new ArrayList<List<String>>(List.of(Arrays.asList("minecraft:crossbow", "", "", "", "", "")));
        DAMAGESOURCE = new ArrayList<String>(Arrays.asList("inFire", "lava", "sweetBerryBush", "cactus", "lightningBolt", "inWall", "hotFloor", "outOfWorld", "drown"));
        list = new ArrayList();
        BUILDER.comment("Recruits Config:").push("Recruits");
        UpdateCheckerServerside = BUILDER.comment("\nUpdateCheckerServerside\n\t(takes effect after restart)\n\t\nShould the client side update checker be active?\nIt is recommended to keep it enabled to receive information about new bug fixes and features.\"\"\ndefault: true").worldRestart().define("UpdateCheckerServerside", true);
        RecruitCurrency = BUILDER.comment("\nCurrency\n\t(takes effect after restart)\n\tThe Item defined here, will be used to hire recruits. For example: [\"minecraft:diamond\"]\tdefault: [\"minecraft:emerald\"]").worldRestart().define("RecruitCurrency", (Object)"minecraft:emerald");
        RecruitsMaxXpForLevelUp = BUILDER.comment("\nMax XP a Recruit needs to Level Up.\n\t(takes effect after restart)\n\tdefault: 250").worldRestart().defineInRange("RecruitsMaxXpForLevelUp", 250, 50, 14530);
        RecruitsMaxXpLevel = BUILDER.comment("\nThe max. Level a recruit can get.-\n\t(takes effect after restart)\n\tdefault: 20").worldRestart().defineInRange("RecruitsMaxXpLevel", 20, 10, 1453);
        MaxRecruitsForPlayer = BUILDER.comment("\nMax amount a normal player can recruit (Faction Leaders are limited to a different setting)\n\t(takes effect after restart)\n\tdefault: 100").worldRestart().defineInRange("MaxRecruitsForPlayer", 100, 1, 1453);
        TargetBlackList = BUILDER.comment("\nTarget Blacklist\n\t(takes effect after restart)\n\tEntities in this list won't be targeted at all, for example: [\"minecraft:creeper\", \"minecraft:sheep\", ...]").worldRestart().define("TargetBlackList", TARGET_BLACKLIST);
        FoodBlackList = BUILDER.comment("\nList of foods that recruits should not eat.\n\t(takes effect after restart)\n\tFood items in this list will not be eaten by recruits and also not be picked up from upkeep.").worldRestart().define("FoodBlackList", FOOD_BLACKLIST);
        MountWhiteList = BUILDER.comment("\nMount Whitelist\n\t(takes effect after restart)\n\tONLY Entities in this list can be mounted by a recruit, for example: [\"minecraft:boat\", \"smallships:cog\", ...]").worldRestart().define("MountWhitelist", MOUNTS);
        RecruitCost = BUILDER.comment("\nThe amount of currency required to hire a recruit.\n\t(takes effect after restart)\n\tdefault: 4").worldRestart().defineInRange("RecruitCost", 4, 0, 1453);
        BowmanCost = BUILDER.comment("\nThe amount of currency required to hire a bowman.\n\t(takes effect after restart)\n\tdefault: 6").worldRestart().defineInRange("BowmanCost", 6, 0, 1453);
        CrossbowmanCost = BUILDER.comment("\nThe amount of currency required to hire a crossbowman.\n\t(takes effect after restart)\n\tdefault: 8").worldRestart().defineInRange("CrossbowmanCost", 8, 0, 1453);
        ShieldmanCost = BUILDER.comment("\nThe amount of currency required to hire a shieldman.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("ShieldmanCost", 10, 0, 1453);
        HorsemanCost = BUILDER.comment("\nThe amount of currency required to hire a horseman.\n\t(takes effect after restart)\n\tdefault: 20").worldRestart().defineInRange("HorsemanCost", 20, 0, 1453);
        NomadCost = BUILDER.comment("\nThe amount of currency required to hire a nomad.\n\t(takes effect after restart)\n\tdefault: 19").worldRestart().defineInRange("NomadCost", 19, 0, 1453);
        RecruitsPayment = BUILDER.comment("\nRecruitsPayment\n\t(takes effect after restart)\n\t\nShould recruits need to be payed in intervals?\ndefault: false").worldRestart().define("RecruitsPayment", false);
        RecruitsPaymentInterval = BUILDER.comment("\nRecruitsPaymentInterval\n\t(takes effect after restart)\n\t\nThe interval in minutes recruits need to be payed?\ndefault: 15").worldRestart().defineInRange("RecruitsPaymentInterval", 15, 1, 1453);
        RecruitsPaymentAmount = BUILDER.comment("\nRecruitsPaymentAmount\n\t(takes effect after restart)\n\t\nThe amount of currency recruits need to be payed?\ndefault: 1").worldRestart().defineInRange("RecruitsPaymentAmount", 1, 1, 1453);
        RecruitsNoPaymentAction = BUILDER.comment("\nRecruitsNoPaymentAction\n\t(takes effect after restart)\n\t\nThe action the recruits will do when they don't get payed.\ndefault: MORALE_LOSS").worldRestart().defineEnum("RecruitsNoPaymentAction", (Enum)AbstractRecruitEntity.NoPaymentAction.MORALE_LOSS);
        RecruitHorseUnitsHorse = BUILDER.comment("\nRecruitHorseUnitsHorse\n\t(takes effect after restart)\n\t\nShould the Horse units spawn with a horse?\"\"\ndefault: true").worldRestart().define("RecruitHorseUnitsHorse", true);
        RangedRecruitsNeedArrowsToShoot = BUILDER.comment("\nRangedRecruitsNeedArrowsToShoot\n\t(takes effect after restart)\n\t\nShould ranged units need arrows to shoot?\nIf enabled ranged units will resupply arrows from upkeep chest and spawn with arrows.\n\"\"\ndefault: false").worldRestart().define("RangedRecruitsNeedArrowsToShoot", false);
        RecruitsChunkLoading = BUILDER.comment("RecruitsChunkLoading\n\t(takes effect after restart)\n\t\nShould recruit-companions load chunks? Disabling would make patrolling in to unloaded chunk impossible.\ndefault: true").worldRestart().define("RecruitsChunkLoading", true);
        BUILDER.pop();
        BUILDER.comment("Recruit Village Config:").push("Villages");
        RecruitTablesPOIReleasing = BUILDER.comment("\nShould Villager Recruits that were created with Tables release the POI for other Villagers?\nTrue -> allows multiple villagers to become a recruit with one table.\nFalse -> only one villager can become a recruit with one table.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("RecruitTablesPOIReleasing", true);
        NobleVillagerSpawn = BUILDER.comment("\nDoes a Villager decide to become noble? Condition: 7 Villagers and no Noble Villager nearby\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("NobleVillagerSpawns", true);
        NobleVillagerNeedsVillagers = BUILDER.comment("\nDoes the Noble Villager need Villagers in the area to spawn a Recruit?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("NobleVillagerNeedsVillagers", true);
        ShouldProfessionBlocksTrade = BUILDER.comment("\nShould Recruits Profession Blocks be traded by Villagers?\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("ShouldProfessionBlocksTrade", false);
        OverrideIronGolemSpawn = BUILDER.comment("\nShould Recruits instead of Iron Golems spawn in Villages\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("OverrideIronGolemSpawn", true);
        MaxSpawnRecruitsInVillage = BUILDER.comment("\nMax Recruits in a Village Chunk to Spawn\n\t(takes effect after restart)\n\tdefault: 1").worldRestart().defineInRange("MaxSpawnRecruitsInVillage", 1, 1, 1453);
        BUILDER.pop();
        BUILDER.comment("Recruits Equipment Config:").push("Equipments");
        BUILDER.comment("\nFollowing lists will be used to generate starting armor for different recruit types. Each recruit will be equipped according to a random equipment-set defined below.\n\nTo create a equipment-set note the following order: [\"main-hand\", \"off-hand\", \"feet\", \"legs\", \"chest\", \"head\"]\nEach set has ONLY 6 entries. Each set is separated with square brackets: RecruitStartEquipments=[[1], [2], [3], ...].\nFor example, the following configuration will randomize newly spawned recruits either 1 or 2:\n    1. full leather armor set with wooden sword and shield.\n    2. only gold sword.\n\n    RecruitStartEquipments=[[\"minecraft:wooden_sword\", \"minecraft:shield\",\"minecraft:leather_boots\",\"minecraft:leather_leggings\",\"minecraft:leather_chestplate\", \"minecraft:leather_helmet\"], [\"minecraft:gold_sword\", \"\", \"\", \"\", \"\", \"\"]]\n\nThere is no limit of armor-sets and modded armor / weapons are also compatible. The mod item-id can be accessed with /give-command.\n");
        RecruitStartEquipments = BUILDER.comment("\nRecruit Start Equipments\nDefault:  [[\"minecraft:wooden_sword\", \"\", \"\", \"\", \"\", \"\"], [\"minecraft:stone_sword\", \"\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("RecruitStartEquipments", START_EQUIPMENT_RECRUIT);
        ShieldmanStartEquipments = BUILDER.comment("\nShieldman Start Equipments\nDefault: [[\"minecraft:stone_sword\", \"minecraft:shield\", \"\", \"\", \"\", \"\"], [\"minecraft:wooden_axe\", \"minecraft:shield\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("ShieldmanStartEquipments", START_EQUIPMENT_SHIELDMAN);
        BowmanStartEquipments = BUILDER.comment("\nBowman Start Equipments\nDefault: [[\"minecraft:bow\", \"\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("BowmanStartEquipments", START_EQUIPMENT_BOWMAN);
        CrossbowmanStartEquipments = BUILDER.comment("\nCrossbowman Start Equipments\nDefault: [[\"minecraft:crossbow\", \"\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("CrossbowmanStartEquipments", START_EQUIPMENT_CROSSBOWMAN);
        HorsemanStartEquipments = BUILDER.comment("\nHorseman Start Equipments\nDefault: [[\"minecraft:stone_sword\", \"minecraft:shield\", \"\", \"\", \"\", \"\"], [\"minecraft:iron_sword\", \"minecraft:shield\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("HorsemanStartEquipments", START_EQUIPMENT_HORSEMAN);
        NomadStartEquipments = BUILDER.comment("\nNomad Start Equipments\nDefault: [[\"minecraft:bow\", \"\", \"\", \"\", \"\", \"\"]]\n").worldRestart().define("NomadStartEquipments", START_EQUIPMENT_NOMAD);
        BUILDER.pop();
        BUILDER.comment("Monster and Pillager Config:").push("Hostiles");
        PillagerFriendlyFire = BUILDER.comment("\nShould Pillagers do friendly fire\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("PillagerFriendlyFire", true);
        PillagerSpawn = BUILDER.comment("\nShould Pillagers spawn naturally\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("PillagerSpawn", false);
        PillagerAttackMonsters = BUILDER.comment("\nShould Pillagers attack Monsters\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("PillagerAttackMonsters", false);
        MonstersAttackPillagers = BUILDER.comment("\nShould Monsters attack Pillagers\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("MonstersAttackPillagers", false);
        ShouldPillagersRaidNaturally = BUILDER.comment("\nShould Pillagers attack all Living\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("ShouldPillagersRaidNaturally", false);
        PillagerIncreasedCombatRange = BUILDER.comment("\nShould Pillagers have increased Combat Range, so they can shoot from far away.\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("PillagerIncreasedCombatRange", false);
        VindicatorSpawnItems = BUILDER.comment("\nShould Vindicators can spawn with shield and sword and AI to use these.\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("VindicatorSpawnItems", false);
        PillagerSpawnItems = BUILDER.comment("\nShould Pillagers can spawn with shield and sword and AI to use these.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("PillagerSpawnItems", false);
        QuickStartPillagerRaid = BUILDER.comment("\nShould the player that burns a ominous banner item get the \"Bad Omen\" effect?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("QuickStartPillagerRaid", true);
        BUILDER.pop();
        BUILDER.comment("Recruit Patrols Config:").push("Patrols");
        ShouldRecruitPatrolsSpawn = BUILDER.comment("\nShould Recruits spawn as Patrols in the world?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("ShouldRecruitPatrolsSpawn", true);
        RecruitPatrolsSpawnChance = BUILDER.comment("\nChance that a Recruit Patrol can spawn. (higher values = higher chance to spawn)\n\t(takes effect after restart)\n\tdefault: 15.0").worldRestart().defineInRange("RecruitPatrolsSpawnChance", 15.0, 0.0, 100.0);
        RecruitPatrolSpawnInterval = BUILDER.comment("\nThe interval in minutes a Recruit Patrol and Caravan can spawn.\n\t(takes effect after restart)\n\tdefault: 30").worldRestart().defineInRange("RecruitPatrolSpawnInterval", 30, 1, 60);
        RecruitPatrolDespawnTime = BUILDER.comment("\nThe time in minutes a Recruit Patrol and Caravan will despawn.\n\t(takes effect after restart)\n\tdefault: 45").worldRestart().defineInRange("RecruitPatrolDespawnTime", 45, 1, 1453);
        ShouldPillagerPatrolsSpawn = BUILDER.comment("\nShould modded Pillager Patrols spawn in the world?\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("ShouldPillagerPatrolsSpawn", false);
        PillagerPatrolsSpawnChance = BUILDER.comment("\nChance that a modded Pillager Patrol can spawn. (higher values = higher chance to spawn)\n\t(takes effect after restart)\n\tdefault: 25.0").worldRestart().defineInRange("PillagerPatrolsSpawnChance", 25.0, 0.0, 100.0);
        PillagerPatrolSpawnInterval = BUILDER.comment("\nThe interval in minutes a Pillager Patrol can spawn.\n\t(takes effect after restart)\n\tdefault: 45").worldRestart().defineInRange("PillagerPatrolSpawnInterval", 45, 1, 60);
        BUILDER.pop();
        BUILDER.comment("General Damage Config:").push("Damage");
        NoDamageImmunity = BUILDER.comment("No damage Immunity\n\tShould Immunity between hits be disabled?\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("NoDamageImmunity", false);
        AcceptedDamagesourceImmunity = BUILDER.comment("List of damagesource that accept immunity\n\t(takes effect after restart)\n\tDamagesource in this list will apply a immunity of 0.5s to the entity like normal.").worldRestart().define("AcceptedDamagesourceImmunity", DAMAGESOURCE);
        BUILDER.pop();
        BUILDER.comment("Recruit Faction Config:").push("Factions");
        FactionCreationCost = BUILDER.comment("\nThe amount of currency needed to create a faction. Set 0 to disable.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("FactionCreationCost", 10, 0, 1453);
        MaxPlayersInFaction = BUILDER.comment("\nThe amount of players allowed in a faction. Set 0 for infinite.\n\t(takes effect after restart)\n\tdefault: 5").worldRestart().defineInRange("MaxPlayersInFaction", 5, 0, 1453);
        MaxNPCsInFaction = BUILDER.comment("\nThe amount of recruits allowed in a faction. Set 0 for infinite.\n\t(takes effect after restart)\n\tdefault: 500").worldRestart().defineInRange("MaxNPCsInFaction", 500, 0, 1453);
        ShouldFactionEditingBeAllowed = BUILDER.comment("\nShould editing the faction be allowed by their leaders. (Editing Faction Colors, Name ,...)\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("ShouldFactionEditingBeAllowed", true);
        ShouldFactionManagingBeAllowed = BUILDER.comment("\nShould managing the faction be allowed by their leaders. (Add/Remove Players...)\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("ShouldFactionManagingBeAllowed", true);
        BUILDER.comment("Global Faction/Team Settings").push("Global Faction/Team Settings");
        GlobalTeamSetting = BUILDER.comment("\nShould Recruits override following team settings on world start for all factions?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("GlobalTeamSetting", true);
        GlobalTeamFriendlyFireSetting = BUILDER.comment("Override Friendly fire true/false for all factions on world start\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("GlobalTeamFriendlyFireSetting", false);
        GlobalTeamSeeFriendlyInvisibleSetting = BUILDER.comment("Override SeeFriendlyInvisible true/false for all factions on world start.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("GlobalTeamSeeFriendlyInvisibleSetting", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("Recruit Mod compatibility Config:").push("Compat");
        CompatCorpseMod = BUILDER.comment("This feature is only possible when corpse-mod is installed. Not possible when rpgz-mod is loaded.\nShould recruits spawn corpse of corpse-mod when dead?.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("CompatCorpseMod", true);
        BUILDER.pop();
        BUILDER.comment("Recruit Mod performance Config:").push("Performance");
        AllowArrowCleaning = BUILDER.comment("This feature is cleans up unnecessary Arrows from ground that are eating client and server performance.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("AllowArrowCleaning", true);
        BUILDER.comment("Async Settings").push("Async");
        UseAsyncPathfinding = BUILDER.comment("Use asynchronous pathfinding run on multithread executor.\nImproves TPS on huge numbers of recruits (and somehow FPS) a lot,\n    but useless if machine has only one physical core available.\nCan lead to some small delays in path finding.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("UsePathfindingAsync", true);
        AsyncPathfindingThreadsCount = BUILDER.comment("How much threads to use for pathfinding.\nNeeds to be calibrated manually.\nUsually good value is n/4, where n is amount of logical cores (threads) you have on CPU.\n\t(takes effect after restart)\n\tdefault: 1").worldRestart().defineInRange("AsyncPathfindingThreads", 1, 1, Runtime.getRuntime().availableProcessors());
        UseAsyncTargetFinding = BUILDER.comment("Use asynchronous target finding run on multithread executor.\nImproves TPS on huge numbers of recruits (and somehow FPS) a lot,\n    but useless if machine has only one physical core available.\nCan lead to some small delays in target finding (recruits finding who to attack),\n    but I have seen none of case when I was testing so should work fine.\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("UseTargetFindingAsync", true);
        AsyncTargetFindingThreadsCount = BUILDER.comment("How much threads to use for target finding.\nNeeds to be calibrated manually.\nUsually good value is n/6, where n is amount of logical cores (threads) you have on CPU.\n\t(takes effect after restart)\n\tdefault: 1").worldRestart().defineInRange("AsyncTargetFindingThreads", 1, 1, Runtime.getRuntime().availableProcessors());
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("Claiming Config:").push("Claiming");
        AllowClaiming = BUILDER.comment("Should the claiming feature be allowed?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("AllowClaiming", true);
        ClaimingCost = BUILDER.comment("The amount of currency that claiming a 5x5 area of chunk should cost.\n\t(takes effect after restart)\n\tdefault: 64").worldRestart().defineInRange("ClaimingCost", 64, 0, 1453);
        ChunkCost = BUILDER.comment("The amount of currency that increasing the claim by a chunk should cost.\n\t(takes effect after restart)\n\tdefault: 20").worldRestart().defineInRange("ChunkCost", 15, 0, 1453);
        CascadeThePriceOfClaims = BUILDER.comment("Should the price of claiming an area increase by the specified amount?\nExample: 1 Faction has already one Claim, the second would cost 2 x 64 = 128.\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("CascadeThePriceOfClaims", false);
        BlockPlacingBreakingOnlyWhenClaimed = BUILDER.comment("Should block breaking and placing for players only be possible when the chunk is claimed by the faction.\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("BlockPlacingBreakingOnlyWhenClaimed", false);
        ExplosionProtectionInClaims = BUILDER.comment("Should claims be protected from explosions.\n\t(takes effect after restart)\n\tdefault: false").worldRestart().define("ExplosionBreaksBlocksInClaims", false);
        SiegeClaimsRecruitsAmount = BUILDER.comment("The amount of man power that is required to start a siege on a Claim.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("SiegeClaimsRecruitsAmount", 10, 0, 1453);
        SiegeClaimsConquerTime = BUILDER.comment("The time in minutes that is required to conquer a Claim.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("SiegeClaimsConquerTime", 10, 0, 1453);
        SERVER = BUILDER.build();
    }
}

