/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import com.talhanation.recruits.entities.IStrategicFire;
import com.talhanation.recruits.entities.ai.RecruitMoveTowardsTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitRangedBowAttackGoal;
import com.talhanation.recruits.entities.ai.RecruitStrategicFire;
import com.talhanation.recruits.util.AttackUtil;
import com.talhanation.recruits.world.RecruitsPatrolSpawn;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class BowmanEntity
extends AbstractRecruitEntity
implements IRangedRecruit,
IStrategicFire {
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());
    private static final EntityDataAccessor<Optional<BlockPos>> STRATEGIC_FIRE_POS = SynchedEntityData.m_135353_(BowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SHOULD_STRATEGIC_FIRE = SynchedEntityData.m_135353_(BowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BowmanEntity(EntityType<? extends AbstractRecruitEntity> entityType, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STRATEGIC_FIRE_POS, Optional.empty());
        this.f_19804_.m_135372_(SHOULD_STRATEGIC_FIRE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.StrategicFirePos() != null) {
            nbt.m_128405_("StrategicFirePosX", this.StrategicFirePos().m_123341_());
            nbt.m_128405_("StrategicFirePosY", this.StrategicFirePos().m_123342_());
            nbt.m_128405_("StrategicFirePosZ", this.StrategicFirePos().m_123343_());
            nbt.m_128379_("ShouldStrategicFire", this.getShouldStrategicFire());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("StrategicFirePosX") && nbt.m_128441_("StrategicFirePosY") && nbt.m_128441_("StrategicFirePosZ")) {
            this.setStrategicFirePos(new BlockPos(nbt.m_128451_("StrategicFirePosX"), nbt.m_128451_("StrategicFirePosY"), nbt.m_128451_("StrategicFirePosZ")));
            this.setShouldStrategicFire(nbt.m_128471_("ShouldStrategicFire"));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RecruitStrategicFire(this, 10, 20));
        this.f_21345_.m_25352_(4, new RecruitRangedBowAttackGoal<BowmanEntity>(this, 1.15, 10, 20, 44.0f, this.getMeleeStartRange()));
        this.f_21345_.m_25352_(8, (Goal)new RecruitMoveTowardsTargetGoal(this, 1.15, (float)this.getMeleeStartRange()));
    }

    @Override
    public double getMeleeStartRange() {
        return 5.0;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 0.05).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 64.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        RandomSource randomsource = world.m_213780_();
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        this.m_213946_(randomsource, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.m_6593_((Component)Component.m_237113_((String)"Bowman"));
        this.setCost((Integer)RecruitsServerConfig.BowmanCost.get());
        this.setEquipment();
        this.setRandomSpawnBonus();
        this.m_21530_();
        if (((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
            RecruitsPatrolSpawn.setRangedArrows(this);
        }
        AbstractRecruitEntity.applySpawnValues(this);
    }

    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof SwordItem) && !(itemStack.m_41720_() instanceof ShieldItem) && !(itemStack.m_41720_() instanceof CrossbowItem);
    }

    public void m_6504_(@NotNull LivingEntity target, float v) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            int k;
            int fireLevel;
            if (AttackUtil.canPerformHorseAttack(this, target) && target.m_20202_() instanceof LivingEntity) {
                target = (LivingEntity)target.m_20202_();
            }
            ItemStack itemstack = this.m_6298_(this.m_21120_(InteractionHand.MAIN_HAND));
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)v);
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemstack);
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5 + this.arrowDamageModifier());
            int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemstack);
            if (punchLevel > 0) {
                arrow.m_36735_(punchLevel);
            }
            if ((fireLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemstack)) > 0) {
                arrow.m_20254_(100);
            }
            double distance = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double heightDiff = target.m_20186_() - this.m_20186_();
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20186_() - arrow.m_20186_() + (double)target.m_20192_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            double angle = IRangedRecruit.getAngleDistanceModifier(distance, 47, 4) + IRangedRecruit.getAngleHeightModifier(distance, heightDiff, 1.0) / 100.0;
            float force = 1.9f + IRangedRecruit.getForceDistanceModifier(distance, 1.9f);
            double morale = this.getMorale();
            float accuracy = Math.max(6.0f - (float)((double)0.1f * morale), 0.0f);
            arrow.m_6686_(d0, d1 + d3 * angle, d2, force, accuracy);
            if (((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue() && (k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)this.m_21205_())) == 0) {
                this.consumeArrow();
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_20193_().m_7967_((Entity)arrow);
            this.damageMainHandItem();
        }
    }

    public double arrowDamageModifier() {
        return 1.0;
    }

    public void performRangedAttackXYZ(double x, double y, double z, float v, float angle, float force) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            int fireLevel;
            int punchLevel;
            ItemStack itemstack = this.m_6298_(this.m_21120_(InteractionHand.MAIN_HAND));
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)v);
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemstack);
            if (powerLevel > 0) {
                arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5 + this.arrowDamageModifier());
            }
            if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemstack)) > 0) {
                arrow.m_36735_(punchLevel);
            }
            if ((fireLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemstack)) > 0) {
                arrow.m_20254_(100);
            }
            double d0 = x - this.m_20185_();
            double d1 = y - this.m_20186_();
            double d2 = z - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            double morale = this.getMorale();
            float accuracy = 3.0f + Math.max(6.0f - (float)((double)0.1f * morale), 0.0f);
            arrow.m_6686_(d0, d1 + d3 + (double)angle, d2, force + 1.95f, accuracy);
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_20193_().m_7967_((Entity)arrow);
            if (((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
                this.consumeArrow();
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            this.damageMainHandItem();
        }
    }

    public void fleeEntity(LivingEntity target) {
        if (target != null) {
            double fleeDistance = 10.0;
            Vec3 vecTarget = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
            Vec3 vecBowman = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 fleeDir = vecBowman.m_82546_(vecTarget);
            fleeDir = fleeDir.m_82541_();
            double rnd = this.m_217043_().m_188583_() * 1.2;
            Vec3 fleePos = new Vec3(vecBowman.f_82479_ + rnd + fleeDir.f_82479_ * fleeDistance, vecBowman.f_82480_ + fleeDir.f_82480_ * fleeDistance, vecBowman.f_82481_ + rnd + fleeDir.f_82481_ * fleeDistance);
            this.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 1.1);
        }
    }

    @Override
    public void setStrategicFirePos(BlockPos pos) {
        if (pos != null) {
            this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.of(pos));
        } else {
            this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.empty());
        }
    }

    public BlockPos StrategicFirePos() {
        return ((Optional)this.f_19804_.m_135370_(STRATEGIC_FIRE_POS)).orElse(null);
    }

    public void clearArrowsPos() {
        this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.empty());
    }

    @Override
    public void setShouldStrategicFire(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_STRATEGIC_FIRE, (Object)bool);
    }

    public boolean getShouldStrategicFire() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_STRATEGIC_FIRE);
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if ((itemStack.m_41720_() instanceof BowItem || itemStack.m_41720_() instanceof ProjectileWeaponItem || itemStack.m_41720_() instanceof SwordItem) && this.m_21205_().m_41619_()) {
            return !this.hasSameTypeOfItem(itemStack);
        }
        if (itemStack.m_204117_(ItemTags.f_13161_) && ((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
            return true;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public List<List<String>> getEquipment() {
        return (List)RecruitsServerConfig.BowmanStartEquipments.get();
    }

    @Override
    public Predicate<ItemStack> getWeaponType() {
        return itemStack -> itemStack.m_41720_() instanceof BowItem;
    }
}

