/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.HorsemanEntity;
import com.talhanation.recruits.util.AttackUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HorsemanAttackAI
extends Goal {
    private final HorsemanEntity horseman;
    private LivingEntity target;
    private HorsemanEntity.State state;
    private BlockPos movePos;
    private int vecRotation = 0;
    private byte timeOut = 0;
    private BlockPos prevPos;

    public HorsemanAttackAI(HorsemanEntity recruit) {
        this.horseman = recruit;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.horseman.m_20202_() instanceof AbstractHorse && this.horseman.getFollowState() == 0 && !this.horseman.needsToGetFood() && !this.horseman.getShouldMount();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.target = this.horseman.m_5448_();
        this.state = HorsemanEntity.State.SELECT_TARGET;
    }

    public void m_8037_() {
        if (this.horseman.f_19797_ % 15 == 0) {
            this.prevPos = this.horseman.m_20097_();
        }
        switch (this.state) {
            case SELECT_TARGET: {
                this.target = this.horseman.m_5448_();
                if (this.target == null) break;
                Vec3 moveVec = this.target.m_20182_().m_82546_(this.horseman.m_20182_()).m_82541_();
                Vec3 movePosVec = this.target.m_20182_().m_82549_(moveVec.m_82490_(10.0)).m_82524_((float)this.vecRotation);
                BlockPos possibleMovePosVec = new BlockPos((int)movePosVec.f_82479_, (int)this.horseman.m_20182_().f_82480_, (int)movePosVec.f_82481_);
                if (this.isFreeSpotAbove(this.target.m_20097_())) {
                    this.movePos = possibleMovePosVec;
                    this.vecRotation = 0;
                    this.state = HorsemanEntity.State.CHARGE_TARGET;
                    break;
                }
                if (this.vecRotation > 360) {
                    this.vecRotation += 15;
                    break;
                }
                this.m_8041_();
                break;
            }
            case CHARGE_TARGET: {
                if (this.isStuck() || this.target == null || !this.target.m_6084_() || !this.isFreeSpotAbove(this.target.m_20097_())) {
                    this.state = HorsemanEntity.State.SELECT_TARGET;
                    this.prevPos = null;
                    return;
                }
                double distance = this.horseman.m_20280_((Entity)this.target);
                if (distance > 5.0) {
                    this.horseman.m_21573_().m_26519_(this.target.m_20182_().f_82479_, this.target.m_20182_().f_82480_, this.target.m_20182_().f_82481_, (double)1.15f);
                } else {
                    this.state = HorsemanEntity.State.MOVE_TO_POS;
                }
                this.horseman.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                AttackUtil.checkAndPerformAttack(distance, AttackUtil.getAttackReachSqr((LivingEntity)this.horseman), this.horseman, this.target);
                if (this.isStuck()) {
                    this.removeLeaves();
                    break;
                }
                this.knockback();
                break;
            }
            case MOVE_TO_POS: {
                if (this.isStuck() || this.target == null || !this.target.m_6084_() || !this.isFreeSpotAbove(this.target.m_20097_())) {
                    this.state = HorsemanEntity.State.SELECT_TARGET;
                    this.prevPos = null;
                    return;
                }
                Vec3 movePos2 = new Vec3((double)this.movePos.m_123341_(), this.horseman.m_20182_().f_82480_, (double)this.movePos.m_123343_());
                this.horseman.m_21563_().m_24964_(movePos2);
                this.horseman.m_21573_().m_26519_(movePos2.f_82479_, movePos2.f_82480_, movePos2.f_82481_, (double)1.15f);
                if (this.horseman.m_20238_(movePos2) < 6.0 || (this.timeOut = (byte)(this.timeOut + 1)) > 126) {
                    this.timeOut = 0;
                    this.state = HorsemanEntity.State.SELECT_TARGET;
                    this.prevPos = null;
                }
                if (this.isStuck()) {
                    this.removeLeaves();
                    break;
                }
                this.knockback();
            }
        }
    }

    private void removeLeaves() {
        BlockState state = this.horseman.m_20193_().m_8055_(this.horseman.m_20097_().m_6630_(1));
        if (state.m_60734_() instanceof LeavesBlock) {
            this.horseman.m_20193_().m_46961_(this.horseman.m_20097_().m_6630_(1), true);
        }
    }

    private boolean isStuck() {
        return this.prevPos != null && this.prevPos.equals((Object)this.horseman.m_20097_());
    }

    private boolean isFreeSpotAbove(BlockPos pos) {
        BlockState state = this.horseman.m_20193_().m_8055_(pos.m_6630_(1));
        return state.m_60795_();
    }

    private void knockback() {
        this.horseman.m_20193_().m_6443_(LivingEntity.class, this.horseman.m_20191_().m_82400_(8.0), entity -> this.horseman.m_20280_((Entity)entity) < 3.75 && this.horseman.m_6779_((LivingEntity)entity) && !entity.equals((Object)this.horseman) && entity.m_20202_() == null).forEach(entity -> {
            entity.m_147240_(0.85, (double)Mth.m_14031_((float)(this.horseman.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.horseman.m_146908_() * ((float)Math.PI / 180)))));
            entity.m_6469_(this.horseman.m_269291_().m_269333_((LivingEntity)this.horseman), 1.0f);
        });
    }
}

