/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.compat.CrossbowWeapon;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.util.AttackUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecruitRangedCrossbowAttackGoal
extends Goal {
    private final CrossBowmanEntity crossBowman;
    private final double speedModifier;
    private int seeTime;
    private State state;
    private IWeapon weapon = new CrossbowWeapon();
    private LivingEntity target;
    private final double stopRange;
    private boolean consumeArrows;

    public RecruitRangedCrossbowAttackGoal(CrossBowmanEntity crossBowman, double stopRange) {
        this.crossBowman = crossBowman;
        this.speedModifier = this.weapon.getMoveSpeedAmp();
        this.stopRange = stopRange;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.consumeArrows = (Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get();
    }

    public boolean m_8036_() {
        this.target = this.crossBowman.m_5448_();
        boolean shouldRanged = this.crossBowman.getShouldRanged();
        if (this.target != null && this.target.m_6084_() && shouldRanged) {
            if (!this.isWeaponInMainHand()) {
                this.crossBowman.switchMainHandItem(RecruitRangedCrossbowAttackGoal::isCrossbow);
                return false;
            }
            return (double)this.target.m_20270_((Entity)this.crossBowman) >= this.stopRange && this.canAttackMovePos() && !this.crossBowman.needsToGetFood() && !this.crossBowman.getShouldMount();
        }
        return this.crossBowman.getShouldStrategicFire();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.crossBowman.m_21561_(true);
        this.state = State.IDLE;
    }

    public void m_8041_() {
        super.m_8041_();
        this.seeTime = 0;
        this.crossBowman.m_5810_();
        this.crossBowman.m_21561_(false);
    }

    protected boolean isWeaponInMainHand() {
        if (RecruitRangedCrossbowAttackGoal.isCrossbow(this.crossBowman.m_21205_())) {
            this.weapon = new CrossbowWeapon();
            return true;
        }
        return false;
    }

    protected static boolean isCrossbow(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42717_) || itemStack.m_41720_() instanceof CrossbowItem;
    }

    public void m_8037_() {
        block27: {
            block28: {
                if (this.target != null && this.target.m_6084_()) {
                    double distance = this.target.m_20280_((Entity)this.crossBowman);
                    boolean isClose = distance <= 150.0;
                    boolean isFar = distance >= 3500.0;
                    boolean isTooFar = distance >= 4500.0;
                    boolean inRange = !isFar;
                    boolean canSee = this.crossBowman.m_21574_().m_148306_((Entity)this.target);
                    this.seeTime = canSee ? ++this.seeTime : 0;
                    if (isTooFar) {
                        this.crossBowman.m_6710_(null);
                        this.m_8041_();
                        return;
                    }
                    if (this.crossBowman.getShouldFollow() && this.crossBowman.getOwner() != null) {
                        this.handleFollow((LivingEntity)this.crossBowman.getOwner(), inRange, isFar);
                    } else if (this.crossBowman.getShouldHoldPos() && this.crossBowman.getHoldPos() != null) {
                        this.handleHoldPos(this.crossBowman.getHoldPos(), inRange);
                    } else {
                        this.handleWander(inRange, isFar, isClose);
                    }
                }
                if (!this.isWeaponInMainHand()) break block27;
                if (!this.crossBowman.getShouldStrategicFire() || this.target != null) break block28;
                BlockPos pos = this.crossBowman.getStrategicFirePos();
                switch (this.state) {
                    case IDLE: {
                        if (this.weapon.isLoaded(this.crossBowman.m_21205_())) {
                            if (pos == null) break;
                            this.state = State.AIMING;
                            break;
                        }
                        if (!this.hasArrows()) break;
                        this.state = State.RELOAD;
                        break;
                    }
                    case RELOAD: {
                        this.crossBowman.m_6672_(InteractionHand.MAIN_HAND);
                        int i = this.crossBowman.m_21252_();
                        if (i >= this.weapon.getWeaponLoadTime()) {
                            this.crossBowman.m_21253_();
                            this.crossBowman.m_5496_(this.weapon.getLoadSound(), 1.0f, 1.0f / (this.crossBowman.m_217043_().m_188501_() * 0.4f + 0.8f));
                            CrossbowItem.m_40884_((ItemStack)this.crossBowman.m_21205_(), (boolean)true);
                            this.state = State.AIMING;
                            break;
                        }
                        break block27;
                    }
                    case AIMING: {
                        if (pos == null) break;
                        this.crossBowman.m_21561_(true);
                        this.crossBowman.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        if (++this.seeTime <= this.weapon.getWeaponLoadTime()) break;
                        this.state = State.SHOOT;
                        this.seeTime = 0;
                        break;
                    }
                    case SHOOT: {
                        if (pos != null) {
                            this.weapon.performRangedAttackIWeapon(this.crossBowman, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.weapon.getProjectileSpeed());
                            CrossbowItem.m_40884_((ItemStack)this.crossBowman.m_21205_(), (boolean)false);
                        }
                        this.state = State.IDLE;
                    }
                }
                break block27;
            }
            switch (this.state) {
                case IDLE: {
                    if (this.weapon.isLoaded(this.crossBowman.m_21205_())) {
                        if (this.target == null || !this.target.m_6084_()) break;
                        this.state = State.AIMING;
                        break;
                    }
                    if (!this.hasArrows()) break;
                    this.state = State.RELOAD;
                    break;
                }
                case RELOAD: {
                    this.crossBowman.m_6672_(InteractionHand.MAIN_HAND);
                    int i = this.crossBowman.m_21252_();
                    if (i < this.weapon.getWeaponLoadTime()) break;
                    this.crossBowman.m_21253_();
                    this.crossBowman.m_5496_(this.weapon.getLoadSound(), 1.0f, 1.0f / (this.crossBowman.m_217043_().m_188501_() * 0.4f + 0.8f));
                    CrossbowItem.m_40884_((ItemStack)this.crossBowman.m_21205_(), (boolean)true);
                    this.state = State.AIMING;
                    break;
                }
                case AIMING: {
                    if (this.target != null && this.target.m_6084_()) {
                        boolean canSee = this.crossBowman.m_21574_().m_148306_((Entity)this.target);
                        this.crossBowman.m_21561_(true);
                        this.crossBowman.m_21563_().m_148051_((Entity)this.target);
                        if (canSee) {
                            if (++this.seeTime < this.weapon.getWeaponLoadTime()) break;
                            this.state = State.SHOOT;
                            this.seeTime = 0;
                            break;
                        }
                        if (!this.crossBowman.getShouldHoldPos()) break;
                        this.crossBowman.m_6710_(null);
                        break;
                    }
                    this.crossBowman.m_21561_(false);
                    this.seeTime = 0;
                    break;
                }
                case SHOOT: {
                    LivingEntity savedTarget = null;
                    if (this.target != null && this.target.m_6084_() && this.crossBowman.m_6779_(this.target) && this.crossBowman.getState() != 3) {
                        this.crossBowman.m_21563_().m_148051_((Entity)this.target);
                        if (AttackUtil.canPerformHorseAttack(this.crossBowman, this.target) && this.target.m_20202_() instanceof LivingEntity) {
                            savedTarget = this.target;
                            this.target = (LivingEntity)this.target.m_20202_();
                        }
                        this.weapon.performRangedAttackIWeapon(this.crossBowman, this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20192_(), this.target.m_20189_(), this.weapon.getProjectileSpeed());
                        if (savedTarget != null) {
                            this.target = savedTarget;
                        }
                        CrossbowItem.m_40884_((ItemStack)this.crossBowman.m_21205_(), (boolean)false);
                    }
                    this.state = State.IDLE;
                }
            }
        }
    }

    private boolean hasArrows() {
        return !this.consumeArrows || this.crossBowman.getInventory().m_216874_(item -> item.m_204117_(ItemTags.f_13161_));
    }

    private boolean canAttackMovePos() {
        LivingEntity target = this.crossBowman.m_5448_();
        BlockPos pos = this.crossBowman.getMovePos();
        if (target != null && pos != null && this.crossBowman.getShouldMovePos()) {
            boolean posIsFar;
            boolean targetIsFar = (double)target.m_20270_((Entity)this.crossBowman) >= 32.0;
            boolean posIsClose = pos.m_123331_((Vec3i)this.crossBowman.m_20097_()) <= 15.0;
            boolean bl = posIsFar = pos.m_123331_((Vec3i)this.crossBowman.m_20097_()) > 15.0;
            if (posIsFar) {
                return false;
            }
            if (posIsClose && targetIsFar) {
                return false;
            }
        }
        return true;
    }

    private void handleFollow(@NotNull LivingEntity owner, boolean inRange, boolean isFar) {
        boolean ownerClose;
        boolean bl = ownerClose = owner.m_20280_((Entity)this.crossBowman) <= 100.0;
        if (ownerClose) {
            if (inRange) {
                this.crossBowman.m_21573_().m_26573_();
            }
            if (isFar) {
                this.crossBowman.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
        }
    }

    private void handleHoldPos(@NotNull Vec3 pos, boolean inRange) {
        boolean posClose;
        boolean bl = posClose = pos.m_82557_(this.crossBowman.m_20182_()) <= 50.0;
        if (posClose && inRange) {
            this.crossBowman.m_21573_().m_26573_();
        }
    }

    private void handleWander(boolean inRange, boolean isFar, boolean isClose) {
        if (inRange) {
            this.crossBowman.m_21573_().m_26573_();
        }
        if (isFar) {
            this.crossBowman.m_21573_().m_5624_((Entity)this.crossBowman, this.speedModifier);
        }
    }

    static enum State {
        IDLE,
        RELOAD,
        AIMING,
        SHOOT;

    }
}

