/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.compat;

import com.talhanation.recruits.compat.BlunderbussWeapon;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.compat.MusketBayonetWeapon;
import com.talhanation.recruits.compat.MusketScopeWeapon;
import com.talhanation.recruits.compat.MusketWeapon;
import com.talhanation.recruits.compat.PistolWeapon;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.util.AttackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecruitRangedMusketAttackGoal
extends Goal {
    private final CrossBowmanEntity crossBowman;
    private final double speedModifier;
    private int seeTime;
    private State state;
    private LivingEntity target;
    private IWeapon weapon = new MusketWeapon();
    private int weaponLoadTime;
    private final double stopRange;

    public RecruitRangedMusketAttackGoal(CrossBowmanEntity crossBowman, double stopRange) {
        this.crossBowman = crossBowman;
        this.speedModifier = this.weapon.getMoveSpeedAmp();
        this.stopRange = stopRange;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.crossBowman.m_5448_();
        boolean shouldRanged = this.crossBowman.getShouldRanged();
        if (livingentity != null && livingentity.m_6084_() && shouldRanged) {
            if (!this.isWeaponInHand()) {
                this.crossBowman.switchMainHandItem(RecruitRangedMusketAttackGoal::isMusket);
                return false;
            }
            return (double)livingentity.m_20270_((Entity)this.crossBowman) >= this.stopRange && this.canAttackMovePos() && !this.crossBowman.needsToGetFood() && !this.crossBowman.getShouldMount();
        }
        return this.crossBowman.getShouldStrategicFire() || this.isWeaponInHand() && this.weapon != null && !this.weapon.isLoaded(this.crossBowman.m_21205_());
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.crossBowman.m_21561_(true);
        this.state = State.IDLE;
        this.weaponLoadTime = this.crossBowman.m_20159_() ? this.weapon.getWeaponLoadTime() * 2 : this.weapon.getWeaponLoadTime();
    }

    public void m_8041_() {
        super.m_8041_();
        this.seeTime = 0;
        this.weaponLoadTime = 0;
        this.crossBowman.m_5810_();
        this.crossBowman.m_21561_(false);
    }

    protected boolean isWeaponInHand() {
        ItemStack itemStack = this.crossBowman.m_21205_();
        if (itemStack.m_41778_().equals("item.musketmod.musket")) {
            this.weapon = new MusketWeapon();
            return true;
        }
        if (itemStack.m_41778_().equals("item.musketmod.musket_with_bayonet")) {
            this.weapon = new MusketBayonetWeapon();
            return true;
        }
        if (itemStack.m_41778_().equals("item.musketmod.musket_with_scope")) {
            this.weapon = new MusketScopeWeapon();
            return true;
        }
        if (itemStack.m_41778_().equals("item.musketmod.blunderbuss")) {
            this.weapon = new BlunderbussWeapon();
            return true;
        }
        if (itemStack.m_41778_().equals("item.musketmod.pistol")) {
            this.weapon = new PistolWeapon();
            return true;
        }
        return false;
    }

    public static boolean isMusket(ItemStack itemStack) {
        String disc = itemStack.m_41778_();
        return disc.equals("item.musketmod.musket") || disc.equals("item.musketmod.musket_with_bayonet") || disc.equals("item.musketmod.musket_with_scope") || disc.equals("item.musketmod.blunderbuss") || disc.equals("item.musketmod.pistol");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void m_8037_() {
        this.target = this.crossBowman.m_5448_();
        if (this.target != null && this.target.m_6084_()) {
            double distance = this.target.m_20280_((Entity)this.crossBowman);
            boolean isClose = distance <= 150.0;
            boolean isFar = distance >= 3500.0;
            boolean isTooFar = distance >= 4500.0;
            boolean inRange = !isFar;
            boolean canSee = this.crossBowman.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (isTooFar) {
                this.crossBowman.m_6710_(null);
                this.m_8041_();
                return;
            }
            if (this.crossBowman.getShouldFollow() && this.crossBowman.getOwner() != null) {
                this.handleFollow((LivingEntity)this.crossBowman.getOwner(), inRange, isFar);
            } else if (this.crossBowman.getShouldHoldPos() && this.crossBowman.getHoldPos() != null) {
                this.handleHoldPos(this.crossBowman.getHoldPos(), inRange);
            } else {
                this.handleWander(inRange, isFar, isClose);
            }
        }
        if (!this.isWeaponInHand()) return;
        if (this.crossBowman.getShouldStrategicFire() && this.target == null) {
            BlockPos pos = this.crossBowman.getStrategicFirePos();
            if (pos == null) return;
            switch (this.state) {
                case IDLE: {
                    this.crossBowman.m_21561_(false);
                    State newState = !this.weapon.isLoaded(this.crossBowman.m_21205_()) ? (this.canLoad() ? State.RELOAD : State.IDLE) : State.AIMING;
                    this.state = newState;
                    return;
                }
                case RELOAD: {
                    this.crossBowman.m_6672_(InteractionHand.MAIN_HAND);
                    int i = this.crossBowman.m_21252_();
                    if (i < this.weaponLoadTime) return;
                    this.crossBowman.m_21253_();
                    this.crossBowman.m_5496_(this.weapon.getLoadSound(), 1.0f, 1.0f / (this.crossBowman.m_217043_().m_188501_() * 0.4f + 0.8f));
                    this.weapon.setLoaded(this.crossBowman.m_21205_(), true);
                    this.consumeAmmo();
                    this.state = State.AIMING;
                    return;
                }
                case AIMING: {
                    this.crossBowman.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
                    this.crossBowman.m_21561_(true);
                    ++this.seeTime;
                    if (this.seeTime < 15 + this.crossBowman.m_217043_().m_188503_(15)) return;
                    this.seeTime = 0;
                    this.state = State.SHOOT;
                    return;
                }
                case SHOOT: {
                    this.crossBowman.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
                    this.weapon.performRangedAttackIWeapon(this.crossBowman, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.weapon.getProjectileSpeed());
                    this.weapon.setLoaded(this.crossBowman.m_21205_(), false);
                    this.state = this.canLoad() ? State.RELOAD : State.IDLE;
                }
            }
            return;
        } else {
            switch (this.state) {
                case IDLE: {
                    this.crossBowman.m_21561_(false);
                    State newState = !this.weapon.isLoaded(this.crossBowman.m_21205_()) ? (this.canLoad() ? State.RELOAD : State.IDLE) : (this.target != null && this.target.m_6084_() ? State.AIMING : State.IDLE);
                    this.state = newState;
                    return;
                }
                case RELOAD: {
                    this.crossBowman.m_6672_(InteractionHand.MAIN_HAND);
                    int i = this.crossBowman.m_21252_();
                    if (i < this.weaponLoadTime) return;
                    this.crossBowman.m_21253_();
                    this.crossBowman.m_5496_(this.weapon.getLoadSound(), 1.0f, 1.0f / (this.crossBowman.m_217043_().m_188501_() * 0.4f + 0.8f));
                    this.weapon.setLoaded(this.crossBowman.m_21205_(), true);
                    this.consumeAmmo();
                    if (this.target != null && this.target.m_6084_()) {
                        this.state = State.AIMING;
                        return;
                    }
                    this.state = State.IDLE;
                    return;
                }
                case AIMING: {
                    boolean canSee;
                    boolean bl = canSee = this.target != null && this.crossBowman.m_21574_().m_148306_((Entity)this.target) && this.target.m_6084_();
                    if (canSee) {
                        this.crossBowman.m_21563_().m_148051_((Entity)this.target);
                        this.crossBowman.m_21561_(true);
                        ++this.seeTime;
                        if (this.seeTime < 10 + this.crossBowman.m_217043_().m_188503_(8)) return;
                        this.state = State.SHOOT;
                        this.seeTime = 0;
                        return;
                    }
                    this.crossBowman.m_21561_(false);
                    this.seeTime = 0;
                    this.state = State.IDLE;
                    return;
                }
                case SHOOT: {
                    LivingEntity savedTarget = null;
                    if (this.target != null && this.target.m_6084_() && this.crossBowman.m_6779_(this.target) && this.crossBowman.getState() != 3) {
                        this.crossBowman.m_21563_().m_148051_((Entity)this.target);
                        if (AttackUtil.canPerformHorseAttack(this.crossBowman, this.target) && this.target.m_20202_() instanceof LivingEntity) {
                            savedTarget = this.target;
                            this.target = (LivingEntity)this.target.m_20202_();
                        }
                        this.weapon.performRangedAttackIWeapon(this.crossBowman, this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), this.weapon.getProjectileSpeed());
                        if (savedTarget != null) {
                            this.target = savedTarget;
                        }
                        this.weapon.setLoaded(this.crossBowman.m_21205_(), false);
                    }
                    this.state = this.canLoad() ? State.RELOAD : State.IDLE;
                }
            }
        }
    }

    private void consumeAmmo() {
        NonNullList items = this.crossBowman.getInventory().f_19147_;
        for (ItemStack stack : items) {
            if (!stack.m_41778_().equals("item.musketmod.cartridge")) continue;
            stack.m_41774_(1);
            break;
        }
    }

    private boolean canLoad() {
        return this.crossBowman.getInventory().f_19147_.stream().anyMatch(itemStack -> itemStack.m_41778_().equals("item.musketmod.cartridge"));
    }

    public void checkHands() {
    }

    private void switchWeaponToMainHandFromOffHand() {
        ItemStack off = this.crossBowman.m_21206_().m_41777_().m_41777_();
        this.crossBowman.getInventory().m_6836_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.MAINHAND), off);
        this.crossBowman.m_8061_(EquipmentSlot.MAINHAND, off);
        this.crossBowman.getInventory().m_8016_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.OFFHAND));
        this.crossBowman.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.crossBowman.getInventory().m_6836_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.OFFHAND), ItemStack.f_41583_);
        this.checkHands();
    }

    private void switchWeaponToOffHandFromMainHand() {
        ItemStack main = this.crossBowman.m_21205_().m_41777_().m_41777_();
        this.crossBowman.getInventory().m_6836_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.OFFHAND), main);
        this.crossBowman.m_8061_(EquipmentSlot.OFFHAND, main);
        this.crossBowman.getInventory().m_8016_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.MAINHAND));
        this.crossBowman.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.crossBowman.getInventory().m_6836_(this.crossBowman.getInventorySlotIndex(EquipmentSlot.MAINHAND), ItemStack.f_41583_);
        this.checkHands();
    }

    private boolean canAttackMovePos() {
        LivingEntity target = this.crossBowman.m_5448_();
        BlockPos pos = this.crossBowman.getMovePos();
        if (target != null && pos != null && this.crossBowman.getShouldMovePos()) {
            boolean posIsFar;
            boolean targetIsFar = (double)target.m_20270_((Entity)this.crossBowman) >= 21.5;
            boolean posIsClose = pos.m_123331_((Vec3i)this.crossBowman.m_20097_()) <= 15.0;
            boolean bl = posIsFar = pos.m_123331_((Vec3i)this.crossBowman.m_20097_()) > 15.0;
            if (posIsFar) {
                return false;
            }
            if (posIsClose && targetIsFar) {
                return false;
            }
        }
        return true;
    }

    private void handleFollow(@NotNull LivingEntity owner, boolean inRange, boolean isFar) {
        boolean ownerClose;
        boolean bl = ownerClose = owner.m_20280_((Entity)this.crossBowman) <= 100.0;
        if (ownerClose) {
            if (inRange) {
                this.crossBowman.m_21573_().m_26573_();
            }
            if (isFar) {
                this.crossBowman.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
        }
    }

    private void handleHoldPos(@NotNull Vec3 pos, boolean inRange) {
        boolean posClose;
        boolean bl = posClose = pos.m_82557_(this.crossBowman.m_20182_()) <= 50.0;
        if (posClose && inRange) {
            this.crossBowman.m_21573_().m_26573_();
        }
    }

    private void handleWander(boolean inRange, boolean isFar, boolean isClose) {
        if (inRange) {
            this.crossBowman.m_21573_().m_26573_();
        }
        if (isFar) {
            this.crossBowman.m_21573_().m_5624_((Entity)this.crossBowman, this.speedModifier);
        }
    }

    static enum State {
        IDLE,
        RELOAD,
        AIMING,
        SHOOT;

    }
}

