/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.navigation;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.navigation.RecruitPathNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class RecruitsDoorInteractGoal
extends Goal {
    protected AbstractRecruitEntity recruit;
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public RecruitsDoorInteractGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.recruit.m_20193_().m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_);
    }

    protected void setOpen(boolean open) {
        if (this.hasDoor) {
            BlockState blockstate = this.recruit.m_20193_().m_8055_(this.doorPos);
            if (blockstate.m_60734_() instanceof FenceGateBlock) {
                this.useGate(blockstate, this.recruit.m_20193_(), this.doorPos, (Entity)this.recruit);
            } else {
                Block block = blockstate.m_60734_();
                if (block instanceof DoorBlock) {
                    DoorBlock doorBlock = (DoorBlock)block;
                    doorBlock.m_153165_((Entity)this.recruit, this.recruit.m_20193_(), blockstate, this.doorPos, open);
                }
            }
            for (Direction direction : Direction.values()) {
                if (direction.equals((Object)Direction.DOWN)) continue;
                BlockPos blockPos = this.doorPos.m_121945_(direction);
                BlockState state = this.recruit.m_20193_().m_8055_(blockPos);
                if (state.m_60734_() instanceof FenceGateBlock) {
                    this.useGate(blockstate, this.recruit.m_20193_(), blockPos, (Entity)this.recruit);
                    continue;
                }
                Block block = state.m_60734_();
                if (!(block instanceof DoorBlock)) continue;
                DoorBlock doorBlock = (DoorBlock)block;
                doorBlock.m_153165_((Entity)this.recruit, this.recruit.m_20193_(), blockstate, this.doorPos, open);
            }
        }
    }

    public boolean m_8036_() {
        if (!GoalUtils.m_26894_((Mob)this.recruit)) {
            return false;
        }
        if (!this.recruit.f_19862_) {
            return false;
        }
        RecruitPathNavigation groundpathnavigation = (RecruitPathNavigation)this.recruit.m_21573_();
        Path path = groundpathnavigation.m_26570_();
        if (path != null && !path.m_77392_() && groundpathnavigation.canOpenDoors()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.doorPos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
                if (this.recruit.m_20275_(this.doorPos.m_123341_(), this.recruit.m_20186_(), this.doorPos.m_123343_()) > 5.0) continue;
                boolean bl = this.hasDoor = DoorBlock.m_52745_((Level)this.recruit.m_20193_(), (BlockPos)this.doorPos) || this.recruit.m_20193_().m_8055_(this.doorPos).m_60734_() instanceof FenceGateBlock;
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.recruit.m_20183_().m_7494_();
            this.hasDoor = DoorBlock.m_52745_((Level)this.recruit.m_20193_(), (BlockPos)this.doorPos) || this.recruit.m_20193_().m_8055_(this.doorPos).m_60734_() instanceof FenceGateBlock;
            return this.hasDoor;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.recruit.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.recruit.m_20189_());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.recruit.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.recruit.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }

    public void useGate(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (((Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.FALSE);
            level.m_7731_(blockPos, blockState, 10);
        } else {
            Direction direction = entity.m_6350_();
            if (blockState.m_61143_((Property)FenceGateBlock.f_54117_) == direction.m_122424_()) {
                blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)direction);
            }
            blockState = (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.TRUE);
            level.m_7731_(blockPos, blockState, 10);
        }
        boolean flag = (Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_);
        level.m_142346_(entity, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, blockPos);
    }
}

