/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAssignGroupToPlayer
implements Message<MessageAssignGroupToPlayer> {
    private UUID owner;
    private CompoundTag tag;
    private UUID groupUUID;
    private boolean keepTeam;

    public MessageAssignGroupToPlayer() {
    }

    public MessageAssignGroupToPlayer(UUID owner, RecruitsPlayerInfo newOwner, UUID groupUUID) {
        this.owner = owner;
        this.tag = newOwner.toNBT();
        this.groupUUID = groupUUID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        RecruitsGroup group = RecruitEvents.recruitsGroupsManager.getGroup(this.groupUUID);
        ServerLevel serverLevel = (ServerLevel)player.m_20193_();
        if (group == null) {
            return;
        }
        RecruitsPlayerInfo newOwner = RecruitsPlayerInfo.getFromNBT(this.tag);
        group.setPlayer(newOwner);
        List list = player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0));
        for (AbstractRecruitEntity recruit : list) {
            if (recruit.getGroup() == null || !recruit.getGroup().equals(this.groupUUID)) continue;
            recruit.setOwnerUUID(Optional.of(newOwner.getUUID()));
            recruit.needsGroupUpdate = true;
        }
        RecruitEvents.recruitsGroupsManager.save(serverLevel);
        RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer((Player)player);
        RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer((ServerLevel)player.m_20193_(), newOwner.getUUID());
        FactionEvents.notifyPlayer(serverLevel, newOwner, 2, group.getName());
    }

    @Override
    public MessageAssignGroupToPlayer fromBytes(FriendlyByteBuf buf) {
        this.owner = buf.m_130259_();
        this.tag = buf.m_130260_();
        this.groupUUID = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.owner);
        buf.m_130079_(this.tag);
        buf.m_130077_(this.groupUUID);
    }
}

