/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageDisbandGroup
implements Message<MessageDisbandGroup> {
    private UUID owner;
    private UUID groupUUID;
    private boolean keepTeam;

    public MessageDisbandGroup() {
    }

    public MessageDisbandGroup(UUID owner, UUID groupUUID, boolean keepTeam) {
        this.owner = owner;
        this.groupUUID = groupUUID;
        this.keepTeam = keepTeam;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        RecruitsGroup group = RecruitEvents.recruitsGroupsManager.getGroup(this.groupUUID);
        if (group == null) {
            return;
        }
        group.setDisbandContext(new RecruitsGroup.DisbandContext(true, this.keepTeam, true));
        RecruitEvents.recruitsGroupsManager.broadCastGroupsToPlayer((Player)player);
        List list = player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0));
        for (AbstractRecruitEntity recruit : list) {
            recruit.needsGroupUpdate = true;
        }
    }

    @Override
    public MessageDisbandGroup fromBytes(FriendlyByteBuf buf) {
        this.owner = buf.m_130259_();
        this.groupUUID = buf.m_130259_();
        this.keepTeam = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.owner);
        buf.m_130077_(this.groupUUID);
        buf.writeBoolean(this.keepTeam);
    }
}

