/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMovement
implements Message<MessageMovement> {
    private UUID player_uuid;
    private int state;
    private UUID group;
    private int formation;

    public MessageMovement() {
    }

    public MessageMovement(UUID player_uuid, int state, UUID group, int formation) {
        this.player_uuid = player_uuid;
        this.state = state;
        this.group = group;
        this.formation = formation;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        List list = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(100.0));
        list.removeIf(recruit -> !recruit.isEffectedByCommand(this.player_uuid, this.group));
        CommandEvents.onMovementCommand(context.getSender(), list, this.state, this.formation);
    }

    @Override
    public MessageMovement fromBytes(FriendlyByteBuf buf) {
        this.player_uuid = buf.m_130259_();
        this.state = buf.readInt();
        this.group = buf.m_130259_();
        this.formation = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player_uuid);
        buf.writeInt(this.state);
        buf.m_130077_(this.group);
        buf.writeInt(this.formation);
    }
}

